/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ChangeFeedProcessorOptions {
    public static final Duration DEFAULT_RENEW_INTERVAL = Duration.ofMillis(0L).plusSeconds(17L);
    public static final boolean DEFAULT_LEASE_VERIFICATION_ON_RESTART_ENABLED = false;
    public static final Duration DEFAULT_ACQUIRE_INTERVAL = Duration.ofMillis(0L).plusSeconds(13L);
    public static final Duration DEFAULT_EXPIRATION_INTERVAL = Duration.ofMillis(0L).plusSeconds(60L);
    public static final Duration DEFAULT_FEED_POLL_DELAY = Duration.ofMillis(0L).plusSeconds(5L);
    private Duration leaseRenewInterval = DEFAULT_RENEW_INTERVAL;
    private Duration leaseAcquireInterval = DEFAULT_ACQUIRE_INTERVAL;
    private Duration leaseExpirationInterval = DEFAULT_EXPIRATION_INTERVAL;
    private Duration feedPollDelay = DEFAULT_FEED_POLL_DELAY;
    private String leasePrefix;
    private int maxItemCount = 100;
    private String startContinuation;
    private Instant startTime;
    private boolean startFromBeginning = false;
    private int minScaleCount;
    private int maxScaleCount = 0;
    private boolean leaseVerificationOnRestartEnabled = false;
    private Scheduler scheduler = Schedulers.boundedElastic();
    private ThroughputControlGroupConfig feedPollThroughputControlGroupConfig = null;

    public Duration getLeaseRenewInterval() {
        return this.leaseRenewInterval;
    }

    public ChangeFeedProcessorOptions setLeaseRenewInterval(Duration leaseRenewInterval) {
        this.leaseRenewInterval = leaseRenewInterval;
        return this;
    }

    public Duration getLeaseAcquireInterval() {
        return this.leaseAcquireInterval;
    }

    public ChangeFeedProcessorOptions setLeaseAcquireInterval(Duration leaseAcquireInterval) {
        this.leaseAcquireInterval = leaseAcquireInterval;
        return this;
    }

    public Duration getLeaseExpirationInterval() {
        return this.leaseExpirationInterval;
    }

    public ChangeFeedProcessorOptions setLeaseExpirationInterval(Duration leaseExpirationInterval) {
        this.leaseExpirationInterval = leaseExpirationInterval;
        return this;
    }

    public Duration getFeedPollDelay() {
        return this.feedPollDelay;
    }

    public ChangeFeedProcessorOptions setFeedPollDelay(Duration feedPollDelay) {
        this.feedPollDelay = feedPollDelay;
        return this;
    }

    public String getLeasePrefix() {
        return this.leasePrefix;
    }

    public ChangeFeedProcessorOptions setLeasePrefix(String leasePrefix) {
        this.leasePrefix = leasePrefix;
        return this;
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }

    public ChangeFeedProcessorOptions setMaxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public String getStartContinuation() {
        return this.startContinuation;
    }

    public ChangeFeedProcessorOptions setStartContinuation(String startContinuation) {
        this.startContinuation = startContinuation;
        return this;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public ChangeFeedProcessorOptions setStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public boolean isStartFromBeginning() {
        return this.startFromBeginning;
    }

    public ChangeFeedProcessorOptions setStartFromBeginning(boolean startFromBeginning) {
        this.startFromBeginning = startFromBeginning;
        return this;
    }

    public int getMinScaleCount() {
        return this.minScaleCount;
    }

    public ChangeFeedProcessorOptions setMinScaleCount(int minScaleCount) {
        this.minScaleCount = minScaleCount;
        return this;
    }

    public int getMaxScaleCount() {
        return this.maxScaleCount;
    }

    public ChangeFeedProcessorOptions setMaxScaleCount(int maxScaleCount) {
        this.maxScaleCount = maxScaleCount;
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ChangeFeedProcessorOptions setScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler");
        }
        this.scheduler = scheduler;
        return this;
    }

    public ChangeFeedProcessorOptions setFeedPollThroughputControlConfig(ThroughputControlGroupConfig feedPollThroughputControlGroupConfig) {
        Preconditions.checkNotNull(feedPollThroughputControlGroupConfig, "Argument 'feedPollThroughputControlGroupConfig' can not be null");
        this.feedPollThroughputControlGroupConfig = feedPollThroughputControlGroupConfig;
        return this;
    }

    public ThroughputControlGroupConfig getFeedPollThroughputControlGroupConfig() {
        return this.feedPollThroughputControlGroupConfig;
    }

    public ChangeFeedProcessorOptions setLeaseVerificationEnabledOnRestart(boolean enableLeaseVerificationOnRestart) {
        this.leaseVerificationOnRestartEnabled = enableLeaseVerificationOnRestart;
        return this;
    }

    public boolean isLeaseVerificationEnabledOnRestart() {
        return this.leaseVerificationOnRestartEnabled;
    }
}

