/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosBulkExecutionOptionsImpl;
import com.azure.cosmos.implementation.UUIDs;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionScopeThresholds {
    private static final Logger logger = LoggerFactory.getLogger(PartitionScopeThresholds.class);
    private final String pkRangeId;
    private final CosmosBulkExecutionOptionsImpl options;
    private final AtomicInteger targetMicroBatchSize;
    private final AtomicLong totalOperationCount;
    private final AtomicReference<CurrentIntervalThresholds> currentThresholds;
    private final String identifier = UUIDs.nonBlockingRandomUUID().toString();
    private final double minRetryRate;
    private final double maxRetryRate;
    private final double avgRetryRate;
    private final int maxMicroBatchSize;
    private final int minTargetMicroBatchSize;

    public PartitionScopeThresholds(String pkRangeId, CosmosBulkExecutionOptionsImpl options) {
        Preconditions.checkNotNull(pkRangeId, "expected non-null pkRangeId");
        Preconditions.checkNotNull(options, "expected non-null options");
        this.pkRangeId = pkRangeId;
        this.options = options;
        this.totalOperationCount = new AtomicLong(0L);
        this.currentThresholds = new AtomicReference<CurrentIntervalThresholds>(new CurrentIntervalThresholds());
        this.minRetryRate = options.getMinTargetedMicroBatchRetryRate();
        this.maxRetryRate = options.getMaxTargetedMicroBatchRetryRate();
        this.avgRetryRate = (this.maxRetryRate + this.minRetryRate) / 2.0;
        this.maxMicroBatchSize = Math.min(options.getMaxMicroBatchSize(), 100);
        this.minTargetMicroBatchSize = Math.max(options.getMinTargetMicroBatchSize(), Configs.getMinTargetBulkMicroBatchSize());
        this.targetMicroBatchSize = new AtomicInteger(Math.max(Math.min(options.getInitialMicroBatchSize(), this.maxMicroBatchSize), Math.min(this.minTargetMicroBatchSize, this.maxMicroBatchSize)));
    }

    public String getPartitionKeyRangeId() {
        return this.pkRangeId;
    }

    private Pair<Boolean, Boolean> shouldReevaluateThresholds(long totalSnapshot, long currentSnapshot) {
        if (totalSnapshot < 1000L) {
            return Pair.of(currentSnapshot == 100L, false);
        }
        if (totalSnapshot < 10000L) {
            return Pair.of(currentSnapshot == 1000L, false);
        }
        return Pair.of(currentSnapshot % 1000L == 0L, currentSnapshot % 10000L == 0L);
    }

    private void recordOperation(boolean isRetry) {
        boolean onlyUpscale;
        long totalSnapshot = this.totalOperationCount.incrementAndGet();
        CurrentIntervalThresholds currentThresholdsSnapshot = this.currentThresholds.get();
        long currentTotalCountSnapshot = currentThresholdsSnapshot.currentOperationCount.incrementAndGet();
        long currentRetryCountSnapshot = isRetry ? currentThresholdsSnapshot.currentRetriedOperationCount.incrementAndGet() : currentThresholdsSnapshot.currentRetriedOperationCount.get();
        Pair<Boolean, Boolean> shouldReevaluateResult = this.shouldReevaluateThresholds(totalSnapshot, currentTotalCountSnapshot);
        boolean shouldReevaluate = shouldReevaluateResult.getLeft();
        if (shouldReevaluate && ((onlyUpscale = shouldReevaluateResult.getRight().booleanValue()) || this.currentThresholds.compareAndSet(currentThresholdsSnapshot, new CurrentIntervalThresholds()))) {
            this.reevaluateThresholds(totalSnapshot, currentTotalCountSnapshot, currentRetryCountSnapshot, shouldReevaluateResult.getRight());
        }
    }

    private void reevaluateThresholds(long totalCount, long currentCount, long retryCount, boolean onlyUpscale) {
        double deltaRate;
        int targetedNewBatchSize;
        int microBatchSizeBefore;
        double retryRate = currentCount == 0L ? 0.0 : (double)retryCount / (double)currentCount;
        int microBatchSizeAfter = microBatchSizeBefore = this.targetMicroBatchSize.get();
        if (retryRate < this.minRetryRate && microBatchSizeBefore < this.maxMicroBatchSize) {
            int targetedNewBatchSize2 = Math.min(Math.max(Math.min(microBatchSizeBefore * 2, microBatchSizeBefore + (int)((double)this.maxMicroBatchSize * this.avgRetryRate)), this.minTargetMicroBatchSize), this.maxMicroBatchSize);
            if (this.targetMicroBatchSize.compareAndSet(microBatchSizeBefore, targetedNewBatchSize2)) {
                microBatchSizeAfter = targetedNewBatchSize2;
            }
        } else if (!onlyUpscale && retryRate > this.maxRetryRate && microBatchSizeBefore > 1 && this.targetMicroBatchSize.compareAndSet(microBatchSizeBefore, targetedNewBatchSize = Math.min(Math.max(this.minTargetMicroBatchSize, (int)((double)microBatchSizeBefore * (1.0 - (deltaRate = retryRate - this.avgRetryRate)))), this.maxMicroBatchSize))) {
            microBatchSizeAfter = targetedNewBatchSize;
        }
        logger.debug("Reevaluated thresholds for PKRange '{}#{}' (TotalCount: {}, CurrentCount: {}, CurrentRetryCount: {}, CurrentRetryRate: {} - BatchSize {} -> {}, OnlyUpscale: {})", new Object[]{this.pkRangeId, this.identifier, totalCount, currentCount, retryCount, retryRate, microBatchSizeBefore, microBatchSizeAfter, onlyUpscale});
    }

    public void recordSuccessfulOperation() {
        this.recordOperation(false);
    }

    public void recordEnqueuedRetry() {
        this.recordOperation(true);
    }

    public int getTargetMicroBatchSizeSnapshot() {
        return this.targetMicroBatchSize.get();
    }

    public CurrentIntervalThresholds getCurrentThresholds() {
        return this.currentThresholds.get();
    }

    public long getTotalOperationCountSnapshot() {
        return this.totalOperationCount.longValue();
    }

    static class CurrentIntervalThresholds {
        public final AtomicLong currentOperationCount = new AtomicLong(0L);
        public final AtomicLong currentRetriedOperationCount = new AtomicLong(0L);

        CurrentIntervalThresholds() {
        }
    }
}

