/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DistinctClientSideRequestStatisticsCollection;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava27.Strings;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedResponseDiagnostics {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedResponseDiagnostics.class);
    private Map<String, QueryMetrics> queryMetricsMap;
    private QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext;
    private final Collection<ClientSideRequestStatistics> clientSideRequestStatistics;

    public FeedResponseDiagnostics(Map<String, QueryMetrics> queryMetricsMap, Collection<ClientSideRequestStatistics> clientSideRequestStatistics) {
        this.queryMetricsMap = queryMetricsMap;
        this.clientSideRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
        if (clientSideRequestStatistics != null) {
            this.clientSideRequestStatistics.addAll(clientSideRequestStatistics);
        }
    }

    public FeedResponseDiagnostics(FeedResponseDiagnostics toBeCloned) {
        if (toBeCloned.queryMetricsMap != null) {
            this.queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>(toBeCloned.queryMetricsMap);
        }
        this.clientSideRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
        this.clientSideRequestStatistics.addAll(toBeCloned.clientSideRequestStatistics);
        if (this.diagnosticsContext != null) {
            this.diagnosticsContext = new QueryInfo.QueryPlanDiagnosticsContext(toBeCloned.diagnosticsContext.getStartTimeUTC(), toBeCloned.diagnosticsContext.getEndTimeUTC(), toBeCloned.diagnosticsContext.getRequestTimeline());
        }
    }

    public Map<String, QueryMetrics> getQueryMetricsMap() {
        return this.queryMetricsMap;
    }

    public String toString() {
        try {
            return Utils.getDurationEnabledObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            LOGGER.debug("could not convert {} value to JSON due to:", this.getClass(), (Object)error);
            try {
                return Strings.lenientFormat("{\"error\":%s}", Utils.getDurationEnabledObjectMapper().writeValueAsString((Object)error.toString()));
            }
            catch (JsonProcessingException exception) {
                return "null";
            }
        }
    }

    public void setDiagnosticsContext(QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext) {
        this.diagnosticsContext = diagnosticsContext;
    }

    public QueryInfo.QueryPlanDiagnosticsContext getQueryPlanDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    public Collection<ClientSideRequestStatistics> getClientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public void addClientSideRequestStatistics(Collection<ClientSideRequestStatistics> requestStatistics) {
        this.clientSideRequestStatistics.addAll(requestStatistics);
    }

    public String getUserAgent() {
        if (this.clientSideRequestStatistics != null && !this.clientSideRequestStatistics.isEmpty()) {
            return this.clientSideRequestStatistics.stream().findFirst().get().getUserAgent();
        }
        return Utils.getUserAgent();
    }

    public FeedResponseDiagnostics setSamplingRateSnapshot(double samplingRateSnapshot) {
        for (ClientSideRequestStatistics c : this.clientSideRequestStatistics) {
            c.setSamplingRateSnapshot(samplingRateSnapshot);
        }
        return this;
    }
}

