/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.data;

import com.dbeaver.ee.influxdb2.exec.Influx2ResultSet;
import com.dbeaver.ee.influxdb2.exec.Influx2ResultSetMetaColumn;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.dbeaver.ee.influxdb2.model.Influx2Measurement;
import com.dbeaver.ee.influxdb2.model.Influx2MeasurementField;
import com.dbeaver.ee.influxdb2.model.Influx2MeasurementTag;
import com.dbeaver.model.timeseries.TSDataProvider;
import com.dbeaver.model.timeseries.TSMeasurement;
import com.dbeaver.model.timeseries.TSPoint;
import com.dbeaver.model.timeseries.TSProjection;
import com.influxdb.query.FluxColumn;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.utils.CommonUtils;

public class Influx2TimeSeriesDataProvider
implements TSDataProvider {
    private static final Log log = Log.getLog(Influx2TimeSeriesDataProvider.class);
    private final DBSDataContainer dataContainer;
    private FluxTable table;
    private final Set<String> fieldNames = new HashSet<String>();
    private final Map<String, Set<String>> tagValues = new LinkedHashMap<String, Set<String>>();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String seriesName;

    public Influx2TimeSeriesDataProvider(DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initData(DBDAttributeBinding[] metaData, Object[][] data) throws DBException {
        if (metaData.length == 0) {
            return;
        }
        Influx2ResultSet resultSet = ((Influx2ResultSetMetaColumn)metaData[0].getMetaAttribute()).getResultSet();
        Influx2Database database = resultSet.getSourceStatement().getCurrentDatabase();
        this.table = resultSet.getTable();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        List<Influx2Measurement> measurements = database.getMeasurements((DBRProgressMonitor)monitor);
        if (this.dataContainer instanceof Influx2Measurement || this.dataContainer instanceof Influx2MeasurementField) {
            this.seriesName = this.dataContainer.getName();
            String tableName = resultSet.getTableName();
            if (CommonUtils.isEmpty((String)tableName)) {
                return;
            }
            Influx2Measurement object = (Influx2Measurement)DBUtils.findObject(measurements, (String)tableName);
            if (object == null) throw new DBException("Measurement '" + tableName + "' not found");
            if (this.readFields((DBRProgressMonitor)monitor, object)) {
                this.readTagsAndFieldsFromData();
                return;
            }
            this.readTagValues((DBRProgressMonitor)monitor, object);
            return;
        } else {
            this.readTagsAndFieldsFromData();
        }
    }

    private boolean readFields(@NotNull DBRProgressMonitor monitor, @NotNull Influx2Measurement object) throws DBException {
        if (this.dataContainer instanceof Influx2MeasurementField && ((Influx2MeasurementField)this.dataContainer).getDataKind() == DBPDataKind.NUMERIC) {
            this.fieldNames.add(this.seriesName);
        } else {
            List<Influx2MeasurementField> fields = object.getFields(monitor);
            if (fields.isEmpty()) {
                return true;
            }
            for (Influx2MeasurementField field : fields) {
                if (field.getDataKind() != DBPDataKind.NUMERIC) continue;
                this.fieldNames.add(field.getName());
            }
        }
        return false;
    }

    private void readTagValues(@NotNull DBRProgressMonitor monitor, @NotNull Influx2Measurement object) throws DBException {
        for (Influx2MeasurementTag tag : object.getTags(monitor)) {
            if (tag.getName().startsWith("_")) continue;
            HashSet<String> values = new HashSet<String>(tag.getTagValues(monitor));
            this.tagValues.put(tag.getName(), values);
        }
    }

    private void readTagsAndFieldsFromData() {
        this.seriesName = this.dataContainer.getName();
        for (FluxColumn column : this.table.getColumns()) {
            if (column.getLabel().startsWith("_")) continue;
            this.tagValues.put(column.getLabel(), new HashSet());
        }
        for (FluxRecord record : this.table.getRecords()) {
            this.fieldNames.add(record.getField());
            for (Map.Entry<String, Set<String>> tag : this.tagValues.entrySet()) {
                this.tagValues.get(tag.getKey()).add(CommonUtils.toString((Object)record.getValueByKey(tag.getKey())));
            }
        }
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    @NotNull
    public List<TSMeasurement> getMeasurements() {
        LinkedHashSet<TSMeasurement> measurements = new LinkedHashSet<TSMeasurement>();
        if (!CommonUtils.isEmpty(this.fieldNames)) {
            for (String fieldName : this.fieldNames) {
                measurements.add(new TSMeasurement(fieldName));
            }
        }
        return new ArrayList<TSMeasurement>(measurements);
    }

    @Nullable
    public List<TSProjection> getProjections(Object[][] data) {
        if (this.table == null) {
            return null;
        }
        ArrayList<TSProjection> projections = new ArrayList<TSProjection>();
        for (String tagName : this.tagValues.keySet()) {
            Set<String> values = this.tagValues.get(tagName);
            if (CommonUtils.isEmpty(values)) continue;
            for (String value : values) {
                projections.add(new TSProjection(tagName, value));
            }
        }
        return projections;
    }

    @NotNull
    public List<TSPoint> getPoints(@NotNull TSMeasurement measurement, @Nullable TSProjection projection, Object[][] rowData) throws DBException {
        ArrayList<TSPoint> points = new ArrayList<TSPoint>();
        if (this.table != null && this.table.getRecords() != null) {
            int timeColumnIndex = -1;
            int measureColumnIndex = -1;
            int projectIndex = -1;
            int fieldTypeColumnIndex = -1;
            for (FluxColumn column : this.table.getColumns()) {
                if (column.getLabel().equals("_time")) {
                    timeColumnIndex = column.getIndex();
                }
                if (column.getLabel().equals("_value")) {
                    measureColumnIndex = column.getIndex();
                }
                if (projection != null && column.getLabel().equals(projection.getName())) {
                    projectIndex = column.getIndex();
                }
                if (!column.getLabel().equals("_field")) continue;
                fieldTypeColumnIndex = column.getIndex();
            }
            if (timeColumnIndex < 0 || measureColumnIndex < 0 || fieldTypeColumnIndex < 0) {
                throw new DBException("Time and/or measure column not present in result set");
            }
            Object[][] objectArray = rowData;
            int n = rowData.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    Object timeValue;
                    Object[] row = objectArray[n2];
                    String fieldType = (String)row[fieldTypeColumnIndex];
                    if (measurement.getName().equals(fieldType) && (timeValue = row[timeColumnIndex]) != null) {
                        if (!(timeValue instanceof Instant || timeValue instanceof Date || timeValue instanceof LocalDateTime)) {
                            try {
                                timeValue = this.formatter.parse(CommonUtils.toString((Object)timeValue));
                            }
                            catch (ParseException e) {
                                log.debug((Object)"Error parsing Influx date", (Throwable)e);
                                break block20;
                            }
                        }
                        Number measureValue = (Number)row[measureColumnIndex];
                        if (projectIndex < 0) {
                            if (timeValue instanceof Date) {
                                points.add(new TSPoint((Date)timeValue, measureValue));
                            } else if (timeValue instanceof Instant) {
                                Instant from = (Instant)timeValue;
                                points.add(new TSPoint(Date.from(from), measureValue));
                            }
                        } else {
                            Object projectionValue = row[projectIndex];
                            if (CommonUtils.equalObjects((Object)projectionValue, (Object)projection.getValue())) {
                                if (timeValue instanceof Date) {
                                    points.add(new TSPoint((Date)timeValue, measureValue));
                                } else if (timeValue instanceof Instant) {
                                    Instant from = (Instant)timeValue;
                                    points.add(new TSPoint(Date.from(from), measureValue));
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return points;
    }
}

