/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling;

import com.dbeaver.ui.editors.spelling.SpellingEngine;
import com.dbeaver.ui.editors.spelling.TextSpellingEngine;
import com.dbeaver.ui.editors.spelling.sql.SQLSpellingEngine;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;

public class DefaultSpellingEngine
implements ISpellingEngine {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private static final IContentType SQL_CONTENT_TYPE = SQLEditorUtils.getSQLContentType();
    private final Map<IContentType, SpellingEngine> engines = new HashMap<IContentType, SpellingEngine>();

    public DefaultSpellingEngine() {
        if (SQL_CONTENT_TYPE != null) {
            this.engines.put(SQL_CONTENT_TYPE, new SQLSpellingEngine());
        }
        if (TEXT_CONTENT_TYPE != null) {
            this.engines.put(TEXT_CONTENT_TYPE, new TextSpellingEngine());
        }
    }

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellingEngine engine = this.getEngine(context.getContentType());
        if (engine == null) {
            engine = this.getEngine(TEXT_CONTENT_TYPE);
        }
        if (engine != null) {
            engine.check(document, regions, context, collector, monitor);
        }
    }

    private ISpellingEngine getEngine(IContentType contentType) {
        if (contentType == null) {
            return null;
        }
        if (this.engines.containsKey(contentType)) {
            return this.engines.get(contentType);
        }
        return this.getEngine(contentType.getBaseType());
    }
}

