/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.sql;

import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountConnectionString;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AzureCloudCosmosDBInstance
extends AzureCloudAbstractInstance {
    private static final Log log = Log.getLog(AzureCloudCosmosDBInstance.class);
    private final CosmosDBAccount instance;

    protected AzureCloudCosmosDBInstance(@NotNull AzureCloudSession session, @NotNull CosmosDBAccount cosmosDBAccount) {
        super(session, new AzureCloudZone(cosmosDBAccount.region()));
        this.instance = cosmosDBAccount;
    }

    @NotNull
    public static List<AzureCloudAbstractInstance> list(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        CosmosManager manager = (CosmosManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, CosmosManager::authenticate);
        return manager.databaseAccounts().list().stream().filter(it -> it.kind().equals((Object)DatabaseAccountKind.MONGO_DB)).map(server -> new AzureCloudCosmosDBInstance(session, (CosmosDBAccount)server)).collect(Collectors.toList());
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.instance.documentEndpoint();
    }

    @NotNull
    public String getNodeId() {
        return this.instance.id();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.name();
    }

    @NotNull
    public String getCloudResourceId() {
        return this.instance.id();
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        try {
            URI uri = new URI(((DatabaseAccountConnectionString)this.instance.listConnectionStrings().connectionStrings().get(0)).connectionString());
            configuration.setHostName(uri.getHost());
            configuration.setHostPort(CommonUtils.toString((Object)uri.getPort(), (String)"10255"));
        }
        catch (URISyntaxException e) {
            log.error((Object)e);
        }
        configuration.setProperty("retryWrites", "false");
        configuration.setProviderProperty("replicaSet", "globaldb");
        configuration.setProviderProperty("authMechanism", "SCRAM-SHA-1");
        try {
            configuration.setUserPassword(this.instance.listKeys().primaryMasterKey());
        }
        catch (Exception exception) {
            log.warn((Object)"Connection read-only");
            configuration.setUserName(this.instance.listReadOnlyKeys().primaryReadonlyMasterKey());
        }
        configuration.setDatabaseName("cosmos");
        configuration.setUserName(this.instance.name());
        configuration.setProperty("useSSL", "true");
    }

    @Override
    @NotNull
    protected AzureCloudService getCloudService() {
        return AzureCloudService.COSMOS_MONGO;
    }
}

