/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.azure.core.credential.AccessToken;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.model.auth.OpenIdTokenAdapter;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.utils.CommonUtils;

public class AzureCloudUtils {
    private static final Log log = Log.getLog(AzureCloudUtils.class);

    public static CloudProviderDescriptor getAzureCloudProvider() {
        return CloudProviderRegistry.getInstance().getCloudProvider("azure");
    }

    public static void updateCredentialsFromSessionData(@NotNull Map<String, Object> objectMap, @NotNull AuthModelAzureCredentials credentials) {
        if (!CommonUtils.isEmpty(objectMap)) {
            Map resourceMap = JSONUtils.getObjectOrNull(objectMap, (String)"resources");
            if (resourceMap != null) {
                for (Map.Entry resEntry : resourceMap.entrySet()) {
                    AuthModelAzureCredentials.Resource resource = (AuthModelAzureCredentials.Resource)CommonUtils.valueOf(AuthModelAzureCredentials.Resource.class, (String)((String)resEntry.getKey()));
                    if (resource == null) {
                        log.debug((Object)("Unknown Azure resource: " + (String)resEntry.getKey()));
                        continue;
                    }
                    Map tokenInfo = (Map)resEntry.getValue();
                    AzureCloudUtils.extractTokensFromAuthInfo(tokenInfo, credentials);
                }
            } else {
                AzureCloudUtils.extractTokensFromAuthInfo(objectMap, credentials);
            }
        }
    }

    private static void extractTokensFromAuthInfo(Map<String, Object> tokenInfo, AuthModelAzureCredentials credentials) {
        Map tokenMap = JSONUtils.getObjectOrNull(tokenInfo, (String)"access-token");
        if (!CommonUtils.isEmpty((Map)tokenMap)) {
            try {
                OpenIdTokenAdapter openIdToken = (OpenIdTokenAdapter)JSONUtils.deserializeObject((Map)tokenMap, OpenIdTokenAdapter.class);
                if (CommonUtils.isNotEmpty((String)openIdToken.getTokenValue()) && CommonUtils.isNotEmpty((String)openIdToken.getTokenScope())) {
                    log.debug((Object)"Use Azure credentials from current session");
                    Set scopes = Arrays.stream(openIdToken.getTokenScope().split(" ")).collect(Collectors.toSet());
                    AuthModelAzureCredentials.AzureScopes azureScopes = () -> scopes;
                    AccessToken accessToken = new AccessToken(openIdToken.getTokenValue(), OffsetDateTime.MAX);
                    credentials.addToken(azureScopes, accessToken);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static boolean containsValueFromIdByName(String id, String name) {
        if (id == null) {
            return false;
        }
        Iterator itr = Arrays.stream(id.split("/")).iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim().isEmpty() || !part.equalsIgnoreCase(name)) continue;
            return itr.hasNext();
        }
        return false;
    }
}

