/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import com.dbeaver.net.auth.azure.AzureAuthType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.SecureProperty;

public class AzureCloudConfiguration
extends AbstractCloudConfiguration<AzureCloudConfiguration> {
    private final AuthModelAzureCredentials credentials = new AuthModelAzureCredentials();
    private String storageAccountId;
    @SecureProperty
    private String storageAccountKey;
    @Deprecated
    private String id;
    @Deprecated
    private String name;

    public void processPostLoadActions() {
        super.processPostLoadActions();
        if (this.id != null) {
            this.setCloudId(this.id);
            this.id = null;
        }
        if (this.name != null) {
            this.setCloudName(this.name);
            this.name = null;
        }
        if (this.isDefaultConfiguration()) {
            this.credentials.setAuthType(AzureAuthType.SESSION_CREDENTIALS);
            this.credentials.setClientId(null);
            this.credentials.setTenantId(null);
        }
    }

    @Nullable
    public String getGlobalCloudId() {
        return "Azure";
    }

    @NotNull
    public AuthModelAzureCredentials getDefaultCredentials() {
        return this.credentials;
    }

    @Nullable
    public String getStorageAccountId() {
        return this.storageAccountId;
    }

    public void setStorageAccountId(@Nullable String storageAccountId) {
        this.storageAccountId = storageAccountId;
    }

    @Nullable
    public String getStorageAccountKey() {
        return this.storageAccountKey;
    }

    public void setStorageAccountKey(@Nullable String storageAccountKey) {
        this.storageAccountKey = storageAccountKey;
    }
}

