/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.storage;

import com.dbeaver.cloud.gcp.storage.GCPFileSystem;
import com.dbeaver.cloud.model.CPCloudFileSystemRoot;
import com.dbeaver.cloud.model.navigator.CPCloudRegionProvider;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class GCPFileSystemBucket
implements CPCloudFileSystemRoot,
CPCloudRegionProvider {
    private final GCPFileSystem fs;
    private final String projectId;
    private final Bucket bucket;
    private CloudStorageFileSystem instance;
    private Path bucketPath;

    public GCPFileSystemBucket(@NotNull GCPFileSystem fs, @NotNull String projectId, @NotNull Bucket bucket) {
        this.fs = fs;
        this.projectId = projectId;
        this.bucket = bucket;
    }

    @NotNull
    public String getName() {
        return this.bucket.getName();
    }

    @NotNull
    public DBFVirtualFileSystem getFileSystem() {
        return this.fs;
    }

    @NotNull
    public String getRootId() {
        return this.bucket.getName();
    }

    public DBPImage getRootIcon() {
        return null;
    }

    @NotNull
    public Path getRootPath(DBRProgressMonitor monitor) throws DBException {
        Iterator rootDirectories;
        if (this.bucketPath != null) {
            return this.bucketPath;
        }
        if (this.instance == null) {
            CloudStorageConfiguration csConfig = CloudStorageConfiguration.builder().userProject(this.projectId).build();
            this.instance = CloudStorageFileSystem.forBucket((String)this.bucket.getName(), (CloudStorageConfiguration)csConfig, (StorageOptions)this.fs.createStorageOptions(monitor, this.projectId));
        }
        if (!(rootDirectories = this.instance.getRootDirectories().iterator()).hasNext()) {
            throw new DBException("No root directory for bucket '" + this.getName() + "'");
        }
        this.bucketPath = (Path)rootDirectories.next();
        DBFUtils.mapFileSystem((FileSystem)this.bucketPath.getFileSystem(), (String)this.fs.getId());
        return this.bucketPath;
    }

    public void close() throws IOException {
        if (this.bucketPath != null) {
            DBFUtils.mapFileSystem((FileSystem)this.bucketPath.getFileSystem(), null);
            this.bucketPath = null;
        }
        if (this.instance != null) {
            this.instance.close();
            this.instance = null;
        }
    }

    @Nullable
    public String getCloudRegion(@Nullable DBRProgressMonitor monitor) throws DBException {
        return this.bucket.getLocation();
    }
}

