/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.storage;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudExplorer;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.gcp.storage.GCPFileSystemBucket;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.model.AbstractCloudVirtualFileSystem;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.dbeaver.net.auth.gcp.GCPAuthUtils;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class GCPFileSystem
extends AbstractCloudVirtualFileSystem<GCPFileSystemBucket, GCPCloud> {
    private static final Log log = Log.getLog(GCPFileSystem.class);
    private Credentials googleCredentials;

    public GCPFileSystem(@NotNull GCPCloud cloud, @NotNull SMSessionContext sessionContext) {
        super((AbstractCloud)cloud, sessionContext);
    }

    @NotNull
    public String getFileSystemDisplayName() {
        return ((GCPCloud)this.cloud).getName();
    }

    @NotNull
    public String getType() {
        return "gs";
    }

    public String getDescription() {
        return "Google Cloud Storage for " + ((GCPCloud)this.cloud).getName();
    }

    public DBPImage getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        return ((GCPCloud)this.cloud).getCloudId();
    }

    @NotNull
    public String getProviderId() {
        return "gcp-storage";
    }

    protected List<GCPFileSystemBucket> getBucketsFromCloudSystem(DBRProgressMonitor monitor) throws DBException {
        StorageOptions singleStorageOptions = this.createStorageOptions(monitor, null);
        ArrayList<String> projectList = new ArrayList<String>();
        String activeProject = this.getAuthCredentials(monitor).getProjectId();
        if (CommonUtils.isEmpty((String)activeProject)) {
            activeProject = singleStorageOptions.getProjectId();
        }
        if (CommonUtils.isEmpty((String)activeProject)) {
            SMSession cloudSession = this.sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
            GCPCloudExplorer explorer = ((GCPCloud)this.cloud).createExplorer(monitor, (GCPCloudSession)cloudSession);
            GCPProject[] gCPProjectArray = explorer.getRootFolders(monitor);
            int n = gCPProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GCPProject project = gCPProjectArray[n2];
                projectList.add(project.getProjectId());
                ++n2;
            }
        } else {
            projectList.add(activeProject);
        }
        try {
            monitor.beginTask("Read GCP buckets", projectList.size());
            HashMap<String, Storage> storages = new HashMap<String, Storage>();
            for (String project : projectList) {
                monitor.subTask("Acquire GCP storage for project " + project);
                if (project.equals(singleStorageOptions.getProjectId())) {
                    storages.put(project, (Storage)singleStorageOptions.getService());
                    continue;
                }
                storages.put(project, (Storage)this.createStorageOptions(monitor, project).getService());
            }
            List<GCPFileSystemBucket> result = Collections.synchronizedList(new ArrayList());
            RuntimeUtils.executeJobsForEach(storages.entrySet(), (monitor1, entry) -> {
                try {
                    for (Bucket bucket : ((Storage)entry.getValue()).list(Storage.BucketListOption.dedupe((Storage.BucketListOption[])new Storage.BucketListOption[0])).iterateAll()) {
                        result.add(new GCPFileSystemBucket(this, (String)entry.getKey(), bucket));
                    }
                }
                catch (Exception e) {
                    StorageException se;
                    if (e instanceof StorageException && (se = (StorageException)e).getCode() == 403) {
                        log.debug((Object)("Project '" + (String)entry.getKey() + "' is not accessible"));
                        return;
                    }
                    throw new InvocationTargetException(e);
                }
            });
            return result;
        }
        catch (Exception e) {
            throw new DBException("Error reading GCP buckets", (Throwable)e);
        }
    }

    public StorageOptions createStorageOptions(@NotNull DBRProgressMonitor monitor, @Nullable String projectId) throws DBException {
        if (this.googleCredentials == null) {
            AuthModelGCPCredentials credentials = this.getAuthCredentials(monitor);
            this.googleCredentials = this.createCredentials(monitor, credentials);
        }
        return ((StorageOptions.Builder)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider(GCPAuthUtils.createHeaderProvider())).setCredentials(this.googleCredentials)).setProjectId(projectId)).build();
    }

    private Credentials createCredentials(DBRProgressMonitor monitor, AuthModelGCPCredentials gcpCredentials) throws DBException {
        try {
            gcpCredentials.resolveCredentials(monitor);
            if (gcpCredentials.getAuthType() == GCPAuthType.SESSION_CREDENTIALS || gcpCredentials.getAuthType() == GCPAuthType.SSO_OVER_CLI || gcpCredentials.isSsoOverCli()) {
                String token = gcpCredentials.getToken();
                return OAuth2Credentials.create((AccessToken)new AccessToken(token, null));
            }
            String credFileName = CommonUtils.toString((Object)gcpCredentials.getServiceAccountConfigPath());
            String credEncodedData = CommonUtils.toString((Object)gcpCredentials.getServiceAccountConfig());
            if (CommonUtils.isNotEmpty((String)credFileName)) {
                Throwable throwable = null;
                Object var6_12 = null;
                try (FileInputStream cfgFileStream = new FileInputStream(credFileName);){
                    return GoogleCredentials.fromStream((InputStream)cfgFileStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (CommonUtils.isNotEmpty((String)credEncodedData)) {
                try {
                    credEncodedData = new String(Base64.getDecoder().decode(credEncodedData), StandardCharsets.UTF_8);
                }
                catch (Exception exception) {}
                try {
                    Throwable throwable = null;
                    Object var6_14 = null;
                    try (ByteArrayInputStream cfgFileStream = new ByteArrayInputStream(credEncodedData.getBytes(StandardCharsets.UTF_8));){
                        return GoogleCredentials.fromStream((InputStream)cfgFileStream);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new DBException("Error resolving credentials from stream", (Throwable)e);
                }
            }
            return GoogleCredentials.getApplicationDefault();
        }
        catch (Exception e) {
            throw new DBException("Error reading Google credentials", (Throwable)e);
        }
    }

    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor monitor, @NotNull URI uri) throws DBException {
        String bucketName = CommonUtils.toString((Object)uri.getHost(), (String)uri.getAuthority());
        List roots = this.getRootFolders(monitor);
        GCPFileSystemBucket rootBucket = roots.stream().filter(bucket -> bucket.getName().equals(bucketName)).findFirst().orElseThrow(() -> new DBException("Cannot find bucket '" + bucketName + "'"));
        return rootBucket.getRootPath(monitor).resolve(uri.getPath());
    }

    public boolean supportsEmptyFolders() {
        return false;
    }

    public boolean isDirectory(Path path) {
        return path.toString().endsWith("/");
    }

    private AuthModelGCPCredentials getAuthCredentials(@NotNull DBRProgressMonitor monitor) throws DBException {
        SMSession session = this.sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (session instanceof GCPCloudSession) {
            GCPCloudSession s = (GCPCloudSession)session;
            return s.getCredentials();
        }
        throw new DBException("Can't obtain GCP cloud session from context");
    }
}

