/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class SmallIntTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Short>
implements TimeSeriesFieldDefinition<Short> {
    public SmallIntTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.SHORT);
    }

    public static SmallIntTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.SHORT.getInformixTypeName())) {
            return new SmallIntTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Short read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return stream.readShort();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Short value) throws SQLException {
        if (!(value instanceof Short)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", Short.class.getName(), value.getClass().getName()));
        }
        stream.writeShort(value);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::short";
        }
        if (value instanceof Short) {
            return String.valueOf(((Short)value).toString()) + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Short.class, value.getClass()));
    }

    @Override
    public Short convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToShort(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SmallIntTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Short> {
        @Override
        public TimeSeriesFieldDefinition<Short> parse(String s) {
            return SmallIntTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

