/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Date;

public final class ObjectConversionUtilities {
    private ObjectConversionUtilities() {
    }

    public static final Long convertObjectToLong(Object value) {
        return ObjectConversionUtilities.convertObjectToLong(value, Long.class.getName());
    }

    public static final Long convertObjectToLong(Object value, String actualTargetClass) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return bb.getLong();
            }
            if (bytes.length == 4) {
                return ((Number)bb.getInt()).longValue();
            }
            if (bytes.length == 2) {
                return ((Number)bb.getShort()).longValue();
            }
            if (bytes.length == 1) {
                return ((Number)bb.get()).longValue();
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, actualTargetClass));
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return 1L;
            }
            return 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String) {
            try {
                BigDecimal bigD = new BigDecimal((String)value);
                return bigD.longValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, actualTargetClass));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), actualTargetClass));
    }

    public static final Double convertObjectToDouble(Object value) {
        return ObjectConversionUtilities.convertObjectToDouble(value, Double.class.getName());
    }

    public static final Double convertObjectToDouble(Object value, String actualTargetClass) {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return bb.getDouble();
            }
            if (bytes.length == 4) {
                return ((Number)Float.valueOf(bb.getFloat())).doubleValue();
            }
            if (bytes.length == 2) {
                return ((Number)bb.getShort()).doubleValue();
            }
            if (bytes.length == 1) {
                return ((Number)bb.get()).doubleValue();
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, actualTargetClass));
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        if (value instanceof Date) {
            return ((Number)((Date)value).getTime()).doubleValue();
        }
        if (value instanceof String) {
            try {
                BigDecimal bigD = new BigDecimal((String)value);
                return bigD.doubleValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, actualTargetClass));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), actualTargetClass));
    }

    public static final Float convertObjectToFloat(Object value) {
        if (value == null || value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return Float.valueOf((float)bb.getDouble());
            }
            if (bytes.length == 4) {
                return Float.valueOf(((Number)Float.valueOf(bb.getFloat())).floatValue());
            }
            if (bytes.length == 2) {
                return Float.valueOf(((Number)bb.getShort()).floatValue());
            }
            if (bytes.length == 1) {
                return Float.valueOf(((Number)bb.get()).floatValue());
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, Float.class.getName()));
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf(0.0f);
        }
        if (value instanceof Date) {
            return Float.valueOf(((Number)((Date)value).getTime()).floatValue());
        }
        if (value instanceof String) {
            try {
                BigDecimal bigD = new BigDecimal((String)value);
                return Float.valueOf(bigD.floatValue());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, Float.class.getName()));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), Float.class.getName()));
    }

    public static final BigDecimal convertObjectToBigDecimal(Object value) {
        if (value == null || value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return new BigDecimal(bb.getLong());
            }
            if (bytes.length == 4) {
                return new BigDecimal(bb.getInt());
            }
            if (bytes.length == 2) {
                return new BigDecimal(bb.getShort());
            }
            if (bytes.length == 1) {
                return new BigDecimal(bb.get());
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, BigDecimal.class.getName()));
        }
        if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                return new BigDecimal(((Number)value).longValue());
            }
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        if (value instanceof Date) {
            return new BigDecimal(((Date)value).getTime());
        }
        if (value instanceof String) {
            try {
                BigDecimal bigD = new BigDecimal((String)value);
                return bigD;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, BigDecimal.class.getName()));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), BigDecimal.class.getName()));
    }

    public static final Integer convertObjectToInteger(Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return ((Number)bb.getLong()).intValue();
            }
            if (bytes.length == 4) {
                return bb.getInt();
            }
            if (bytes.length == 2) {
                return ((Number)bb.getShort()).intValue();
            }
            if (bytes.length == 1) {
                return ((Number)bb.get()).intValue();
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, Integer.class.getName()));
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return 1;
            }
            return 0;
        }
        if (value instanceof Date) {
            return ((Number)((Date)value).getTime()).intValue();
        }
        if (value instanceof String) {
            try {
                Integer i = Integer.valueOf((String)value);
                return i;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, Integer.class.getName()));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), Integer.class.getName()));
    }

    public static final Short convertObjectToShort(Object value) {
        if (value == null || value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                return ((Number)bb.getLong()).shortValue();
            }
            if (bytes.length == 4) {
                return ((Number)bb.getInt()).shortValue();
            }
            if (bytes.length == 2) {
                return bb.getShort();
            }
            if (bytes.length == 1) {
                return ((Number)bb.get()).shortValue();
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, Short.class.getName()));
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return (short)1;
            }
            return (short)0;
        }
        if (value instanceof Date) {
            return ((Number)((Date)value).getTime()).shortValue();
        }
        if (value instanceof String) {
            try {
                BigDecimal bigD = new BigDecimal((String)value);
                return bigD.shortValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, Short.class.getName()));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), Short.class.getName()));
    }

    public static final Boolean convertObjectToBoolean(Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            if (bytes.length == 8) {
                if (bb.getLong() > 0L) {
                    return true;
                }
                return false;
            }
            if (bytes.length == 4) {
                if (bb.getInt() > 0) {
                    return true;
                }
                return false;
            }
            if (bytes.length == 2) {
                if (bb.getShort() > 0) {
                    return true;
                }
                return false;
            }
            if (bytes.length == 1) {
                if (bb.get() > 0) {
                    return true;
                }
                return false;
            }
            throw new IllegalArgumentException(MessageFormat.format("could not convert a byte array of length {0} to {1}", bytes.length, Boolean.class.getName()));
        }
        if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                if (((Number)value).doubleValue() > 0.0) {
                    return true;
                }
                return false;
            }
            if (((Number)value).longValue() > 0L) {
                return true;
            }
            return false;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime() > 0L;
        }
        if (value instanceof String) {
            IllegalArgumentException pending = null;
            try {
                Boolean l = Boolean.valueOf((String)value);
                return l;
            }
            catch (Exception e) {
                pending = new IllegalArgumentException(MessageFormat.format("could not convert the String ''{0}'' to a {1}", (String)value, Boolean.class.getName()));
                try {
                    BigDecimal bigD = new BigDecimal((String)value);
                    if (bigD.compareTo(BigDecimal.ZERO) > 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception e2) {
                    throw pending;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), Boolean.class.getName()));
    }
}

