/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import java.util.concurrent.CopyOnWriteArrayList;

public abstract class MemoizingCache<T> {
    private final CopyOnWriteArrayList<T> cache = new CopyOnWriteArrayList();

    public T getValue(int index) {
        if (index + 1 > this.cache.size()) {
            this.expandCacheSize(index);
        }
        return this.cache.get(index);
    }

    private synchronized void expandCacheSize(int size) {
        int desiredSize = size + 1;
        if (desiredSize <= this.cache.size()) {
            return;
        }
        int i = this.cache.size();
        while (i < desiredSize) {
            this.cache.add(this.build(i));
            ++i;
        }
    }

    public abstract T build(int var1);
}

