/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.timeseries.IfmxCalendarPattern;
import com.informix.timeseries.IfmxCalendarUDT;
import com.informix.timeseries.IfxCalendar;
import com.informix.timeseries.JdbcUtilities;
import com.informix.timeseries.TimeSeriesTypeMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class IfmxCalendar
implements IfmxCalendarUDT,
SQLData {
    private static final String SQL_TYPE_NAME = "calendar";
    private String name = null;
    private int length = 0;
    private IfxCalendar startDate = null;
    private IfxCalendar patternStartDate = null;
    private int flags = 0x1000000;
    private int offset = 0;
    private int id = Integer.MIN_VALUE;
    private int referenceCount = 0;
    private IfmxCalendarPattern pattern;

    public IfmxCalendar() {
    }

    public IfmxCalendar(String name, Timestamp calendarStart, Timestamp patternStart, String pattern) throws SQLException {
        this.pattern = new IfmxCalendarPattern(pattern);
        this.initCalendar(name, calendarStart, patternStart);
    }

    public IfmxCalendar(String name, Timestamp calendarStart, Timestamp patternStart, IfmxCalendarPattern pattern) throws SQLException {
        this.pattern = pattern;
        this.initCalendar(name, calendarStart, patternStart);
    }

    public IfmxCalendar(String name, String calendar) throws SQLException {
        int firstComma = calendar.indexOf(44);
        String calendarStartString = calendar.substring(0, firstComma);
        int secondComma = calendar.indexOf(44, firstComma + 1);
        String patternStartString = calendar.substring(firstComma + 1, secondComma);
        String patternString = calendar.substring(secondComma + 1);
        Timestamp calendarStart = IfmxCalendar.getTimestamp(calendarStartString);
        Timestamp patternStart = IfmxCalendar.getTimestamp(patternStartString);
        this.pattern = new IfmxCalendarPattern(IfmxCalendar.getStringBetweenParenthesis(patternString));
        this.initCalendar(name, calendarStart, patternStart);
    }

    private static final String getStringBetweenParenthesis(String input) {
        int startParenthesis = input.indexOf(40);
        int endParenthesis = input.lastIndexOf(41);
        String substring = input.substring(startParenthesis + 1, endParenthesis);
        return substring;
    }

    private static Timestamp getTimestamp(String calendarSubstring) {
        return Timestamp.valueOf(IfmxCalendar.getStringBetweenParenthesis(calendarSubstring));
    }

    IfmxCalendar(IfmxUDTSQLInput stream, int cVarLength) throws SQLException {
        this.readFromStream(stream);
        this.name = stream.readString(cVarLength - this.length - 4);
    }

    public static final Builder builder() {
        return new Builder();
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return SQL_TYPE_NAME;
    }

    public String getName() throws SQLException {
        return this.name;
    }

    public Timestamp getStartDate() throws SQLException {
        if (this.startDate == null) {
            throw new SQLException("Calendar start date not set!");
        }
        return this.startDate.getTimestamp();
    }

    public Timestamp getPatStartDate() throws SQLException {
        if (this.patternStartDate == null) {
            throw new SQLException("Pattern start date not set!");
        }
        return this.patternStartDate.getTimestamp();
    }

    public int getId() {
        return this.id;
    }

    protected void setId(int newId) {
        this.id = newId;
    }

    public void setTransientFields(Connection connection) throws SQLException {
        String sql = "SELECT c_version, c_calendar, c_id, c_refcount FROM calendartable WHERE c_name = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = connection.prepareStatement("SELECT c_version, c_calendar, c_id, c_refcount FROM calendartable WHERE c_name = ?");
                preparedStatement.setString(1, this.name);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int version = resultSet.getInt(1);
                    if (version != 0) {
                        throw new SQLException("Unable to read a calendar that is not version 0");
                    }
                    IfmxCalendar otherCalendar = (IfmxCalendar)resultSet.getObject(2, TimeSeriesTypeMap.builder().build());
                    if (this.equals(otherCalendar, true, true, true)) {
                        this.id = resultSet.getInt(3);
                        this.referenceCount = resultSet.getInt(4);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLException(MessageFormat.format("Unable to get calendar {0}", this.name), e);
            }
        }
        catch (Throwable throwable) {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
            throw throwable;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    protected void setReferenceCount(int newReferenceCount) {
        this.referenceCount = newReferenceCount;
    }

    public IfmxCalendarPattern getPattern() throws SQLException {
        if (this.pattern == null) {
            throw new SQLException("Pattern not set!");
        }
        return this.pattern;
    }

    @Override
    public void readSQL(SQLInput stream, String type) throws SQLException {
        this.readFromStream((IfmxUDTSQLInput)stream);
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.writeToStream((IfmxUDTSQLOutput)stream);
    }

    public String toCalendarString() {
        StringBuilder sb = new StringBuilder();
        sb.append("startdate(" + this.startDate.getTimestamp() + "), ");
        sb.append("pattstart(" + this.patternStartDate.getTimestamp() + "), ");
        sb.append("pattern(" + this.pattern.toString() + ")");
        return sb.toString();
    }

    public Timestamp getTimestampFromOffset(int offset, int tsOffset) throws SQLException {
        int onOffCnt;
        int adjust;
        int extra;
        IfxCalendar returnVal = new IfxCalendar(this.startDate.getTimestamp());
        if (offset == 0) {
            if (tsOffset == 0) {
                return this.startDate.getTimestamp();
            }
            returnVal.addCalPatInterval(this.pattern.getIntervalTypeId(), tsOffset);
            if (this.pattern.getIntervalTypeId() > 50) {
                Timestamp newStamp = new Timestamp(returnVal.getTimeInMillis());
                return newStamp;
            }
            Timestamp newStamp = this.startDate.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() - (long)returnVal.get(16)) : (returnVal.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() + (long)this.startDate.get(16)) : new Timestamp(returnVal.getTimeInMillis()));
            return newStamp;
        }
        int calOffset = this.pattern.getTotalDuration() - this.offset;
        if (tsOffset >= calOffset) {
            extra = (tsOffset - calOffset) % this.pattern.getTotalDuration();
            tsOffset -= extra;
            adjust = 0;
        } else {
            extra = (calOffset - tsOffset) % this.pattern.getTotalDuration();
            if (extra != 0) {
                extra = this.pattern.getTotalDuration() - extra;
            }
            adjust = tsOffset < 0 ? tsOffset - extra : calOffset - this.pattern.getTotalDuration();
            tsOffset = 0;
        }
        int non = 0;
        int i = 0;
        while (i < this.pattern.getNumberOfIntervals()) {
            onOffCnt = this.pattern.getValMask(i);
            if (!this.pattern.isOn(i)) {
                if (onOffCnt >= extra) break;
                extra -= onOffCnt;
            } else if (onOffCnt < extra) {
                non += onOffCnt;
                extra -= onOffCnt;
            } else {
                non += extra;
                break;
            }
            ++i;
        }
        if ((offset += non) >= 0) {
            int intervals = tsOffset + offset / this.pattern.getOnDuration() * this.pattern.getTotalDuration();
            extra = offset % this.pattern.getOnDuration() + 1;
            i = 0;
            while (i < this.pattern.getNumberOfIntervals()) {
                onOffCnt = this.pattern.getValMask(i);
                if (!this.pattern.isOn(i)) {
                    intervals += onOffCnt;
                } else if (onOffCnt < extra) {
                    intervals += onOffCnt;
                    extra -= onOffCnt;
                } else {
                    intervals += extra;
                    break;
                }
                ++i;
            }
            int newOffset = intervals - 1 + adjust;
            returnVal.addCalPatInterval(this.pattern.getIntervalTypeId(), newOffset);
        }
        Timestamp newStamp = this.startDate.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() - (long)returnVal.get(16)) : (returnVal.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() + (long)this.startDate.get(16)) : new Timestamp(returnVal.getTimeInMillis()));
        return newStamp;
    }

    public int getOffsetFromTimestamp(Timestamp timestamp, int tsOrigin) throws SQLException {
        int onOffCnt;
        IfxCalendar queryDate = new IfxCalendar(timestamp);
        int calOffset = this.pattern.getTotalDuration() - this.offset;
        int intervalDiff = queryDate.getDifference(this.startDate, this.pattern.getIntervalTypeId());
        if (intervalDiff < tsOrigin) {
            return 0;
        }
        int patLength = this.pattern.getNumberOfIntervals();
        int tsIntervals = tsOrigin > 0 ? (tsOrigin > this.offset ? (tsOrigin - this.offset) % this.pattern.getTotalDuration() : this.pattern.getTotalDuration() - (this.offset - tsOrigin)) : this.pattern.getTotalDuration() - (calOffset - tsOrigin) % this.pattern.getTotalDuration();
        if (tsIntervals == this.pattern.getTotalDuration()) {
            tsIntervals = 0;
        }
        int count = tsIntervals;
        int tsOriginNotOn = 0;
        int i = 0;
        while (i < patLength) {
            onOffCnt = this.pattern.getValMask(i);
            if (count <= onOffCnt) {
                if (!this.pattern.isOn(i)) break;
                tsOriginNotOn += count;
                break;
            }
            if (this.pattern.isOn(i)) {
                tsOriginNotOn += onOffCnt;
            }
            count -= onOffCnt;
            ++i;
        }
        intervalDiff -= tsOrigin;
        int numOnPeriods = (intervalDiff += tsIntervals) / this.pattern.getTotalDuration() * this.pattern.getOnDuration();
        int extraOnPeriod = intervalDiff % this.pattern.getTotalDuration();
        i = 0;
        while (i < patLength) {
            onOffCnt = this.pattern.getValMask(i);
            if (extraOnPeriod + 1 <= onOffCnt) {
                if (this.pattern.isOn(i)) {
                    numOnPeriods += extraOnPeriod;
                }
            } else {
                if (this.pattern.isOn(i)) {
                    numOnPeriods += onOffCnt;
                }
                extraOnPeriod -= onOffCnt;
            }
            ++i;
        }
        return numOnPeriods - tsOriginNotOn;
    }

    private void readFromStream(IfmxUDTSQLInput stream) throws SQLException {
        this.length = stream.readInt();
        this.startDate = new IfxCalendar(stream.readTimestamp());
        this.flags = stream.readInt();
        this.offset = stream.readInt();
        this.pattern = new IfmxCalendarPattern(stream);
        this.patternStartDate = (IfxCalendar)this.startDate.clone();
    }

    private void writeToStream(IfmxUDTSQLOutput stream) throws SQLException {
        stream.writeInt(this.length);
        stream.writeTimestamp(this.startDate.getTimestamp());
        stream.writeInt(this.flags);
        stream.writeInt(this.offset);
        this.pattern.writeSQL(stream);
    }

    private void initCalendar(String calName, Timestamp calStart, Timestamp patStart) throws SQLException {
        this.startDate = new IfxCalendar(calStart);
        this.patternStartDate = new IfxCalendar(patStart);
        this.length = 36 + this.pattern.getLength();
        this.name = calName;
        this.setId(-1);
        if (this.startDate.after(this.patternStartDate)) {
            throw new SQLException("The calendar pattern start date is before the calendar start date");
        }
        int diff = this.patternStartDate.getDifference(this.startDate, this.pattern.getIntervalTypeId());
        if (diff > this.pattern.getTotalDuration()) {
            throw new SQLException("The calendar pattern start date is too far away from the calendar start");
        }
        this.offset = this.pattern.getTotalDuration() - diff;
    }

    public static IfmxCalendar getCalendar(Connection connection, int id) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            IfmxCalendar ifmxCalendar;
            String sql = "SELECT c_version, c_refcount, c_calendar FROM calendartable WHERE c_id = ?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement("SELECT c_version, c_refcount, c_calendar FROM calendartable WHERE c_id = ?");
                preparedStatement.setInt(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                int version = resultSet.getInt(1);
                if (version != 0) {
                    throw new SQLException("Unable to read a calendar that is not version 0");
                }
                IfmxCalendar calendar = (IfmxCalendar)resultSet.getObject(3, TimeSeriesTypeMap.builder().build());
                calendar.setId(id);
                calendar.setReferenceCount(resultSet.getInt(3));
                ifmxCalendar = calendar;
            }
            catch (SQLException e) {
                try {
                    throw new SQLException(MessageFormat.format("Unable to get calendar with id {0}", id), e);
                }
                catch (Throwable throwable) {
                    JdbcUtilities.closeWithoutException(resultSet);
                    JdbcUtilities.closeWithoutException(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
            return ifmxCalendar;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return null;
    }

    public int create(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new SQLException("The calendar name must not be null");
        }
        String sql = "INSERT INTO calendartable(c_name,c_calendar) VALUES (?,?)";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int id;
            preparedStatement = connection.prepareStatement("INSERT INTO calendartable(c_name,c_calendar) VALUES (?,?)");
            preparedStatement.setString(1, this.name);
            preparedStatement.setObject(2, this);
            preparedStatement.execute();
            preparedStatement.getUpdateCount();
            int n = this.id = (id = ((IfxPreparedStatement)preparedStatement).getSerial());
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to create calendar {0} {1}", this.name, this.toString()), e);
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    public boolean delete(Connection connection) throws SQLException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new SQLException("The calendar name must be specified when deleting it from a database");
        }
        return IfmxCalendar.delete(connection, this.name);
    }

    public static boolean delete(Connection connection, int id) throws SQLException {
        if (id <= 0) {
            throw new SQLException("The calendar id must be greater than zero");
        }
        String sql = "DELETE FROM calendartable WHERE c_id = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM calendartable WHERE c_id = ?");
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to delete calendar with id {0}", id), e);
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    public static boolean delete(Connection connection, String name) throws SQLException {
        if (name == null) {
            throw new SQLException("The calendar name must not be null");
        }
        String sql = "DELETE FROM calendartable WHERE c_name = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM calendartable WHERE c_name = ?");
            preparedStatement.setString(1, name);
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to delete calendar with name {0}", name), e);
        }
        finally {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
        }
    }

    public static boolean deleteAll(Connection connection, boolean ignoreErrorsForReferenced) throws SQLException {
        boolean bl;
        String sql = ignoreErrorsForReferenced ? "SELECT * FROM calendartable WHERE c_refcount = 0" : "SELECT * FROM calendartable";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean modified = false;
        try {
            preparedStatement = connection.prepareStatement(sql, 1003, 1008);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    resultSet.deleteRow();
                    modified |= true;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -937) continue;
                    throw e;
                }
            }
            bl = modified;
        }
        catch (SQLException e) {
            try {
                throw new SQLException("Unable to delete all calendars", e);
            }
            catch (Throwable throwable) {
                JdbcUtilities.closeWithoutException(resultSet);
                JdbcUtilities.closeWithoutException(preparedStatement);
                throw throwable;
            }
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return bl;
    }

    public boolean exists(Connection connection) throws SQLException {
        try {
            IfmxCalendar other = IfmxCalendar.getCalendar(connection, this.getName());
            if (other == null) {
                IfmxCalendar.getCalendar(connection, this.getId());
            }
            return this.equals(other, false, true, false);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -206) {
                return false;
            }
            throw e;
        }
    }

    public static IfmxCalendar getCalendar(Connection connection, String name) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            IfmxCalendar ifmxCalendar;
            String sql = "SELECT c_version, c_id, c_refcount, c_calendar FROM calendartable WHERE c_name = ?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement("SELECT c_version, c_id, c_refcount, c_calendar FROM calendartable WHERE c_name = ?");
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                int version = resultSet.getInt(1);
                if (version != 0) {
                    throw new SQLException("Unable to read a calendar that is not version 0");
                }
                int id = resultSet.getInt(2);
                IfmxCalendar calendar = (IfmxCalendar)resultSet.getObject(4, TimeSeriesTypeMap.builder().build());
                calendar.name = name;
                calendar.setId(id);
                calendar.setReferenceCount(resultSet.getInt(3));
                ifmxCalendar = calendar;
            }
            catch (SQLException e) {
                try {
                    throw new SQLException(MessageFormat.format("Unable to get calendar {0}", name), e.getSQLState(), e.getErrorCode(), e);
                }
                catch (Throwable throwable) {
                    JdbcUtilities.closeWithoutException(resultSet);
                    JdbcUtilities.closeWithoutException(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
            return ifmxCalendar;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return null;
    }

    public static Set<IfmxCalendar> getCalendars(Connection connection) throws SQLException {
        HashSet<IfmxCalendar> calendars = new HashSet<IfmxCalendar>();
        String sql = "SELECT c_version, c_id, c_name, c_refcount, c_calendar FROM calendartable";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT c_version, c_id, c_name, c_refcount, c_calendar FROM calendartable");
                while (resultSet.next()) {
                    int version = resultSet.getInt(1);
                    if (version != 0) {
                        throw new SQLException("Unable to read a calendar that is not version 0");
                    }
                    int id = resultSet.getInt(2);
                    String name = resultSet.getString(3);
                    int referenceCount = resultSet.getInt(4);
                    IfmxCalendar calendar = (IfmxCalendar)resultSet.getObject(5, TimeSeriesTypeMap.builder().build());
                    calendar.setId(id);
                    calendar.setReferenceCount(referenceCount);
                    calendar.name = name;
                    calendars.add(calendar);
                }
            }
            catch (SQLException e) {
                throw new SQLException("Unable to get calendars", e);
            }
        }
        catch (Throwable throwable) {
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(statement);
            throw throwable;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(statement);
        return calendars;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        result = 31 * result + this.id;
        result = 31 * result + this.length;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.patternStartDate == null ? 0 : this.patternStartDate.hashCode());
        result = 31 * result + this.referenceCount;
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false, false, false);
    }

    public boolean equals(Object obj, boolean skipCalendarName, boolean skipPatternName, boolean skipId) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfmxCalendar other = (IfmxCalendar)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (!skipId && this.id != other.id) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!skipCalendarName && (this.name == null ? other.name != null : !this.name.equals(other.name))) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern, skipPatternName)) {
            return false;
        }
        if (this.patternStartDate == null ? other.patternStartDate != null : !this.patternStartDate.equals(other.patternStartDate)) {
            return false;
        }
        if (this.referenceCount != other.referenceCount) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("IfmxCalendar [name=");
        builder2.append(this.name);
        builder2.append(", id=");
        builder2.append(this.id);
        builder2.append(", referenceCount=");
        builder2.append(this.referenceCount);
        builder2.append(", startDate=");
        builder2.append(this.startDate);
        builder2.append(", patternStartDate=");
        builder2.append(this.patternStartDate);
        builder2.append(", pattern=");
        builder2.append(this.pattern);
        builder2.append(", flags=");
        builder2.append(this.flags);
        builder2.append(", length=");
        builder2.append(this.length);
        builder2.append(", offset=");
        builder2.append(this.offset);
        builder2.append(']');
        return builder2.toString();
    }

    public static final class Builder {
        private String name = null;
        private Timestamp calendarStart = null;
        private Timestamp patternStart = null;
        private int id = 0;
        private IfmxCalendarPattern pattern = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder calendarStart(Timestamp calendarStart) {
            this.calendarStart = calendarStart;
            return this;
        }

        public Builder patternStart(Timestamp patternStart) {
            this.patternStart = patternStart;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder pattern(IfmxCalendarPattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public void verify() {
            if (this.name == null) {
                throw new IllegalArgumentException("The calendar name must not be null");
            }
            if (this.calendarStart == null) {
                throw new IllegalArgumentException("The calendar start must not be null");
            }
            if (this.pattern == null) {
                throw new IllegalArgumentException("The calendar pattern must not be null");
            }
        }

        public IfmxCalendar build() throws SQLException {
            this.verify();
            IfmxCalendar result = new IfmxCalendar();
            result.id = this.id;
            result.name = this.name;
            result.pattern = this.pattern;
            if (this.patternStart == null) {
                result.initCalendar(this.name, this.calendarStart, this.calendarStart);
            } else {
                result.initCalendar(this.name, this.calendarStart, this.patternStart);
            }
            return result;
        }
    }
}

