/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.QMConfigurationProviderEE;
import com.dbeaver.ee.qm.db.QMDBConstants;
import com.dbeaver.ee.qm.db.impl.EmbeddedDatabase;
import com.dbeaver.ee.qm.db.impl.QMDBAIConversationTtlJob;
import com.dbeaver.ee.qm.db.impl.QMDBCleanupJob;
import com.dbeaver.ee.qm.db.model.QMDBQueryFilter;
import com.dbeaver.ee.qm.db.model.QMDBQueryRecord;
import com.dbeaver.ee.qm.db.model.QMDatabaseConfig;
import com.dbeaver.ee.qm.internal.QMActivator;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMProjectInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.sql.db.InternalDB;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class QMDBModel
extends InternalDB<QMDatabaseConfig> {
    private static final Log log = Log.getLog(QMDBModel.class);
    public static final String DATABASE_DEFAULT_DRIVER_CLASS = "org.h2.Driver";
    public static final String EMBEDDED_DATABASE_ID = "qmdb";
    private static final String EMPTY_DOMAIN_NAME = "*";
    private static QMDBModel instance;
    private String schemaName;
    private Long deployId;
    private Long productVersionId;
    private Long workspaceId;
    private Long hostId;
    private Long runId;
    private DBPConnectionInformation dbConnectionInformation;
    private ClassLoader driverClassLoader;
    private EmbeddedDatabase embeddedDatabase;
    private final QMDBCleanupJob cleanupJob;
    private final QMDBAIConversationTtlJob aiConversationTtlJob;

    public static synchronized QMDBModel getInstance() {
        if (instance == null) {
            QMConfigurationProviderEE qmConfigurationProvider = (QMConfigurationProviderEE)DBUtils.getAdapter(QMConfigurationProviderEE.class, (Object)DBWorkbench.getPlatform().getApplication());
            QMDatabaseConfig qmConfig = qmConfigurationProvider != null ? qmConfigurationProvider.getQmDatabaseConfig() : QMDatabaseConfig.DESKTOP_CONFIG;
            instance = new QMDBModel(qmConfig);
            QMDBModel.instance.cleanupJob.schedule(Duration.ofMinutes(2L));
            QMDBModel.instance.aiConversationTtlJob.schedule(Duration.ofMinutes(2L));
        }
        return instance;
    }

    public static synchronized void setInstance(@NotNull QMDBModel model) throws DBException {
        if (instance != null) {
            throw new DBException("QM instance already initialized");
        }
        instance = model;
        QMDBModel.instance.cleanupJob.schedule(Duration.ofMinutes(2L));
        QMDBModel.instance.aiConversationTtlJob.schedule(Duration.ofMinutes(2L));
    }

    public static void shutdown() {
        if (instance != null) {
            instance.shutdownModel();
            instance = null;
        }
    }

    public QMDBModel(@NotNull QMDatabaseConfig databaseConfig) {
        super("Query Manager", (InternalDatabaseConfig)databaseConfig, List.of(QMDBConstants.SCHEMA_CREATE_CONFIG));
        this.openConnection();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection dbCon = this.getDatabaseConnection();){
                LoggingProgressMonitor monitor = new LoggingProgressMonitor();
                this.initSchema((DBRProgressMonitor)monitor, dbCon);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error initializing QM database schema", (Throwable)e);
            this.closeConnection();
        }
        this.cleanupJob = new QMDBCleanupJob(DBWorkbench.getPlatform(), this);
        this.aiConversationTtlJob = new QMDBAIConversationTtlJob(DBWorkbench.getPlatform(), this);
    }

    public boolean isInitialized() {
        return this.dataSource != null;
    }

    Long getRunId() {
        return this.runId;
    }

    Long getWorkspaceId() {
        return this.workspaceId;
    }

    public EmbeddedDatabase getEmbeddedDatabase() {
        return this.embeddedDatabase;
    }

    private synchronized void openConnection() {
        if (this.dataSource == null && !DBWorkbench.getPlatform().getApplication().isExclusiveMode()) {
            log.debug((Object)"Initialize QMDB...");
            if (CommonUtils.isNotEmpty((String)((QMDatabaseConfig)this.databaseConfig).getSchema())) {
                this.schemaName = ((QMDatabaseConfig)this.databaseConfig).getSchema();
            }
            DataSourceProviderRegistry dataSourceProviderRegistry = DataSourceProviderRegistry.getInstance();
            try {
                if (((QMDatabaseConfig)this.databaseConfig).isH2Embedded()) {
                    Path dbPath = QMDBModel.getEmbeddedDatabasePath();
                    DBPDriver driver = dataSourceProviderRegistry.findDriver("h2_embedded_v2");
                    if (driver == null) {
                        throw new DBException("QMDB driver 'h2_embedded_v2' not found");
                    }
                    ClassLoader dbClassLoader = driver.getDefaultDriverLoader().getDriverInstance((DBRProgressMonitor)new LoggingProgressMonitor(log)).getClass().getClassLoader();
                    EmbeddedDatabase embeddedDB = new EmbeddedDatabase((QMDatabaseConfig)this.databaseConfig, dbPath, dbClassLoader, this.dataSource);
                    embeddedDB.loadQmDefaultConfiguration();
                    embeddedDB.migrateDatabaseToNewVersion(dataSourceProviderRegistry, this.getProperties());
                    this.connectToDatabase((DBPDataSourceProviderRegistry)dataSourceProviderRegistry);
                    if (this.dataSource != null) {
                        this.embeddedDatabase = embeddedDB;
                        this.embeddedDatabase.saveConfigurationFile();
                    }
                } else {
                    this.connectToDatabase((DBPDataSourceProviderRegistry)dataSourceProviderRegistry);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't start QM embedded database", (Throwable)e);
                return;
            }
            log.debug((Object)"QMDB connected");
        }
    }

    private synchronized void connectToDatabase(@NotNull DBPDataSourceProviderRegistry dataSourceProviderRegistry) throws DBException {
        block15: {
            Driver driverInstance;
            LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
            DBPDriver driver = this.getDatabaseDriver(dataSourceProviderRegistry);
            driver = driver.createOriginalCopy();
            this.dialect = driver.getScriptDialect().createInstance();
            DBPDriverLoader driverLoader = driver.getDefaultDriverLoader();
            if (driverLoader.needsExternalDependencies()) {
                log.debug((Object)("JDBC  dependencies are missing for driver " + driver.getFullName() + ". Fallback to default H2 driver."));
                try {
                    driverInstance = (Driver)Class.forName(DATABASE_DEFAULT_DRIVER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    log.error((Object)"Can't load QMDB database driver", e);
                    return;
                }
            } else {
                driverInstance = (Driver)driverLoader.getDriverInstance((DBRProgressMonitor)monitor);
            }
            this.driverClassLoader = driverInstance.getClass().getClassLoader();
            try {
                this.dataSource = this.initConnectionPool(driverInstance, driver.getFullName());
                Throwable e = null;
                Object var7_10 = null;
                try (Connection connection = this.getDatabaseConnection();){
                    this.createSchemaIfNotExists(connection);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error opening QMDB database", (Throwable)e);
                if (!((QMDatabaseConfig)this.databaseConfig).isH2Embedded()) break block15;
                this.tryDatabaseRecover(driver, driverInstance, e);
            }
        }
    }

    protected DataSource initConnectionPool(@NotNull Driver driverInstance, @NotNull String fullName) {
        String dbURL = ((QMDatabaseConfig)this.databaseConfig).getResolvedUrl();
        log.debug((Object)("\tInitiate connection pool with management database (" + fullName + "; " + dbURL + ")"));
        DriverConnectionFactory conFactory = new DriverConnectionFactory(driverInstance, dbURL, this.getProperties());
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)conFactory, null);
        pcf.setValidationQuery(((QMDatabaseConfig)this.databaseConfig).getPool().getValidationQuery());
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(((QMDatabaseConfig)this.databaseConfig).getPool().getMinIdleConnections());
        config.setMaxIdle(((QMDatabaseConfig)this.databaseConfig).getPool().getMaxIdleConnections());
        config.setMaxTotal(((QMDatabaseConfig)this.databaseConfig).getPool().getMaxConnections());
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf, config);
        pcf.setPool((ObjectPool)connectionPool);
        return new PoolingDataSource((ObjectPool)connectionPool);
    }

    @NotNull
    private static Path getEmbeddedDatabasePath() {
        return DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(EMBEDDED_DATABASE_ID);
    }

    private void tryDatabaseRecover(@NotNull DBPDriver driver, @NotNull Driver driverInstance, @NotNull Exception dbError) {
        SQLException sqlException;
        String sqlState;
        boolean internalH2Error = false;
        if (dbError instanceof SQLException && ("90030".equals(sqlState = (sqlException = (SQLException)dbError).getSQLState()) || SQLState.SQL_HY000.getCode().equals(sqlState))) {
            internalH2Error = true;
        }
        if (!internalH2Error) {
            return;
        }
        Path edbPath = QMDBModel.getEmbeddedDatabasePath();
        if (!Files.exists(edbPath, new LinkOption[0])) {
            return;
        }
        Path backupPath = QMDBModel.getEmbeddedDatabasePath().getParent().resolve("qmdb-backup-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis())));
        if (Files.exists(backupPath, new LinkOption[0])) {
            log.error((Object)("Backup directory '" + String.valueOf(backupPath) + "' already exists. Can't backup again."));
            return;
        }
        try {
            Files.move(edbPath, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        log.warn((Object)"Corrupted QMDB database was archived. Creating new empty QMDB database..");
        try {
            this.dataSource = this.initConnectionPool(driverInstance, driver.getFullName());
        }
        catch (Exception e) {
            log.error((Object)"Can't create QMDB database after backup", (Throwable)e);
        }
    }

    public void shutdownModel() {
        try {
            this.endCurrentRun();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        if (this.isInitialized()) {
            log.debug((Object)"Closing QMDB connection.");
            this.closeConnection();
            log.debug((Object)"QMDB stopped.");
        }
        if (this.cleanupJob != null) {
            this.cleanupJob.cancel();
        }
    }

    public void initializeSchema() throws DBException, SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            LoggingProgressMonitor monitor = new LoggingProgressMonitor();
            this.initializeSchema((DBRProgressMonitor)monitor, dbCon);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void initializeSchema(@NotNull DBRProgressMonitor monitor, @Nullable Connection dbCon) throws DBException, SQLException {
        if (((QMDatabaseConfig)this.databaseConfig).getSchema() == null) {
            ((QMDatabaseConfig)this.databaseConfig).setSchema(QMActivator.getDefault().getPreferences().getString("qmdb.database.schema"));
        }
        if (dbCon == null) {
            log.error((Object)"No QMDB connection");
            return;
        }
        this.updateSchema(monitor, dbCon);
        this.checkVersionConsistency();
        log.debug((Object)"\tCheck QMDB deployment");
        this.checkDBeaverHost();
        this.checkDBeaverDeployment();
        this.checkDBeaverVersion();
        long systemUserId = this.checkDBeaverSystemUser(monitor);
        this.workspaceId = this.checkDBeaverPlatformWorkspace();
        this.runId = this.createDBeaverRun(this.workspaceId, systemUserId);
    }

    private long checkDBeaverSystemUser(DBRProgressMonitor monitor) throws DBException, SQLException {
        SMSessionPrincipal globalPrincipal = QMUtils.getWorkspaceSession((DBRProgressMonitor)monitor).getSessionPrincipal();
        return this.findOrCreateUser(globalPrincipal);
    }

    private long checkDBeaverPlatformWorkspace() throws SQLException, DBException {
        String workspacePath = Platform.getInstanceLocation().getURL().toString();
        return this.findOrCreateQMDBeaverWorkspace(workspacePath);
    }

    private void checkVersionConsistency() {
    }

    private void checkDBeaverDeployment() throws DBException, SQLException {
        String installPath = CommonUtils.truncateString((String)Platform.getInstallLocation().getURL().toString(), (int)1000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            this.deployId = JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT DEPLOY_ID FROM {table_prefix}QM_DBEAVER_DEPLOYMENT WHERE HOST_ID=? AND INSTALL_PATH=?", (Object[])new Object[]{this.hostId, installPath});
            if (this.deployId == null) {
                int appPortNumber = 0;
                this.deployId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_DEPLOYMENT (HOST_ID,INSTALL_PATH,PORT_NUMBER,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)", (String)"DEPLOY_ID", (Object[])new Object[]{this.hostId, installPath, appPortNumber});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkDBeaverVersion() throws SQLException, DBException {
        String productName = GeneralUtils.getProductName();
        String versionName = GeneralUtils.getProductVersion().toString();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            this.productVersionId = JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT VERSION_ID FROM {table_prefix}QM_DBEAVER_VERSION WHERE PRODUCT_NAME=? AND VERSION_NAME=?", (Object[])new Object[]{productName, versionName});
            if (this.productVersionId == null) {
                this.productVersionId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_VERSION (PRODUCT_NAME,VERSION_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)", (String)"VERSION_ID", (Object[])new Object[]{productName, versionName});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    long findOrCreateQMDBeaverWorkspace(String workspacePath) throws SQLException, DBException {
        Long workspaceId = this.findQMDBeaverWorkspace(workspacePath);
        if (workspaceId == null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Connection dbCon = this.getDatabaseConnection();){
                workspaceId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_WORKSPACE (HOST_ID,WORKSPACE_PATH,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)", (String)"WORKSPACE_ID", (Object[])new Object[]{this.hostId, workspacePath});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return workspaceId;
    }

    public Long findOrCreateQMDBeaverProject(QMMProjectInfo projectInfo) throws SQLException, DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            Long projectId = JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT PROJECT_ID FROM {table_prefix}QM_DBEAVER_PROJECT WHERE PROJECT_NAME=? AND WORKSPACE_ID=?", (Object[])new Object[]{projectInfo.getId(), this.workspaceId});
            if (projectId == null) {
                projectId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_PROJECT(PROJECT_NAME,PROJECT_UUID,PROJECT_PATH,IS_ANONYMOUS,WORKSPACE_ID,UPDATE_TIME) VALUES(?,?,?,?,?,CURRENT_TIMESTAMP)", (String)"PROJECT_ID", (Object[])new Object[]{projectInfo.getId(), this.dialect.supportsUuid() ? projectInfo.getUuid() : projectInfo.getUuid().toString(), projectInfo.getPath(), projectInfo.isAnonymous(), this.workspaceId});
            }
            return projectId;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    Long findQMDBeaverWorkspace(String workspacePath) throws SQLException, DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            return JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT WORKSPACE_ID FROM {table_prefix}QM_DBEAVER_WORKSPACE WHERE HOST_ID=? AND WORKSPACE_PATH=?", (Object[])new Object[]{this.hostId, workspacePath});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    Long findOrCreateUser(SMSessionPrincipal globalPrincipal) throws SQLException, DBException {
        String osUserName = globalPrincipal.getUserName();
        String osDomainName = globalPrincipal.getUserDomain();
        return this.findOrCreateUser(osUserName, osDomainName);
    }

    Long findOrCreateUser(String userName, String userDomain) throws SQLException, DBException {
        if (CommonUtils.isEmpty((String)userDomain)) {
            userDomain = EMPTY_DOMAIN_NAME;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            Long userId = JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT USER_ID FROM {table_prefix}QM_USER WHERE DOMAIN_NAME=? AND USER_NAME=?", (Object[])new Object[]{userDomain, userName});
            if (userId == null) {
                userId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_USER (DOMAIN_NAME,USER_NAME,UPDATE_TIME) VALUES(?,?,CURRENT_TIMESTAMP)", (String)"USER_ID", (Object[])new Object[]{userDomain, userName});
            }
            return userId;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkDBeaverHost() throws SQLException, DBException {
        byte[] hardwareAddress;
        InetAddress localHost = RuntimeUtils.getLocalHostOrLoopback();
        String hostName = localHost.getHostName();
        String hostIP = localHost.getHostAddress();
        try {
            hardwareAddress = RuntimeUtils.getLocalMacAddress();
        }
        catch (IOException iOException) {
            hardwareAddress = new byte[8];
        }
        String macAddress = CommonUtils.toHexString((byte[])hardwareAddress);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            this.hostId = JDBCUtils.queryLong((Connection)dbCon, (String)"SELECT HOST_ID FROM {table_prefix}QM_DBEAVER_HOST WHERE MAC_ADDRESS=?", (Object[])new Object[]{macAddress});
            if (this.hostId == null) {
                this.hostId = JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_HOST (MAC_ADDRESS,HOST_NAME,IP_ADDRESS,UPDATE_TIME) VALUES(?,?,?,CURRENT_TIMESTAMP)", (String)"HOST_ID", (Object[])new Object[]{macAddress, hostName, hostIP});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    long createDBeaverRun(long workspaceId, long workspaceUserId) throws SQLException, DBException {
        Throwable throwable = null;
        Object var6_5 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            return JDBCUtils.executeInsertAutoIncrement((Connection)dbCon, (String)"INSERT INTO {table_prefix}QM_DBEAVER_RUN (DEPLOY_ID,VERSION_ID,WORKSPACE_ID,USER_ID,START_TIME) VALUES(?,?,?,?,CURRENT_TIMESTAMP)", (String)"RUN_ID", (Object[])new Object[]{this.deployId, this.productVersionId, workspaceId, workspaceUserId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void endCurrentRun() throws SQLException, DBException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection dbCon = this.getDatabaseConnection();){
            JDBCUtils.executeSQL((Connection)dbCon, (String)"UPDATE {table_prefix}QM_DBEAVER_RUN SET STOP_TIME=CURRENT_TIMESTAMP WHERE RUN_ID=?", (Object[])new Object[]{this.runId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<QMDBQueryRecord> searchQueryHistory(QMDBQueryFilter filter) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection dbCon = this.getDatabaseConnection();){
                return this.searchQueryHistory(dbCon, filter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error searching query history: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<QMDBQueryRecord> searchQueryHistory(@NotNull Connection dbCon, QMDBQueryFilter filter) throws DBException {
        ArrayList<QMDBQueryRecord> results = new ArrayList<QMDBQueryRecord>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT q.QUERY_ID,q.QUERY_TEXT,s.STATEMENT_PURPOSE,s.ROW_COUNT,s.ERROR_CODE,s.ERROR_MESSAGE,s.EXECUTE_TIME,s.FETCH_TIME,c.DATASOURCE_ID,c.INSTANCE_ID,c.CONTEXT_NAME\nFROM {table_prefix}QM_QUERY q, {table_prefix}QM_STATEMENT s, {table_prefix}QM_EVENT e, {table_prefix}QM_CONNECTION c ");
        sql.append("\nWHERE q.QUERY_ID=s.QUERY_ID AND e.EVENT_ID=s.STATEMENT_ID AND c.CONNECTION_ID=e.CONNECTION_ID");
        if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
            sql.append("\nAND q.QUERY_TEXT LIKE ?");
        }
        if (filter.getRowOffset() > 0 || filter.getMaxRows() > 0) {
            sql.append("\nLIMIT ").append(filter.getRowOffset()).append(", ").append(filter.getMaxRows());
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement dbStat = dbCon.prepareStatement(sql.toString());){
                int paramIndex = 1;
                if (!CommonUtils.isEmpty((String)filter.getQueryText())) {
                    dbStat.setString(paramIndex++, "%" + filter.getQueryText() + "%");
                }
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        QMDBQueryRecord record = new QMDBQueryRecord();
                        record.setQueryId(dbResult.getLong("QUERY_ID"));
                        record.setQueryText(dbResult.getString("QUERY_TEXT"));
                        record.setStatementPurpose(dbResult.getInt("STATEMENT_PURPOSE"));
                        record.setErrorCode(dbResult.getLong("ERROR_CODE"));
                        record.setErrorMessage(dbResult.getString("ERROR_MESSAGE"));
                        record.setExecuteTime(dbResult.getLong("EXECUTE_TIME"));
                        record.setFetchTime(dbResult.getLong("FETCH_TIME"));
                        results.add(record);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error reading query history", (Throwable)e);
        }
        return results;
    }

    void stopDatabase() {
        this.closeConnection();
    }

    public void startCleanupJob(DBRProgressMonitor monitor) {
        if (QMDBModel.instance.cleanupJob != null) {
            QMDBModel.instance.cleanupJob.doJob(monitor);
        }
    }

    DataSource restartDatabase() {
        this.openConnection();
        return this.dataSource;
    }

    public ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }
}

