/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm.db.impl;

import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qm.db.model.QMDatabaseConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.Strictness;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.db.InternalProxyConnection;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.storage.H2Migrator;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.BeanUtils;

public class EmbeddedDatabase {
    private static final Log log = Log.getLog(EmbeddedDatabase.class);
    private static final String V1_DB_NAME = "qmdb";
    private static final String V2_DB_NAME = "qmdb_v2";
    public static final String QM_CONFIG_JSON = "qm_config.json";
    private final QMDatabaseConfig databaseConfig;
    private final Path databasePath;
    private DataSource h2Connection;
    private ClassLoader driverClassLoader;
    private boolean oldFormat = false;

    public EmbeddedDatabase(QMDatabaseConfig databaseConfig, Path databasePath, ClassLoader driverClassLoader, DataSource connection) {
        this.databaseConfig = databaseConfig;
        this.databasePath = databasePath;
        this.h2Connection = connection;
        this.driverClassLoader = driverClassLoader;
    }

    public Path getDatabasePath() {
        return this.databasePath;
    }

    public boolean isOldFormat() {
        return this.oldFormat;
    }

    public void setOldFormat(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void backupDatabase(Path toFile) throws DBException {
        this.start();
        if (this.h2Connection == null) {
            throw new DBException("H2 server not started");
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Connection dbCon = this.getConnection();
                try {
                    try (Statement dbStat = dbCon.createStatement();){
                        dbStat.execute("BACKUP TO '" + String.valueOf(toFile.toAbsolutePath()) + "'");
                    }
                    if (dbCon == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (dbCon == null) throw throwable;
                    dbCon.close();
                    throw throwable;
                }
                dbCon.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Error running backup", (Throwable)e);
        }
    }

    private Connection getConnection() throws SQLException {
        return new InternalProxyConnection(this.h2Connection.getConnection(), (InternalDatabaseConfig)this.databaseConfig);
    }

    public void restoreDatabase(Path backupFile) throws DBException {
        this.start();
        try {
            BeanUtils.invokeStaticMethod(this.driverClassLoader.loadClass("org.h2.tools.Restore"), (String)"execute", (Class[])new Class[]{String.class, String.class, String.class}, (Object[])new Object[]{backupFile.toAbsolutePath().toString(), this.databasePath.toAbsolutePath().toString(), this.databaseConfig.getDatabaseId()});
        }
        catch (Throwable e) {
            throw new DBException("Error calling H2 restore", e);
        }
    }

    public Path dumpDatabaseToSQL() throws DBException {
        try {
            BeanUtils.invokeStaticMethod(this.driverClassLoader.loadClass("org.h2.tools.Recover"), (String)"execute", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{this.databasePath.toAbsolutePath().toString(), this.databaseConfig.getDatabaseId()});
            Path sqlFile = this.databasePath.resolve(this.databaseConfig.getDatabaseId() + ".h2.sql");
            if (!Files.exists(sqlFile, new LinkOption[0])) {
                throw new DBException("Error dumping database - target file '" + String.valueOf(sqlFile.toAbsolutePath()) + "' doesn't exists");
            }
            return sqlFile;
        }
        catch (Throwable e) {
            throw new DBException("Error running recover", e);
        }
    }

    public void restoreFromSQL(Path backupFile) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection dbCon = this.getConnection();){
                String url = dbCon.getMetaData().getURL();
                BeanUtils.invokeStaticMethod(this.driverClassLoader.loadClass("org.h2.tools.RunScript"), (String)"execute", (Class[])new Class[]{String.class, String.class, String.class, String.class, Charset.class, Boolean.TYPE}, (Object[])new Object[]{url, "", "", backupFile.toAbsolutePath().toString(), Charset.defaultCharset(), true});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new DBException("Error restoring SQL dump", e);
        }
    }

    public void deleteDatabaseFiles() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> list = Files.list(this.databasePath);){
                List<Path> files = list.toList();
                for (Path file : files) {
                    if (!file.getFileName().toString().endsWith(".db")) continue;
                    log.debug((Object)("Delete DB file " + String.valueOf(file.getFileName())));
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        log.debug((Object)"Delete failed", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error deleting database files", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return QMDBModel.getInstance().getEmbeddedDatabase() != null;
    }

    public void stop() {
        QMDBModel.getInstance().stopDatabase();
    }

    public void start() {
        this.h2Connection = QMDBModel.getInstance().restartDatabase();
        this.driverClassLoader = QMDBModel.getInstance().getDriverClassLoader();
    }

    void migrateDatabaseToNewVersion(final DataSourceProviderRegistry dataSourceProviderRegistry, final Properties finalConProperties) throws InterruptedException {
        if (!H2Migrator.isH2Database((InternalDatabaseConfig)this.databaseConfig)) {
            return;
        }
        AbstractJob job = new AbstractJob("Migrate query manager database to the new version"){

            protected IStatus run(DBRProgressMonitor monitor) {
                H2Migrator migrator = new H2Migrator(monitor, dataSourceProviderRegistry, (InternalDatabaseConfig)EmbeddedDatabase.this.databaseConfig, finalConProperties);
                migrator.migrateDatabaseIfNeeded(EmbeddedDatabase.V1_DB_NAME, EmbeddedDatabase.V2_DB_NAME);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        job.join();
        if ("h2_embedded_v2".equals(this.databaseConfig.getDriver())) {
            this.databaseConfig.setDatabaseId(V2_DB_NAME);
        }
    }

    void loadQmDefaultConfiguration() {
        if (DBWorkbench.isDistributed()) {
            return;
        }
        Path qmConfigFilePath = this.databasePath.resolve(QM_CONFIG_JSON);
        if (Files.exists(qmConfigFilePath, new LinkOption[0])) {
            try {
                this.readConfigurationFile(qmConfigFilePath);
            }
            catch (DBException e) {
                log.debug((Object)"Cannot read qm default config file", (Throwable)e);
            }
        }
    }

    private void readConfigurationFile(Path configFilePath) throws DBException {
        InstanceCreator dbConfigCreator = type -> this.databaseConfig;
        Gson gson = new GsonBuilder().registerTypeAdapter(QMDatabaseConfig.class, (Object)dbConfigCreator).create();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFilePath.toFile()), StandardCharsets.UTF_8);){
                gson.fromJson((Reader)reader, QMDatabaseConfig.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error parsing qm default database configuration", (Throwable)e);
        }
    }

    void saveConfigurationFile() {
        if (DBWorkbench.isDistributed()) {
            return;
        }
        Path qmConfigFilePath = this.databasePath.resolve(QM_CONFIG_JSON);
        if (!Files.exists(this.databasePath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.databasePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.debug((Object)"Cannot create qm database path", (Throwable)e);
                return;
            }
        }
        if (Files.exists(qmConfigFilePath, new LinkOption[0])) {
            ContentUtils.makeFileBackup((Path)qmConfigFilePath);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(qmConfigFilePath.toFile()), StandardCharsets.UTF_8);){
                Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();
                gson.toJson((Object)this.databaseConfig, (Appendable)out);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error writing qm default database configuration", (Throwable)e);
        }
    }
}

