/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.Flow;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;

public class WaveformRenderer
implements Flow.Subscriber<ByteBuffer> {
    private final Canvas canvas;
    private final boolean isBigEndian;
    private Flow.Subscription sub;
    private final float[] ring;
    private int head = 0;
    private final Object lock = new Object();
    private final int downsample;

    public WaveformRenderer(@NotNull Canvas canvas, int capacity, int downsample, float gain, boolean isBigEndian) {
        this.canvas = canvas;
        this.ring = new float[capacity];
        this.downsample = Math.max(1, downsample);
        this.isBigEndian = isBigEndian;
        this.canvas.addPaintListener(e -> {
            int headSnapshot;
            float[] snapshot;
            Object object = this.lock;
            synchronized (object) {
                snapshot = (float[])this.ring.clone();
                headSnapshot = this.head;
            }
            GC gc = e.gc;
            Rectangle rect = canvas.getClientArea();
            gc.setBackground(canvas.getDisplay().getSystemColor(1));
            gc.fillRectangle(rect);
            gc.setForeground(canvas.getDisplay().getSystemColor(9));
            int midY = rect.height / 2;
            int width = rect.width;
            int n = snapshot.length;
            int i = 1;
            while (i < n) {
                int idx1 = headSnapshot - (n - i + 1);
                int idx2 = headSnapshot - (n - i);
                float s1 = snapshot[(idx1 % n + n) % n];
                float s2 = snapshot[(idx2 % n + n) % n];
                int x1 = width - (n - i + 1) * width / n;
                int x2 = width - (n - i) * width / n;
                int y1 = midY - (int)(s1 * gain * (float)midY);
                int y2 = midY - (int)(s2 * gain * (float)midY);
                gc.drawLine(x1, y1, x2, y2);
                ++i;
            }
        });
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.sub = subscription;
        subscription.request(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(ByteBuffer item) {
        if (item == null || item.remaining() == 0) {
            Object object = this.lock;
            synchronized (object) {
                Arrays.fill(this.ring, 0.0f);
                this.head = 0;
            }
            this.asyncRedraw();
            this.sub.request(1L);
            return;
        }
        int count = 0;
        int i = item.position();
        while (i + 1 < item.limit()) {
            if (count++ % this.downsample == 0) {
                float v = WaveformRenderer.normalize(item, i, this.isBigEndian);
                Object object = this.lock;
                synchronized (object) {
                    this.ring[this.head] = v;
                    this.head = (this.head + 1) % this.ring.length;
                }
            }
            i += 2;
        }
        this.asyncRedraw();
        this.sub.request(1L);
    }

    private static float normalize(ByteBuffer item, int i, boolean isBigEndian) {
        ByteBuffer buf = item.duplicate().order(isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        short sample = buf.getShort(i);
        return (float)sample / 32768.0f;
    }

    @Override
    public void onError(Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }

    private void asyncRedraw() {
        if (!this.canvas.isDisposed()) {
            this.canvas.getDisplay().asyncExec(() -> {
                if (!this.canvas.isDisposed()) {
                    this.canvas.redraw();
                }
            });
        }
    }
}

