/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.ui.ai.chat.AIChatView;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractPageListener;

final class AIChatViewHandler {
    private final AIChatControl chat;
    private final Map<DBPDataSourceContainer, AIChatConversation> lastConversations = new HashMap<DBPDataSourceContainer, AIChatConversation>();
    private final EventListener eventListener;
    private final PartListener partListener;

    public AIChatViewHandler(final @NotNull AIChatView view) {
        this.chat = view.getChat();
        this.eventListener = new EventListener(){

            public void handleDataSourceEvent(@NotNull DBPEvent event) {
                AIChatViewHandler.this.updateActiveConversationQueueExec(view.getSite().getWorkbenchWindow());
            }
        };
        this.partListener = new PartListener(view.getSite().getWorkbenchWindow()){
            private IEditorPart lastPart;

            private void updateActivePart(IWorkbenchPart part) {
                IEditorPart editor;
                block3: {
                    block2: {
                        if (!(part instanceof IEditorPart)) break block2;
                        editor = (IEditorPart)part;
                        if (part != this.lastPart) break block3;
                    }
                    return;
                }
                this.lastPart = editor;
                AIChatViewHandler.this.updateActiveConversationQueueExec(part.getSite().getWorkbenchWindow());
            }

            public void partActivated(IWorkbenchPart part) {
                this.updateActivePart(part);
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
                this.updateActivePart(part);
            }

            public void partClosed(IWorkbenchPart part) {
                this.updateActivePart(part);
            }
        };
        this.updateActiveConversationQueueExec(Workbench.getInstance().getActiveWorkbenchWindow());
    }

    public void updateActiveConversationQueueExec(@Nullable IWorkbenchWindow window) {
        UIExecutionQueue.queueExec(() -> this.updateActiveConversation(window));
    }

    /*
     * WARNING - void declaration
     */
    private void updateActiveConversation(@Nullable IWorkbenchWindow window) {
        void dscp;
        if (window == null || window.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DBPDataSourceContainerProvider)) {
            return;
        }
        DBPDataSourceContainerProvider dBPDataSourceContainerProvider = (DBPDataSourceContainerProvider)activeEditor;
        DBPDataSourceContainer container = dscp.getDataSourceContainer();
        if (container != null && container == this.chat.getDataSourceContainer()) {
            return;
        }
        if (this.chat.isDisposed()) {
            return;
        }
        AIChatConversation activeConversation = this.chat.getActiveConversation();
        DBPDataSourceContainer activeContainer = activeConversation.getDataSource();
        if (this.chat.isWaitingForResponse()) {
            container = activeContainer;
        }
        DBPDataSourceContainer finalContainer = container;
        UIUtils.syncExec(() -> {
            try {
                this.chat.setDataSource(finalContainer);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("AI Chat Error", "Cannot set data source for AI chat", (Throwable)e);
            }
        });
    }

    public void dispose() {
        this.eventListener.dispose();
        this.partListener.dispose();
    }

    private static abstract class EventListener
    implements DBPEventListener {
        private final Set<DBPDataSourceRegistry> registries = new HashSet<DBPDataSourceRegistry>();
        private final DBPRegistryListener registryListener = new DBPRegistryListener(){

            public void handleRegistryLoad(@NotNull DBPDataSourceRegistry registry) {
                registries.add(registry);
                registry.addDataSourceListener((DBPEventListener)this);
            }

            public void handleRegistryUnload(@NotNull DBPDataSourceRegistry registry) {
                registry.removeDataSourceListener((DBPEventListener)this);
                registries.remove(registry);
            }
        };

        public EventListener() {
            DataSourceProviderRegistry.getInstance().addDataSourceRegistryListener(this.registryListener);
            for (DBPDataSourceRegistry registry : DBUtils.getAllRegistries((boolean)false)) {
                this.registryListener.handleRegistryLoad(registry);
            }
        }

        public void dispose() {
            DataSourceProviderRegistry.getInstance().removeDataSourceRegistryListener(this.registryListener);
            for (DBPDataSourceRegistry registry : this.registries) {
                registry.removeDataSourceListener((DBPEventListener)this);
            }
            this.registries.clear();
        }
    }

    private static class PartListener
    extends AbstractPartListener {
        private final List<IWorkbenchPage> pages = new ArrayList<IWorkbenchPage>();
        private final IWorkbenchWindow window;
        private final IPageListener pageListener;

        public PartListener(IWorkbenchWindow window) {
            this.window = window;
            this.pageListener = new AbstractPageListener(){

                public void pageOpened(IWorkbenchPage page) {
                    page.addPartListener((IPartListener)this);
                    pages.add(page);
                }

                public void pageClosed(IWorkbenchPage page) {
                    page.removePartListener((IPartListener)this);
                    pages.remove(page);
                }
            };
            window.addPageListener(this.pageListener);
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                this.pageListener.pageOpened(page);
            }
        }

        public void dispose() {
            this.window.removePageListener(this.pageListener);
            for (IWorkbenchPage page : this.pages) {
                page.removePartListener((IPartListener)this);
            }
            this.pages.clear();
        }
    }
}

