/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security.truststore;

import com.dbeaver.model.security.StaticTLSUtils;
import com.dbeaver.model.security.truststore.CertDescriptor;
import com.dbeaver.model.security.truststore.DBPTrustedCertsProvider;
import com.dbeaver.model.security.truststore.ExtendedCertificatesRegistry;
import com.dbeaver.model.security.truststore.TrustStoreController;
import com.dbeaver.model.security.truststore.keystore.KeyStoreDescriptor;
import com.dbeaver.model.security.truststore.keystore.KeyStoreRegistry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.fs.lock.FileLock;
import org.jkiss.dbeaver.model.fs.lock.FileLockController;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Bundle;

public class LocalTrustStoreController
implements TrustStoreController {
    private static final Log log = Log.getLog(LocalTrustStoreController.class);
    public static final LocalTrustStoreController INSTANCE = new LocalTrustStoreController();
    public static final String DEFAULT_KEYSTORE_ID = "CA";
    public static final String CUSTOM_KEYSTORE_ID = "Custom";
    public static final String WINDOWS_KEYSTORE_ID = "Windows";
    public static final String BKS_TRUST_STORE_FILE_NAME = ".dbeaver-trust-store.bks";
    public static final String JKS_TRUST_STORE_FILE_NAME = ".dbeaver-trust-store.jks";
    public static final String WINDOWS_JKS_TRUST_STORE_FILE_NAME = ".os-dbeaver-trust-store.jks";
    public static final String MACOS_JKS_TRUST_STORE_FILE_NAME = ".java-dbeaver-trust-store.jks";
    private static final Set<String> SUPPORTED_AUTO_IMPORT_CERTIFICATE_EXTENSIONS = Set.of("crt", "cert", "pem", "txt");
    private static final String AUTO_IMPORTED_CERT_ALIAS_PREFIX = "auto-imported-";
    private static final String JAVA_CA_CERT_ALIAS_PREFIX = "java-ca-auto-imported-";
    private static final String SYSTEM_PROPERTY_USE_SYSTEM_CERTS = "dbeaver.security.useSystemCerts";

    @Override
    @NotNull
    public List<CertDescriptor> getCertificates(@Nullable KeyStore activeTruststore) throws DBException {
        if (activeTruststore == null) {
            return Collections.emptyList();
        }
        ArrayList<CertDescriptor> certDescriptors = new ArrayList<CertDescriptor>();
        try {
            Enumeration<String> aliases = activeTruststore.aliases();
            while (aliases.hasMoreElements()) {
                String certName = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)activeTruststore.getCertificate(certName);
                certDescriptors.add(this.createCertDescriptor(certName, certificate));
            }
        }
        catch (KeyStoreException e) {
            throw new DBException("Error reading certificate", (Throwable)e);
        }
        return certDescriptors;
    }

    @Override
    public void removeCertificate(@NotNull String keyStoreId, @NotNull KeyStore activeTruststore, @NotNull String alias) throws DBException {
        KeyStoreDescriptor keyStoreDescriptor = this.getKeyStoreDescriptor(keyStoreId);
        this.removeCertificate(activeTruststore, alias, LocalTrustStoreController.acquireDBeaverTruststorePath(GeneralUtils.getMetadataFolder(), keyStoreDescriptor.getFilePath()));
    }

    private void removeCertificate(@NotNull KeyStore activeTruststore, @NotNull String alias, @NotNull Path trustStorePath) throws DBException {
        try {
            activeTruststore.deleteEntry(alias);
            this.saveToDBeaverTrustStore(activeTruststore, trustStorePath);
        }
        catch (KeyStoreException e) {
            throw new DBException("Error, Keystore is not initialized", (Throwable)e);
        }
    }

    @Override
    public Collection<X509Certificate> addCertificates(@NotNull String keyStoreId, @NotNull KeyStore activeTruststore, @NotNull String alias, @NotNull Path certificate) throws DBException {
        Collection<X509Certificate> certs = this.addCertificates(activeTruststore, alias, certificate);
        this.saveToDBeaverTrustStore(activeTruststore, LocalTrustStoreController.acquireDBeaverTruststorePath(GeneralUtils.getMetadataFolder(), this.getKeyStoreDescriptor(keyStoreId).getFilePath()));
        return certs;
    }

    private Collection<X509Certificate> addCertificates(@NotNull KeyStore activeTruststore, @NotNull String alias, @NotNull Path certificate) throws DBException {
        CertificateFactory fac;
        try {
            fac = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new DBException("Error adding certificates", (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (InputStream is = Files.newInputStream(certificate, new OpenOption[0]);){
                Collection<? extends Certificate> certs = fac.generateCertificates(is);
                if (certs.isEmpty()) {
                    log.warn((Object)("No certificates found in " + String.valueOf(certificate)));
                }
                if (certs.size() == 1) {
                    activeTruststore.setCertificateEntry(alias, certs.iterator().next());
                } else {
                    int suffix = 1;
                    for (X509Certificate x509Certificate : certs) {
                        String realAlias = alias + "-" + suffix++;
                        activeTruststore.setCertificateEntry(realAlias, x509Certificate);
                    }
                }
                return certs;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new DBException("Error adding certificates", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public KeyStore getTrustStoreInstance(@NotNull String keyStoreId) throws DBException {
        return this.getTrustStoreInstance(keyStoreId, GeneralUtils.getMetadataFolder(), false);
    }

    @Nullable
    private KeyStore getTrustStoreInstance(@NotNull String keyStoreId, @NotNull Path metadataFolder, boolean forceReinit) throws DBException {
        try {
            KeyStoreDescriptor keyStoreDescriptor = KeyStoreRegistry.getInstance().getKeyStoreById(keyStoreId);
            if (keyStoreDescriptor == null) {
                throw new DBException("KeyStore with id '" + keyStoreId + "' not found");
            }
            Path trustStoreFilePath = LocalTrustStoreController.acquireDBeaverTruststorePath(metadataFolder, keyStoreDescriptor.getFilePath());
            String storeType = LocalTrustStoreController.getStoreType(trustStoreFilePath);
            KeyStore activeKeystore = KeyStore.getInstance(storeType);
            if (!Files.exists(trustStoreFilePath, new LinkOption[0]) || forceReinit) {
                this.initDBeaverTruststore(trustStoreFilePath, activeKeystore, keyStoreDescriptor, metadataFolder);
            }
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream is = Files.newInputStream(trustStoreFilePath, new OpenOption[0]);){
                activeKeystore.load(is, "jks".equals(storeType) ? "".toCharArray() : null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return activeKeystore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DBException("Error getting truststore instance", (Throwable)e);
        }
    }

    @NotNull
    public static String getStoreType(Path trustStore) {
        return trustStore.getFileName().toString().contains("jks") ? "jks" : "bks";
    }

    private static void injectCerts(@NotNull KeyStore activeKeystore, @NotNull KeyStore oldKeystore, @NotNull String aliasPrefix) {
        try {
            Enumeration<String> aliases = oldKeystore.aliases();
            while (aliases.hasMoreElements()) {
                String certName = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)oldKeystore.getCertificate(certName);
                activeKeystore.setCertificateEntry(aliasPrefix + certName, certificate);
            }
        }
        catch (KeyStoreException e) {
            log.warn((Object)"Error reading certificate information", (Throwable)e);
        }
    }

    @NotNull
    private KeyStore getCATrust() throws GeneralSecurityException, IOException {
        Path filename = Path.of(System.getProperty("java.home"), new String[0]).resolve("lib").resolve("security").resolve("cacerts");
        KeyStore caTrust = KeyStore.getInstance(KeyStore.getDefaultType());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(filename.toFile());){
            caTrust.load(is, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return caTrust;
    }

    private void initDBeaverTruststore(@NotNull Path trustStoreFilePath, @NotNull KeyStore activeKeystore, @NotNull KeyStoreDescriptor keyStoreDescriptor, @NotNull Path metadataFolder) throws DBException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream fileOutputStream = Files.newOutputStream(trustStoreFilePath, new OpenOption[0]);){
                activeKeystore.load(null, null);
                List<CertDescriptor> existCertificates = this.getCertificates(activeKeystore);
                for (CertDescriptor certificate : existCertificates) {
                    if (!certificate.getAlias().startsWith(AUTO_IMPORTED_CERT_ALIAS_PREFIX) && !certificate.getAlias().startsWith(JAVA_CA_CERT_ALIAS_PREFIX)) continue;
                    log.trace((Object)("Remove exist auto-imported cert: " + certificate.getAlias()));
                    activeKeystore.deleteEntry(certificate.getAlias());
                }
                this.injectDefaultCerts(DBWorkbench.getPlatform().getApplication(), activeKeystore, keyStoreDescriptor, metadataFolder);
                this.saveToDBeaverTrustStore(activeKeystore, trustStoreFilePath);
                activeKeystore.store(fileOutputStream, "".toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DBException("Error creating keystore instance", (Throwable)e);
        }
    }

    private CertDescriptor createCertDescriptor(@NotNull String certName, @Nullable X509Certificate certificate) {
        if (certificate != null) {
            boolean isValid = true;
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
                isValid = false;
            }
            return new CertDescriptor(certName, certificate, isValid);
        }
        return null;
    }

    private void saveToDBeaverTrustStore(@NotNull KeyStore activeTruststore, @NotNull Path trustStorePath) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream fileOutputStream = Files.newOutputStream(trustStorePath, new OpenOption[0]);){
                activeTruststore.store(fileOutputStream, activeTruststore.getType().equals("jks") ? "".toCharArray() : null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving Truststore", (Throwable)e);
        }
    }

    @NotNull
    private static Path acquireDBeaverTruststorePath(@NotNull Path metadataFolder, @NotNull String fileName) {
        if (JKS_TRUST_STORE_FILE_NAME.equals(fileName)) {
            try {
                LocalTrustStoreController.migrateToJKSRepositoryIfNotPresent(metadataFolder);
            }
            catch (KeyStoreException e) {
                log.error((Object)"Error migrating truststore to JKS format, reverting to the BKS format", (Throwable)e);
                return metadataFolder.resolve(BKS_TRUST_STORE_FILE_NAME);
            }
        }
        return metadataFolder.resolve(fileName);
    }

    private static void migrateToJKSRepositoryIfNotPresent(@NotNull Path metadataFolder) throws KeyStoreException {
        Path jksTrust = metadataFolder.resolve(JKS_TRUST_STORE_FILE_NAME);
        Path bksTrust = metadataFolder.resolve(BKS_TRUST_STORE_FILE_NAME);
        if (!jksTrust.toFile().exists() && bksTrust.toFile().exists()) {
            log.debug((Object)"Migrating trust store to JKS format");
            KeyStore newKeyStore = KeyStore.getInstance("jks");
            KeyStore oldKeyStore = KeyStore.getInstance("bks");
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (OutputStream outputStream = Files.newOutputStream(jksTrust, new OpenOption[0]);){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (InputStream is = Files.newInputStream(bksTrust, new OpenOption[0]);){
                        oldKeyStore.load(is, null);
                        newKeyStore.load(null, null);
                        LocalTrustStoreController.injectCerts(newKeyStore, oldKeyStore, "");
                        newKeyStore.store(outputStream, "".toCharArray());
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new KeyStoreException("Error loading keystore truststore", e);
            }
        }
    }

    private LocalTrustStoreController() {
    }

    private void injectDefaultCerts(@NotNull DBPApplication application, @NotNull KeyStore activeKeystore, @NotNull KeyStoreDescriptor keyStoreDescriptor, @NotNull Path metadataFolder) throws GeneralSecurityException, IOException, DBException {
        FileLockController lockController = new FileLockController(GeneralUtils.getProductName() + DBWorkbench.getPlatform().getApplication().getApplicationRunId(), metadataFolder);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileLock ignored = lockController.lock(keyStoreDescriptor.getFilePath(), "certificates auto-import");){
            if (!DEFAULT_KEYSTORE_ID.equals(keyStoreDescriptor.getId()) && CommonUtils.isNotEmpty((String)keyStoreDescriptor.getStoreType())) {
                KeyStore keychain = KeyStore.getInstance(keyStoreDescriptor.getStoreType());
                keychain.load(null, null);
                LocalTrustStoreController.injectCerts(activeKeystore, keychain, AUTO_IMPORTED_CERT_ALIAS_PREFIX);
            }
            KeyStore caTrust = this.getCATrust();
            LocalTrustStoreController.injectCerts(activeKeystore, caTrust, JAVA_CA_CERT_ALIAS_PREFIX);
            this.injectDBeaverProvidedCerts(activeKeystore, metadataFolder);
            this.injectCertsFromAutoScannedFolders(application, activeKeystore, metadataFolder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void injectDBeaverProvidedCerts(KeyStore activeKeystore, Path metadataFolder) {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        List<Object> extCertificates = Collections.emptyList();
        if (preferenceStore.getBoolean("security.truststore.custom") && preferenceStore.getBoolean("security.truststore.load.extended.ca")) {
            extCertificates = ExtendedCertificatesRegistry.getInstance().getCertificates();
        }
        for (ExtendedCertificatesRegistry.CertificateDescriptor cert : extCertificates) {
            Bundle bundle = Platform.getBundle((String)cert.contributor().getName());
            Path caCertFile = StaticTLSUtils.getStaticCertFile((DBRProgressMonitor)new LoggingProgressMonitor(log), metadataFolder, localFile -> {
                try {
                    return bundle.getResource("tls/" + localFile).openStream();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                    return null;
                }
            }, cert.localFolder(), cert.url());
            if (caCertFile == null || !Files.exists(caCertFile, new LinkOption[0])) continue;
            this.autoImportCertificate(caCertFile, activeKeystore, metadataFolder);
        }
    }

    public void initializeTrustStore(@NotNull DBPApplication application) throws DBException {
        Path workspacePath = application.getDefaultWorkingFolder();
        if (workspacePath == null) {
            return;
        }
        Path metadataFolder = IOUtils.isFileFromDefaultFS((Path)workspacePath) ? GeneralUtils.getMetadataFolder((Path)workspacePath) : GeneralUtils.getMetadataFolder();
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        String keyStoreId = this.resolveKeyStoreIdFromPreferenceStore(preferenceStore);
        KeyStoreDescriptor keyStoreDescriptor = KeyStoreRegistry.getInstance().getKeyStoreById(keyStoreId);
        if (keyStoreDescriptor == null) {
            throw new DBException("KeyStore with id '" + keyStoreId + "' not found");
        }
        this.getTrustStoreInstance(keyStoreId, metadataFolder, true);
        Path trustStoreFilePath = LocalTrustStoreController.acquireDBeaverTruststorePath(metadataFolder, keyStoreDescriptor.getFilePath());
        this.useCustomTrustStoreIfStoreExists(trustStoreFilePath);
    }

    @NotNull
    public String resolveKeyStoreIdFromPreferenceStore(@NotNull DBPPreferenceStore preferenceStore) {
        String keyStoreId = preferenceStore.getString("security.truststore.id");
        if (CommonUtils.isNotEmpty((String)keyStoreId)) {
            return keyStoreId;
        }
        keyStoreId = preferenceStore.getBoolean("security.truststore.custom") ? CUSTOM_KEYSTORE_ID : (preferenceStore.getBoolean("connections.useWinTrustStoreType") ? WINDOWS_KEYSTORE_ID : DEFAULT_KEYSTORE_ID);
        preferenceStore.setValue("security.truststore.id", keyStoreId);
        return keyStoreId;
    }

    private void injectCertsFromAutoScannedFolders(@NotNull DBPApplication application, @NotNull KeyStore activeKeystore, @NotNull Path metadataFolder) throws DBException {
        List<Path> trustCertsRootFolders = null;
        if (application instanceof DBPTrustedCertsProvider) {
            DBPTrustedCertsProvider trustedCertsProvider = (DBPTrustedCertsProvider)application;
            trustCertsRootFolders = trustedCertsProvider.getCertificatesRootFolders();
        }
        if (trustCertsRootFolders == null) {
            return;
        }
        ArrayList<Path> customCertFolders = new ArrayList<Path>();
        for (Path trustCertsRootFolder : trustCertsRootFolders) {
            customCertFolders.add(trustCertsRootFolder.resolve("custom-certs"));
            customCertFolders.add(trustCertsRootFolder.resolve("custom"));
        }
        if (!application.isMultiuser() && (RuntimeUtils.isLinux() || RuntimeUtils.isMacOS()) && Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_USE_SYSTEM_CERTS, "true"))) {
            customCertFolders.add(Path.of("/etc/ssl/certs", new String[0]));
        }
        boolean certFoldersEmpty = true;
        try {
            for (Path customCertFolder : customCertFolders) {
                if (!Files.exists(customCertFolder, new LinkOption[0]) || IOUtils.isFolderEmpty((Path)customCertFolder)) continue;
                certFoldersEmpty = false;
            }
        }
        catch (IOException e) {
            throw new DBException("Error checking custom certificates folder", (Throwable)e);
        }
        if (certFoldersEmpty) {
            return;
        }
        this.importCustomCertificates(activeKeystore, metadataFolder, customCertFolders);
    }

    private void importCustomCertificates(@NotNull KeyStore dbeaverKeyStore, @NotNull Path metadataFolder, @NotNull List<Path> customCertFolders) {
        for (Path customCertFolder : customCertFolders) {
            try {
                if (!Files.exists(customCertFolder, new LinkOption[0])) continue;
                Throwable throwable = null;
                Object var7_9 = null;
                try (DirectoryStream<Path> files = Files.newDirectoryStream(customCertFolder);){
                    files.forEach(certPath -> {
                        if (LocalTrustStoreController.isCertificateSupported(certPath, false)) {
                            this.autoImportCertificate((Path)certPath, dbeaverKeyStore, metadataFolder);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)("Error reading trust certificates folder " + String.valueOf(customCertFolder)), (Throwable)e);
            }
        }
    }

    private boolean autoImportCertificate(@NotNull Path certPath, @NotNull KeyStore dbeaverKeyStore, @NotNull Path metadataFolder) {
        block3: {
            try {
                if (LocalTrustStoreController.isCertificateSupported(certPath, true)) break block3;
                return false;
            }
            catch (Exception e) {
                log.error((Object)("Error loading certificate '" + String.valueOf(certPath.toAbsolutePath()) + "'"), (Throwable)e);
                return false;
            }
        }
        log.debug((Object)("Loading certificate: " + String.valueOf(certPath.toAbsolutePath())));
        String certName = AUTO_IMPORTED_CERT_ALIAS_PREFIX + certPath.getFileName().toString();
        this.addCertificates(dbeaverKeyStore, certName, certPath);
        return true;
    }

    private static boolean isCertificateSupported(@NotNull Path path, boolean logProblems) {
        String extension;
        block10: {
            block9: {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                try {
                    if (Files.isHidden(path)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    if (!logProblems) break block9;
                    log.debug((Object)("Unable to determine if file is hidden: " + String.valueOf(path)), (Throwable)e);
                }
            }
            if (Files.isSymbolicLink(path)) {
                try {
                    path = Files.readSymbolicLink(path);
                }
                catch (IOException e) {
                    if (!logProblems) break block10;
                    log.debug((Object)("Unable to resolve symbolic link " + String.valueOf(path)), (Throwable)e);
                }
            }
        }
        if (CommonUtils.isEmpty((String)(extension = IOUtils.getFileExtension((Path)path)))) {
            if (logProblems) {
                log.debug((Object)("Unsupported file extension: " + String.valueOf(path) + "; only " + String.join((CharSequence)", ", SUPPORTED_AUTO_IMPORT_CERTIFICATE_EXTENSIONS) + " are supported"));
            }
            return false;
        }
        return SUPPORTED_AUTO_IMPORT_CERTIFICATE_EXTENSIONS.contains(extension);
    }

    public void changeTrustStoreIfNeeded() {
        if (CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && CommonUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType")) && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("security.truststore.custom")) {
            this.useCustomTrustStoreIfStoreExists(GeneralUtils.getMetadataFolder());
        }
    }

    private void useCustomTrustStoreIfStoreExists(@NotNull Path trustStoreFile) {
        if (Files.exists(trustStoreFile, new LinkOption[0])) {
            System.setProperty("javax.net.ssl.trustStore", trustStoreFile.toAbsolutePath().toString());
            System.setProperty("javax.net.ssl.trustStoreType", LocalTrustStoreController.getStoreType(trustStoreFile));
        }
    }

    @NotNull
    private KeyStoreDescriptor getKeyStoreDescriptor(@NotNull String keyStoreId) throws DBException {
        KeyStoreDescriptor keyStoreDescriptor = KeyStoreRegistry.getInstance().getKeyStoreById(keyStoreId);
        if (keyStoreDescriptor == null) {
            throw new DBException("KeyStore with id '" + keyStoreId + "' not found");
        }
        return keyStoreDescriptor;
    }
}

