/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net.k8s;

import com.dbeaver.model.net.k8s.KubeCtrlExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class K8SNamespaceInfo {
    private static final Pattern NS_NAME_PATTER = Pattern.compile("([\\w\\-]+)\\s+");
    private final DBWHandlerConfiguration configuration;
    private final List<String> namespaces = new ArrayList<String>();

    public DBWHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    K8SNamespaceInfo(DBWHandlerConfiguration configuration, String nsOutput) {
        this.configuration = configuration;
        String[] lines = nsOutput.split("\\n");
        int i = 1;
        while (i < lines.length) {
            Matcher matcher;
            String svcLine = lines[i].trim();
            if (!CommonUtils.isEmpty((String)svcLine) && (matcher = NS_NAME_PATTER.matcher(svcLine)).find()) {
                this.namespaces.add(matcher.group(1));
            }
            ++i;
        }
    }

    public static K8SNamespaceInfo getNamespaceInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        String svcOut = KubeCtrlExecutor.executeCommand(monitor, configuration, false, "get", "namespace");
        return new K8SNamespaceInfo(configuration, svcOut);
    }
}

