/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractCommandLineTunnel
implements DBWTunnel {
    private static final Log log = Log.getLog(AbstractCommandLineTunnel.class);
    public static final int MAX_FORWARD_ATTEMPT_COUNT = 50;
    private DBWHandlerConfiguration configuration;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private int localPort = -1;
    private Process forwardPortProccess;

    public static String getDefaultRemotePort(@NotNull DBWHandlerConfiguration configuration) {
        String hostPort = "";
        if (configuration.getDataSource() != null && CommonUtils.isEmpty((String)(hostPort = configuration.getDataSource().getConnectionConfiguration().getHostPort()))) {
            hostPort = configuration.getDriver().getDefaultPort();
        }
        return hostPort;
    }

    public Process getForwardPortProccess() {
        return this.forwardPortProccess;
    }

    public DBWHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void addCloseListener(@NotNull Runnable listener) {
        this.listeners.add(listener);
    }

    @NotNull
    public DBPConnectionConfiguration initializeHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        this.configuration = configuration;
        this.localPort = IOUtils.findFreePort((int)10000, (int)60000);
        monitor.subTask("Initiate port forwarding to localhost:" + this.localPort);
        this.forwardPortProccess = this.createTunnelProcess(monitor, configuration, connectionInfo, this.localPort);
        int attemptCount = 0;
        while (this.forwardPortProccess.isAlive() && attemptCount < 50) {
            monitor.subTask("Waiting for tunnel establish");
            ++attemptCount;
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (Socket testSocket = new Socket();){
                    InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.localPort);
                    testSocket.connect(addr);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                RuntimeUtils.pause((int)100);
            }
        }
        if (attemptCount >= 50) {
            this.closeTunnel(monitor);
            throw new DBException("Error establishing port forwarding. Max attempt count (50) exceeded.");
        }
        monitor.subTask("Complete configuration");
        if (!this.forwardPortProccess.isAlive()) {
            try {
                RuntimeUtils.getProcessResults((Process)this.forwardPortProccess);
            }
            catch (InterruptedException interruptedException) {
                this.forwardPortProccess = null;
            }
        }
        DBWUtils.updateConfigWithTunnelInfo((DBWHandlerConfiguration)configuration, (DBPConnectionConfiguration)connectionInfo, null, (int)this.localPort);
        return connectionInfo;
    }

    protected abstract Process createTunnelProcess(@NotNull DBRProgressMonitor var1, @NotNull DBWHandlerConfiguration var2, @NotNull DBPConnectionConfiguration var3, int var4) throws IOException, DBException;

    public void closeTunnel(@NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
        this.listeners.clear();
        if (this.forwardPortProccess != null) {
            if (this.forwardPortProccess.isAlive()) {
                this.forwardPortProccess.destroy();
            }
            this.forwardPortProccess = null;
        }
    }

    @Nullable
    public Object getImplementation() {
        return this;
    }

    public boolean matchesParameters(@NotNull String host, int port) {
        return false;
    }

    @NotNull
    public DBWTunnel.AuthCredentials getRequiredCredentials(@NotNull DBWHandlerConfiguration configuration) {
        return DBWTunnel.AuthCredentials.NONE;
    }

    public void invalidateHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) throws DBException {
    }

    @NotNull
    public static DBRProcessDescriptor createProcessByArguments(List<String> arguments) {
        DBRShellCommand cliCommand = new DBRShellCommand(arguments);
        cliCommand.setEnabled(true);
        return new DBRProcessDescriptor(cliCommand);
    }
}

