/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.mq;

import com.google.gson.Gson;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class MQMessage {
    private static final Gson gson = new Gson();
    @NotNull
    private final String queueId;
    @NotNull
    private final String value;
    @Nullable
    private final String key;
    @NotNull
    private final Map<String, String> headers;

    public MQMessage(@NotNull String queueId, @NotNull Object value, @Nullable String key) {
        this(queueId, value, key, Map.of());
    }

    public MQMessage(@NotNull String queueId, @NotNull Object value) {
        this(queueId, value, null, Map.of());
    }

    public MQMessage(@NotNull String queueId, @NotNull Object value, @Nullable String key, @NotNull Map<String, String> headers) {
        this.queueId = queueId;
        this.value = value instanceof String ? (String)value : gson.toJson(value);
        this.key = key;
        this.headers = headers;
    }

    @NotNull
    public String getQueueId() {
        return this.queueId;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

