/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.dpi;

import com.dbeaver.dpi.DPIController;
import com.dbeaver.dpi.adapters.DPISerializer;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DPIContext {
    private static final Log log = Log.getLog(DPIContext.class);
    private final Map<String, Object> objectIdCache = new HashMap<String, Object>();
    private final Map<Object, String> objectValueCache = new HashMap<Object, String>();
    private final AtomicLong objectCount = new AtomicLong();
    private final DBRProgressMonitor monitor;
    private final Object rootObject;
    private final Gson gson;
    private DPIController dpiController;

    public DPIContext(@NotNull DBRProgressMonitor monitor, @NotNull Object rootObject, boolean server) {
        this.monitor = monitor;
        this.rootObject = rootObject;
        this.gson = server ? DPISerializer.createServerSerializer(this) : DPISerializer.createClientSerializer(this);
    }

    public DPIController getDpiController() {
        return this.dpiController;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setController(DPIController dpiController) {
        this.dpiController = dpiController;
    }

    public Object getObject(String id) {
        return this.objectIdCache.get(id);
    }

    public void addObject(String id, Object object) {
        this.objectIdCache.put(id, object);
        this.objectValueCache.put(object, id);
    }

    public void pruneObject(String id) {
        Object removed = this.objectIdCache.remove(id);
        if (removed != null) {
            String removedId = this.objectValueCache.remove(removed);
            if (removedId == null) {
                log.warn((Object)"Pruned DPI object value wasn't found in value cache");
            } else if (!removedId.equals(id)) {
                log.warn((Object)("Pruned DPI object ID doesn't match (" + removedId + "<>" + id));
            }
        } else {
            log.warn((Object)("Cannot find object '" + id + "' for prune"));
        }
    }

    public String getOrCreateObjectId(Object object) {
        String id = this.objectValueCache.get(object);
        if (id == null) {
            id = String.valueOf(this.objectCount.incrementAndGet());
            this.addObject(id, object);
        }
        return id;
    }

    public String getObjectId(Object object) {
        return this.objectValueCache.get(object);
    }

    public boolean hasObject(Object object) {
        return this.objectValueCache.containsKey(object);
    }

    @NotNull
    public Object getRootObject() {
        return this.rootObject;
    }

    @NotNull
    public ClassLoader getClassLoader() {
        if (this.rootObject instanceof DBPDataSourceContainer) {
            return ((DBPDataSourceContainer)this.rootObject).getDriver().getDataSourceProvider().getClass().getClassLoader();
        }
        return this.rootObject.getClass().getClassLoader();
    }

    @NotNull
    public DBRProgressMonitor getProgressMonitor() {
        return this.monitor;
    }
}

