/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import org.jkiss.code.NotNull;

public enum GCPAuthType {
    SERVICE_ACCOUNT("Key file", true),
    DEFAULT("Default credentials", true),
    SSO_OVER_CLI("Web Browser", true, true),
    SESSION_CREDENTIALS("Session credentials", false),
    PREGENERATED_OAUTH("OAuth (Pregenerated)", false, true);

    private final String title;
    private final boolean supportsAssumeRole;
    private final boolean desktop;

    private GCPAuthType(String title, boolean supportsAssumeRole) {
        this(title, supportsAssumeRole, false);
    }

    private GCPAuthType(String title, boolean supportsAssumeRole, boolean desktop) {
        this.title = title;
        this.supportsAssumeRole = supportsAssumeRole;
        this.desktop = desktop;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public boolean isSupportsAssumeRole() {
        return this.supportsAssumeRole;
    }

    public boolean isDesktop() {
        return this.desktop;
    }

    public String toString() {
        return this.title;
    }
}

