/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.dbeaver.net.auth.gcp.GCPAuthUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelGCPAbstract<T extends AuthModelGCPCredentials>
extends AuthModelDatabaseNative<T> {
    @NotNull
    protected abstract T copyCredentials(@NotNull AuthModelGCPCredentials var1);

    @NotNull
    public T loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelGCPCredentials credentials = (AuthModelGCPCredentials)((Object)configuration.getRuntimeAttribute("gcp.iam_credentials"));
        Map properties = configuration.getAuthProperties();
        if (credentials == null) {
            credentials = (AuthModelGCPCredentials)super.loadCredentials(dataSource, configuration);
            if (properties != null) {
                AuthModelGCPAbstract.loadCredentialsFromMap(credentials, properties);
            }
        } else {
            credentials = this.copyCredentials(credentials);
            super.loadCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        }
        if (DBWorkbench.isDistributed() && !DBWorkbench.getPlatform().getApplication().isMultiuser() && !CommonUtils.isEmpty((Map)properties) && properties.containsKey("gcp.use_session_credentials")) {
            this.updateCredentialsFromSession(credentials);
        }
        return (T)((Object)credentials);
    }

    private void updateCredentialsFromSession(@NotNull T credentials) {
        Map objectMap;
        SMSession mainSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (mainSession != null && !CommonUtils.isEmpty((Map)(objectMap = SMAuthUtils.getCredentialsFromSession((SMSession)mainSession, (String)"google-openid")))) {
            GCPAuthUtils.updateCredentialsFromSessionData(objectMap, credentials);
        }
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull T credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelGCPAbstract.saveCredentialsToMap(credentials, authProperties);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
        super.saveCredentials(dataSource, configuration, credentials);
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull T credentials) throws DBException {
    }

    public static void loadCredentialsFromMap(AuthModelGCPCredentials credentials, Map<String, String> authProperties) {
        credentials.setAuthType((GCPAuthType)CommonUtils.valueOf(GCPAuthType.class, (String)authProperties.get("gcp.authType")));
        credentials.setServiceAccountConfigPath(authProperties.get("gcp.sa_config_path"));
        credentials.setServiceAccountConfig(authProperties.get("gcp.sa_config"));
        credentials.setClientId(authProperties.get("gcp.client_id"));
        credentials.setClientSecret(authProperties.get("gcp.client_secret"));
        credentials.setRefreshToken(authProperties.get("gcp.refresh_token"));
        credentials.setSsoOverCli(CommonUtils.getBoolean((String)authProperties.get("gcp.sso")));
        credentials.setProjectId(CommonUtils.toString((Object)authProperties.get("gcp.default_project")));
        credentials.resetCache();
    }

    public static void saveCredentialsToMap(@NotNull AuthModelGCPCredentials credentials, Map<String, String> authProperties) {
        if (credentials.getAuthType() != null) {
            authProperties.put("gcp.authType", credentials.getAuthType().name());
        } else {
            authProperties.remove("gcp.authType");
        }
        authProperties.put("gcp.sa_config_path", credentials.getServiceAccountConfigPath());
        authProperties.put("gcp.sa_config", credentials.getServiceAccountConfig());
        authProperties.put("gcp.client_id", credentials.getClientId());
        authProperties.put("gcp.client_secret", credentials.getClientSecret());
        authProperties.put("gcp.refresh_token", credentials.getRefreshToken());
        if (credentials.isSsoOverCli()) {
            authProperties.put("gcp.sso", Boolean.TRUE.toString());
        } else {
            authProperties.remove("gcp.sso");
        }
        if (CommonUtils.isEmpty((String)credentials.getProjectId())) {
            authProperties.remove("gcp.default_project");
        } else {
            authProperties.put("gcp.default_project", credentials.getProjectId());
        }
    }

    public boolean supportsDatabaseUser() {
        return true;
    }
}

