/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.model.tasks;

import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SCMPChangelogTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) {
        CMPOptions options = new CMPOptions(true);
        options.loadConfiguration(runnableContext, task.getProperties());
        try {
            runnableContext.run(true, true, monitor -> {
                CMPResult cmpResult;
                Exception error;
                block17: {
                    monitor.beginTask(task.getType().getName(), 1);
                    monitor.subTask(task.getType().getName());
                    DBPDataSourceContainer sourceContainer = options.getSourceDataSourceContainer();
                    if (sourceContainer == null) {
                        DBWorkbench.getPlatformUI().showError("Schema Compare", "Container for the changelog is missing");
                        return;
                    }
                    List<DBSObject> sourceInputObjects = options.getSourceInputObjects();
                    if (sourceInputObjects.isEmpty()) {
                        DBWorkbench.getPlatformUI().showError("Schema Compare", "There are no objects for the changelog");
                        return;
                    }
                    monitor.beginTask("Create changelog for '" + DBUtils.getObjectFullName((DBPNamedObject)sourceContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'", 100);
                    Log.setLogWriter((OutputStream)logStream);
                    listener.taskStarted(task);
                    error = null;
                    cmpResult = null;
                    try {
                        try {
                            Throwable throwable = null;
                            Object var11_13 = null;
                            try (CMPCompareEngine engine = LBUtils.createDiffEngine(options);){
                                monitor.beginTask("Perform changelog using engine...", 10);
                                monitor.subTask("Prepare");
                                cmpResult = engine.compareObjects(monitor, options);
                                if (options.isExportFile() && cmpResult != null) {
                                    LBUtils.createAndExportReportFile(monitor, task, options, cmpResult);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            error = e;
                            log.debug((Object)"Can't create changelog for objects", (Throwable)e);
                            monitor.done();
                            Log.setLogWriter(null);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.done();
                        Log.setLogWriter(null);
                        throw throwable;
                    }
                    monitor.done();
                    Log.setLogWriter(null);
                }
                listener.taskFinished(task, cmpResult, (Throwable)error, (Object)options);
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Change log creation", "Error creating changelog", e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
        return new DBTTaskRunStatus();
    }
}

