/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase.report;

import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeItem;
import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeSet;
import com.dbeaver.ee.scmp.impl.liquibase.report.LBReportEngineAbstract;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPQueryReportEngine;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultQuery;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LBReportEngineDDL
extends LBReportEngineAbstract
implements CMPQueryReportEngine {
    private static final Log log = Log.getLog(LBReportEngineDDL.class);

    @Override
    public void generateDiffReport(DBRProgressMonitor monitor, CMPResult result, OutputStream stream) throws IOException, CMPException {
        LBResultChangeSet changeSet = (LBResultChangeSet)result.getChangeSet();
        List<ChangeSet> lbChangeSets = changeSet.getSourceDiff();
        Database targetDatabase = changeSet.getTargetDatabase();
        if (targetDatabase == null) {
            targetDatabase = changeSet.getSourceDatabase();
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, GeneralUtils.getDefaultFileEncoding());
        int changeCount = this.countChanges(result);
        monitor.beginTask("Generate DDL for changeset", changeCount);
        for (ChangeSet changeset : lbChangeSets) {
            List changes = changeset.getChanges();
            for (Change change : changes) {
                monitor.subTask("Process change " + change.getDescription());
                if (!changeSet.isChangeEnabled(change)) continue;
                try {
                    targetDatabase.saveStatements(change, null, (Writer)writer);
                }
                catch (Exception e) {
                    log.debug((Object)("Error generating change SQL: " + e.getMessage()));
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        ((Writer)writer).flush();
    }

    @Override
    public CMPResultQuery[] generateDiffQueries(DBRProgressMonitor monitor, CMPResult result) throws IOException, CMPException {
        ArrayList<CMPResultQuery> queries = new ArrayList<CMPResultQuery>();
        LBResultChangeSet changeSet = (LBResultChangeSet)result.getChangeSet();
        Database targetDatabase = changeSet.getTargetDatabase();
        int changeCount = this.countChanges(result);
        monitor.beginTask("Generate DDL for changeset", changeCount);
        for (LBResultChangeItem changeItem : changeSet.getChangeItems()) {
            monitor.subTask("Process change " + changeItem.getChange().getDescription());
            if (!changeItem.isEnabled()) continue;
            try {
                SqlStatement[] statements;
                SqlStatement[] sqlStatementArray = statements = changeItem.getChange().generateStatements(targetDatabase);
                int n = statements.length;
                int n2 = 0;
                while (n2 < n) {
                    SqlStatement statement = sqlStatementArray[n2];
                    Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql(statement, targetDatabase);
                    int n3 = sqlArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Sql sql = sqlArray[n4];
                        queries.add(new CMPResultQuery(changeItem, sql.toSql()));
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error generating change SQL: " + e.getMessage()));
            }
            monitor.worked(1);
        }
        return queries.toArray(new CMPResultQuery[0]);
    }
}

