/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase.report;

import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeSet;
import com.dbeaver.ee.scmp.model.CMPReportEngine;
import com.dbeaver.ee.scmp.model.CMPResult;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public abstract class LBReportEngineAbstract
implements CMPReportEngine {
    private static final Log log = Log.getLog(LBReportEngineAbstract.class);

    public int countChanges(CMPResult result) {
        List<ChangeSet> lbChangeSets = ((LBResultChangeSet)result.getChangeSet()).getSourceDiff();
        int changeCount = 0;
        for (ChangeSet changeset : lbChangeSets) {
            changeCount += changeset.getChanges().size();
        }
        return changeCount;
    }

    @NotNull
    protected List<ChangeSet> getFilteredLBChangeSets(LBResultChangeSet changeSet) {
        ArrayList<ChangeSet> lbChangeSets = new ArrayList<ChangeSet>();
        block0: for (ChangeSet cs : changeSet.getSourceDiff()) {
            for (Change c : cs.getChanges()) {
                if (!changeSet.isChangeEnabled(c)) continue;
                lbChangeSets.add(cs);
                continue block0;
            }
        }
        return lbChangeSets;
    }
}

