/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.ui.session;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.session.NetezzaSession;
import com.dbeaver.db.netezza.model.session.NetezzaSessionManager;
import com.dbeaver.db.netezza.ui.NetezzaMessages;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;
import org.jkiss.utils.CommonUtils;

public class NetezzaSessionEditor
extends AbstractSessionEditor {
    private KillSessionAction terminateQueryAction;
    private KillSessionAction rollbackTransaction;

    public void createEditorControl(Composite parent) {
        this.terminateQueryAction = new KillSessionAction(true);
        this.rollbackTransaction = new KillSessionAction(false);
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<NetezzaSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new NetezzaSessionManager((NetezzaDataSourceExt)executionContext.getDataSource())){
            private boolean justActive;

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)NetezzaSessionEditor.this.terminateQueryAction);
                contributionManager.add((IAction)NetezzaSessionEditor.this.rollbackTransaction);
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(NetezzaMessages.session_editor_show_active, 2){
                    {
                        this.setToolTipText(NetezzaMessages.session_editor_show_active_tip);
                        this.setChecked(justActive);
                    }

                    public void run() {
                        justActive = this.isChecked();
                        NetezzaSessionEditor.this.refreshPart((Object)NetezzaSessionEditor.this, true);
                    }
                }, (boolean)true));
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                NetezzaSessionEditor.this.terminateQueryAction.setEnabled(session != null);
                NetezzaSessionEditor.this.rollbackTransaction.setEnabled(session != null && !CommonUtils.isEmpty((String)session.getActiveQuery()));
            }

            public Map<String, Object> getSessionOptions() {
                if (this.justActive) {
                    return Collections.singletonMap("justActive", true);
                }
                return super.getSessionOptions();
            }

            protected void loadSettings(IDialogSettings settings) {
                this.justActive = CommonUtils.toBoolean((Object)settings.get("justActive"));
                super.loadSettings(settings);
            }

            protected void saveSettings(IDialogSettings settings) {
                super.saveSettings(settings);
                settings.put("justActive", this.justActive);
            }
        };
    }

    private class KillSessionAction
    extends Action {
        boolean dropSession;

        KillSessionAction(boolean dropSession) {
            super(dropSession ? NetezzaMessages.session_editor_drop_session : NetezzaMessages.session_editor_rollback_transaction, dropSession ? UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP") : DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.TXN_ROLLBACK));
            if (dropSession) {
                this.setToolTipText(NetezzaMessages.session_editor_drop_session_tip);
            } else {
                this.setToolTipText(NetezzaMessages.session_editor_aborting_transaction);
            }
            this.dropSession = dropSession;
        }

        public void run() {
            List sessions = NetezzaSessionEditor.this.getSessionsViewer().getSelectedSessions();
            if (sessions != null && UIUtils.confirmAction((Shell)NetezzaSessionEditor.this.getSite().getShell(), (String)this.getText(), (String)NLS.bind((String)NetezzaMessages.editors_session_editor_confirm, (Object)this.getText(), (Object)sessions))) {
                NetezzaSessionEditor.this.getSessionsViewer().alterSessions(sessions, Collections.singletonMap("rollbackTrans", !this.dropSession));
            }
        }
    }
}

