/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.AspListItem;
import com.ibm.as400.access.list.OpenList;
import java.io.IOException;

public class AspOpenList
extends OpenList {
    private static final long serialVersionUID = -7701422559222997434L;
    public static final String FORMAT_0100 = "YASP0100";
    public static final String FORMAT_0200 = "YASP0200";
    public static final String FORMAT_0300 = "YASP0300";
    public static final String FORMAT_0400 = "YASP0400";
    public static final String FORMAT_0500 = "YASP0500";
    public static final String FORMAT_0600 = "YASP0600";
    public static final String ASP_NUMBER = "ASPN_UMBER";
    public static final String RESOURCE_NAME = "RESOURCE_NAME";
    public static final String DEVICEDESCRIPTION_NAME = "DEVICEDESCRIPTION_NAME";
    public static final String DATABASE_NAME = "DATABASE_NAME";
    public static final String UNASSIGNED_DISK = "UNASSIGNED_DISK";
    public static final String ALL_ASP_SELECTED = "ALL_ASP_SELECTED";
    public static final String ALL_USER_ASP_SELECTED = "ALL_USER_ASP_SELECTED";
    public static final String ALL_IASP_SELECTED = "ALL_IASP_SELECTED";
    private int format_ = 1;
    private String aspName_;
    private int aspNumber_;
    private int filterKey_ = 1;
    private int filterNumber = 1;
    private byte[] filterNumberbyte_;
    private byte[] formatBytes_;
    private String filterDataType_;

    public AspOpenList(AS400 system) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
    }

    public AspOpenList(AS400 system, String format) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(format);
    }

    public AspOpenList(AS400 system, String format, String filterDataType) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(format);
        this.setFilterKey(filterDataType);
    }

    public AspOpenList(AS400 system, String format, int aspNumber) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setASPNumber(aspNumber);
        this.setFormat(format);
    }

    public AspOpenList(AS400 system, String format, String filterDataType, String name) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing AspOpenList object.");
        }
        this.setFormat(format);
        this.setFilterKey(filterDataType);
        this.setASPName(name);
    }

    @Override
    protected byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] allAsp;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening APSs list.");
        }
        CharConverter conv = new CharConverter(this.system_.getCcsid(), this.system_);
        if (Trace.isTraceOn()) {
            Trace.log(1, "The filter key of filter information is " + this.filterKey_);
        }
        int filterInformationLength = 16;
        int filterDataSize = 4;
        if (this.filterKey_ == 4) {
            filterInformationLength = 32;
            filterDataSize = 18;
        } else if (this.filterKey_ == 2 || this.filterKey_ == 3) {
            filterInformationLength = 24;
            filterDataSize = 10;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "The filter information length " + filterInformationLength);
        }
        this.filterNumberbyte_ = BinaryConverter.intToByteArray(this.filterNumber);
        int offset = 0;
        byte[] filterInformation_ = new byte[filterInformationLength];
        BinaryConverter.intToByteArray(filterInformationLength, filterInformation_, offset);
        BinaryConverter.intToByteArray(this.filterKey_, filterInformation_, offset += 4);
        BinaryConverter.intToByteArray(filterDataSize, filterInformation_, offset += 4);
        offset += 4;
        if (this.filterDataType_ == null || this.filterDataType_.length() == 0 || this.filterDataType_.equals(ALL_ASP_SELECTED)) {
            allAsp = new byte[]{-1, -1, -1, -1};
            System.arraycopy(allAsp, 0, filterInformation_, offset, 4);
        } else if (this.filterDataType_.equals(ALL_IASP_SELECTED)) {
            allAsp = new byte[]{-1, -1, -1, -3};
            System.arraycopy(allAsp, 0, filterInformation_, offset, 4);
        } else if (this.filterDataType_.equals(ALL_USER_ASP_SELECTED)) {
            allAsp = new byte[]{-1, -1, -1, -2};
            System.arraycopy(allAsp, 0, filterInformation_, offset, 4);
        } else if (this.filterDataType_.equals(UNASSIGNED_DISK)) {
            allAsp = new byte[]{0, 0, 0, 0};
            System.arraycopy(allAsp, 0, filterInformation_, offset, 4);
        } else if (this.filterDataType_.equals(ASP_NUMBER)) {
            BinaryConverter.intToByteArray(this.aspNumber_, filterInformation_, offset);
        } else if (this.filterDataType_.equals(DATABASE_NAME)) {
            conv.stringToByteArray(this.aspName_, filterInformation_, offset, 18);
        } else if (this.filterDataType_.equals(DEVICEDESCRIPTION_NAME) || this.filterDataType_.equals(RESOURCE_NAME)) {
            conv.stringToByteArray(this.aspName_, filterInformation_, offset, 10);
        } else {
            Trace.log(2, "Error occur when set filter information");
        }
        this.formatBytes_ = new byte[]{-24, -63, -30, -41, -16, (byte)(0xF0 | this.format_), -16, -16};
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(this.filterNumberbyte_), new ProgramParameter(filterInformation_), new ProgramParameter(this.formatBytes_), EMPTY_ERROR_CODE_PARM};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QYASPOL.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        return parameters[2].getOutputData();
    }

    public void setASPNumber(int aspNumber) {
        if (aspNumber <= 0) {
            Trace.log(2, "Value of parameter 'aspNumber' is not valid: " + aspNumber);
            throw new ExtendedIllegalArgumentException("aspNumber (" + aspNumber + ")", 2);
        }
        this.aspNumber_ = aspNumber;
        this.filterKey_ = 1;
        this.filterDataType_ = ASP_NUMBER;
    }

    public void setFormat(String format) {
        if (format == null) {
            Trace.log(2, "Parameter 'format ' is null.");
            throw new NullPointerException("format");
        }
        if (format.equalsIgnoreCase(FORMAT_0100)) {
            this.format_ = 1;
        } else if (format.equalsIgnoreCase(FORMAT_0200)) {
            this.format_ = 2;
        } else if (format.equalsIgnoreCase(FORMAT_0300)) {
            this.format_ = 3;
        } else if (format.equalsIgnoreCase(FORMAT_0400)) {
            this.format_ = 4;
        } else if (format.equalsIgnoreCase(FORMAT_0500)) {
            this.format_ = 5;
        } else if (format.equalsIgnoreCase(FORMAT_0600)) {
            this.format_ = 6;
        } else if (format.equalsIgnoreCase(UNASSIGNED_DISK)) {
            this.format_ = 3;
            this.filterDataType_ = UNASSIGNED_DISK;
        } else {
            Trace.log(2, "Value of parameter 'format' is not valid: " + format);
            throw new ExtendedIllegalArgumentException("format (" + format + ")", 2);
        }
    }

    public void setFilterKey(String filterDataType) {
        if (filterDataType == null) {
            Trace.log(2, "Parameter 'filterDataType ' is null.");
            throw new NullPointerException("filterDataType");
        }
        this.filterDataType_ = filterDataType.toUpperCase().trim();
        if (this.filterDataType_.equals(ALL_ASP_SELECTED) || this.filterDataType_.equals(ALL_IASP_SELECTED) || this.filterDataType_.equals(ALL_USER_ASP_SELECTED) || this.filterDataType_.equals(UNASSIGNED_DISK) || this.filterDataType_.equals(ASP_NUMBER)) {
            this.filterKey_ = 1;
        } else if (this.filterDataType_.equals(RESOURCE_NAME)) {
            this.filterKey_ = 2;
        } else if (this.filterDataType_.equals(DEVICEDESCRIPTION_NAME)) {
            this.filterKey_ = 3;
        } else if (this.filterDataType_.equals(DATABASE_NAME)) {
            this.filterKey_ = 4;
        } else {
            Trace.log(2, "Parameter 'filterDataType ' is not valid:" + filterDataType + ", When filter set to YES");
            throw new ExtendedIllegalArgumentException("filterDataType (" + filterDataType + ")", 2);
        }
    }

    public void setASPName(String name) {
        if (name == null) {
            Trace.log(2, "Parameter 'ASP name for filter ' is null.");
            throw new NullPointerException("name");
        }
        this.aspName_ = name;
        if (name.length() < 10) {
            for (int i = 0; i < 10 - name.length(); ++i) {
                this.aspName_ = this.aspName_ + " ";
            }
        }
        Trace.log(3, "set ASP Name length is " + this.aspName_);
    }

    public String getASPFormat() {
        switch (this.format_) {
            case 1: {
                return FORMAT_0100;
            }
            case 2: {
                return FORMAT_0200;
            }
            case 3: {
                return FORMAT_0300;
            }
            case 4: {
                return FORMAT_0400;
            }
            case 5: {
                return FORMAT_0500;
            }
            case 6: {
                return FORMAT_0600;
            }
        }
        return FORMAT_0100;
    }

    @Override
    protected Object[] formatOutputData(byte[] data, int recordsReturned, int recordLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CharConverter conv = new CharConverter(this.system_.getCcsid(), this.system_);
        Object[] aspList = new AspListItem[recordsReturned];
        int offset = 0;
        for (int i = 0; i < recordsReturned; ++i) {
            int aspNumber = BinaryConverter.byteArrayToInt(data, offset);
            offset += 4;
            if (this.format_ == 1) {
                String aspResourceName = conv.byteArrayToString(data, offset, 10).trim();
                String aspDevDescriptionName = conv.byteArrayToString(data, offset += 10, 10).trim();
                int aspVersion = BinaryConverter.byteArrayToInt(data, offset += 10);
                int aspUsage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspStatus = BinaryConverter.byteArrayToInt(data, offset += 4);
                String aspDatabaseName = conv.byteArrayToString(data, offset += 4, 18).trim();
                String primaryASPResourceName = conv.byteArrayToString(data, offset += 18, 10).trim();
                offset += 10;
                aspList[i] = new AspListItem(aspNumber, aspResourceName, aspDevDescriptionName, aspVersion, aspUsage, aspStatus, aspDatabaseName, primaryASPResourceName);
                continue;
            }
            if (this.format_ == 2) {
                int diskNumber = BinaryConverter.byteArrayToInt(data, offset);
                int aspCapacity = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspCapacityAvailable = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspCapacityProtected = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspCapacityAvaProtected = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspCapacityUnprotected = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspCapacityAvaUnprotected = BinaryConverter.byteArrayToInt(data, offset += 4);
                int aspSystemStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int OverflowStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int space4ErrorLog = BinaryConverter.byteArrayToInt(data, offset += 4);
                int space4MachineLog = BinaryConverter.byteArrayToInt(data, offset += 4);
                int space4MachineTreac = BinaryConverter.byteArrayToInt(data, offset += 4);
                int space4MainStoragedump = BinaryConverter.byteArrayToInt(data, offset += 4);
                int space4Microcode = BinaryConverter.byteArrayToInt(data, offset += 4);
                int storageThresholdPer = BinaryConverter.byteArrayToInt(data, offset += 4);
                String aspType = conv.byteArrayToString(data, offset += 4, 2).trim();
                String overflowRecovery = conv.byteArrayToString(data, offset += 2, 1).trim();
                String endImmeControl = conv.byteArrayToString(data, ++offset, 1).trim();
                String compressionRecoveryPolicy = conv.byteArrayToString(data, ++offset, 1).trim();
                String compressedDiskUnitInASP = conv.byteArrayToString(data, ++offset, 1).trim();
                String balanceStatus = conv.byteArrayToString(data, ++offset, 1).trim();
                String balanceType = conv.byteArrayToString(data, ++offset, 1).trim();
                String balanceDateTime = conv.byteArrayToString(data, ++offset, 13).trim();
                int balanceDataMoved = BinaryConverter.byteArrayToInt(data, offset += 16);
                int balanceDataRemain = BinaryConverter.byteArrayToInt(data, offset += 4);
                int traceDuration = BinaryConverter.byteArrayToInt(data, offset += 4);
                String traceStatus = conv.byteArrayToString(data, offset += 4, 1).trim();
                String traceDateTime = conv.byteArrayToString(data, ++offset, 13).trim();
                String changesWritten2Disk = conv.byteArrayToString(data, offset += 13, 1).trim();
                int multiConnDiskUnit = BinaryConverter.byteArrayToInt(data, offset += 2);
                int geographicMirrorRole = BinaryConverter.byteArrayToInt(data, offset += 4);
                int geographicMirrorCpStat = BinaryConverter.byteArrayToInt(data, offset += 4);
                int geographicMirrorCpDataStat = BinaryConverter.byteArrayToInt(data, offset += 4);
                int geographicMirrorPerfMode = BinaryConverter.byteArrayToInt(data, offset += 4);
                int geographicMirrorResumePriority = BinaryConverter.byteArrayToInt(data, offset += 4);
                int geographicMirrorSuspendTimeout = BinaryConverter.byteArrayToInt(data, offset += 4);
                int diskUnitpresence = BinaryConverter.byteArrayToInt(data, offset += 4);
                offset += 4;
                aspList[i] = new AspListItem(aspNumber, diskNumber, aspCapacity, aspCapacityAvailable, aspCapacityProtected, aspCapacityAvaProtected, aspCapacityUnprotected, aspCapacityAvaUnprotected, aspSystemStorage, OverflowStorage, space4ErrorLog, space4MachineLog, space4MachineTreac, space4MainStoragedump, space4Microcode, storageThresholdPer, aspType, overflowRecovery, endImmeControl, compressionRecoveryPolicy, compressedDiskUnitInASP, balanceStatus, balanceType, balanceDateTime, balanceDataMoved, balanceDataRemain, traceDuration, traceStatus, traceDateTime, changesWritten2Disk, multiConnDiskUnit, geographicMirrorRole, geographicMirrorCpStat, geographicMirrorCpDataStat, geographicMirrorPerfMode, geographicMirrorResumePriority, geographicMirrorSuspendTimeout, diskUnitpresence);
                continue;
            }
            if (this.format_ == 3) {
                String diskType = conv.byteArrayToString(data, offset, 4).trim();
                String diskModel = conv.byteArrayToString(data, offset += 4, 4).trim();
                String diskSerialNumber = conv.byteArrayToString(data, offset += 4, 10).trim();
                String diskResourceName = conv.byteArrayToString(data, offset += 10, 10).trim();
                int diskUnitNumber = BinaryConverter.byteArrayToInt(data, offset += 10);
                int diskCapacity = BinaryConverter.byteArrayToInt(data, offset += 4);
                int diskStorageAvailable = BinaryConverter.byteArrayToInt(data, offset += 4);
                int diskStorageReserved = BinaryConverter.byteArrayToInt(data, offset += 4);
                String mirroredUnitProtected = conv.byteArrayToString(data, offset += 4, 1).trim();
                String mirroredUnitReported = conv.byteArrayToString(data, ++offset, 1).trim();
                String mirroredUnitStatus = conv.byteArrayToString(data, ++offset, 1).trim();
                String RAIDType = conv.byteArrayToString(data, ++offset, 1).trim();
                int unitControl = BinaryConverter.byteArrayToInt(data, ++offset);
                int blockTransfer2MainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int blockTransferFromMainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int reqDataTransfer2MainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int reqDataTransferFromMainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int permanentBlockTransferFromMainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int reqPermanentBlockTransferFromMainStorage = BinaryConverter.byteArrayToInt(data, offset += 4);
                int sampleCount = BinaryConverter.byteArrayToInt(data, offset += 4);
                int notBusyCount = BinaryConverter.byteArrayToInt(data, offset += 4);
                String compressedStatus = conv.byteArrayToString(data, offset += 4, 1).trim();
                String diskProtectionType = conv.byteArrayToString(data, ++offset, 1).trim();
                String compressedUnit = conv.byteArrayToString(data, ++offset, 1).trim();
                String stroageAllocationRestrictUnit = conv.byteArrayToString(data, ++offset, 1).trim();
                String avaParitySetUnit = conv.byteArrayToString(data, ++offset, 1).trim();
                String multiConnectionUnit = conv.byteArrayToString(data, ++offset, 1).trim();
                ++offset;
                offset += 2;
                aspList[i] = new AspListItem(aspNumber, diskType, diskModel, diskSerialNumber, diskResourceName, diskUnitNumber, diskCapacity, diskStorageAvailable, diskStorageReserved, mirroredUnitProtected, mirroredUnitReported, mirroredUnitStatus, RAIDType, unitControl, blockTransfer2MainStorage, blockTransferFromMainStorage, reqDataTransfer2MainStorage, reqDataTransferFromMainStorage, permanentBlockTransferFromMainStorage, reqPermanentBlockTransferFromMainStorage, sampleCount, notBusyCount, compressedStatus, diskProtectionType, compressedUnit, stroageAllocationRestrictUnit, avaParitySetUnit, multiConnectionUnit);
                continue;
            }
            if (this.format_ == 4) {
                String errorCode = conv.byteArrayToString(data, offset, 4).trim();
                int diskUnitNumber = BinaryConverter.byteArrayToInt(data, offset += 4);
                String mirrorUnitIdentifier = conv.byteArrayToString(data, offset += 4, 1).trim();
                ++offset;
                aspList[i] = new AspListItem(aspNumber, errorCode, diskUnitNumber, mirrorUnitIdentifier);
                continue;
            }
            if (this.format_ == 5) {
                String tranfitionTarget = conv.byteArrayToString(data, offset, 2).trim();
                String function = conv.byteArrayToString(data, offset += 4, 16).trim();
                int currentCount = BinaryConverter.byteArrayToInt(data, offset += 16);
                int totalCount = BinaryConverter.byteArrayToInt(data, offset += 4);
                int currentItemCount = BinaryConverter.byteArrayToInt(data, offset += 4);
                int totalItemCount = BinaryConverter.byteArrayToInt(data, offset += 4);
                String elapsedTime = conv.byteArrayToString(data, offset += 4, 6);
                offset += 6;
                aspList[i] = new AspListItem(aspNumber, tranfitionTarget, function, currentCount, totalCount, currentItemCount, totalItemCount, elapsedTime);
                continue;
            }
            if (this.format_ != 6) continue;
            int useIdentification = BinaryConverter.byteArrayToInt(data, offset);
            String jobName = conv.byteArrayToString(data, offset += 4, 10).trim();
            String jobUserName = conv.byteArrayToString(data, offset += 10, 10).trim();
            String jobNumber = conv.byteArrayToString(data, offset += 10, 4).trim();
            String threadIdentifier = conv.byteArrayToString(data, offset += 4, 8).trim();
            String threadStatus = conv.byteArrayToString(data, offset += 8, 4).trim();
            offset += 4;
            aspList[i] = new AspListItem(aspNumber, useIdentification, jobName, jobUserName, jobNumber, threadIdentifier, threadStatus);
        }
        return aspList;
    }

    @Override
    protected int getBestGuessReceiverSize(int number) {
        switch (this.format_) {
            case 1: {
                return 64 * number;
            }
            case 2: {
                return 148 * number;
            }
            case 3: {
                return 94 * number;
            }
            case 4: {
                return 13 * number;
            }
            case 5: {
                return 46 * number;
            }
            case 6: {
                return 52 * number;
            }
        }
        return 148 * number;
    }

    public int getAspNumber() {
        return this.aspNumber_;
    }

    public String getAspName() {
        if (this.aspName_ == null) {
            this.aspName_ = "";
        }
        return this.aspName_;
    }

    public int getFilterKey() {
        return this.filterKey_;
    }

    public String getFilterDataType() {
        if (this.filterDataType_ == null) {
            this.filterDataType_ = "";
        }
        return this.filterDataType_;
    }
}

