/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.DriverManager;

final class JDTrace {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    private JDTrace() {
    }

    static boolean isTraceOn() {
        if (Trace.traceOn_ && Trace.traceJDBC_) {
            return true;
        }
        return DriverManager.getLogWriter() != null;
    }

    static void logDataEvenIfTracingIsOff(Object object, String information) {
        JDTrace.logInformation(object, information);
    }

    static void logInformation(String information) {
        if (JDTrace.isTraceOn()) {
            String data = "as400: " + information;
            JDTrace.log(data);
        }
    }

    static void logException(Object object, String information, Exception e) {
        if (JDTrace.isTraceOn()) {
            StringWriter sw = new StringWriter();
            PrintWriter buffer = new PrintWriter(sw);
            buffer.write("as400: ");
            if (object != null) {
                buffer.write(JDTrace.objectToString(object));
            } else {
                buffer.write("static method");
            }
            buffer.write(": ");
            buffer.write(information);
            buffer.write(".");
            e.printStackTrace(buffer);
            JDTrace.log(sw.toString());
        }
    }

    static void logException(Object object, Object object2, String information, Exception e) {
        if (JDTrace.isTraceOn()) {
            StringWriter sw = new StringWriter();
            PrintWriter buffer = new PrintWriter(sw);
            buffer.write("as400: ");
            if (object != null) {
                buffer.write(JDTrace.objectToString(object));
            } else {
                buffer.write("static method ");
            }
            if (object2 != null) {
                buffer.write(JDTrace.objectToString(object2));
            }
            buffer.write(": ");
            buffer.write(information);
            buffer.write(".");
            e.printStackTrace(buffer);
            JDTrace.log(sw.toString());
        }
    }

    static void logInformation(Object object, String information) {
        if (JDTrace.isTraceOn()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("as400: ");
            buffer.append(JDTrace.objectToString(object));
            buffer.append(": ");
            buffer.append(information);
            buffer.append(".");
            JDTrace.log(buffer.toString());
        }
    }

    static void logProperty(Object object, String callingMethod, String propertyName, String propertyValue) {
        if (JDTrace.isTraceOn()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("as400@");
            buffer.append(callingMethod);
            buffer.append(": ");
            buffer.append(JDTrace.objectToString(object));
            buffer.append(": ");
            buffer.append(propertyName);
            buffer.append(" = \"");
            buffer.append(propertyValue);
            buffer.append("\".");
            JDTrace.log(buffer.toString());
        }
    }

    static void logProperty(Object object, String callingMethod, String propertyName, boolean propertyValue) {
        if (JDTrace.isTraceOn()) {
            Boolean b = propertyValue;
            JDTrace.logProperty(object, callingMethod, propertyName, b.toString());
        }
    }

    static void logProperty(Object object, String callingMethod, String propertyName, int propertyValue) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty(object, callingMethod, propertyName, Integer.toString(propertyValue));
        }
    }

    static void logOpen(Object object, Object parent) {
        if (JDTrace.isTraceOn()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("as400: ");
            buffer.append(JDTrace.objectToString(object));
            buffer.append(" open.");
            if (parent != null) {
                buffer.append(" Parent: ");
                buffer.append(JDTrace.objectToString(parent));
                buffer.append(".");
            }
            JDTrace.log(buffer.toString());
        }
    }

    private static void log(String data) {
        PrintWriter ps;
        PrintWriter pw = DriverManager.getLogWriter();
        if (pw != null) {
            pw.println(data);
        }
        if ((ps = DriverManager.getLogWriter()) != null) {
            try {
                ((Writer)ps).write(data + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Trace.log(8, data);
    }

    static void logClose(Object object) {
        if (JDTrace.isTraceOn()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("as400: ");
            buffer.append(JDTrace.objectToString(object));
            buffer.append(" closed.");
            JDTrace.log(buffer.toString());
        }
    }

    static String objectToString(Object object) {
        AS400JDBCConnection connection;
        String clazz;
        if (object == null) {
            object = "";
        }
        String className = (clazz = object.getClass().getName()).startsWith("com.ibm.as400.access.AS400JDBC") ? clazz.substring(30) : (clazz.startsWith("com.ibm.as400.access.JD") ? clazz.substring(23) : (clazz.startsWith("java.lang.Class") ? "" : "Unknown"));
        StringBuffer buffer = new StringBuffer();
        buffer.append(className);
        buffer.append(" ");
        buffer.append(object.toString());
        if (object instanceof AS400JDBCConnectionImpl) {
            connection = (AS400JDBCConnectionImpl)object;
            if (connection.dataSourceUrl_ != null) {
                buffer.append(":");
                buffer.append(connection.dataSourceUrl_.getServerName());
            }
        }
        if (object instanceof AS400JDBCConnectionRedirect) {
            connection = (AS400JDBCConnectionRedirect)object;
            if (((AS400JDBCConnectionRedirect)connection).currentUrl_ != null) {
                buffer.append(":");
                buffer.append(((AS400JDBCConnectionRedirect)connection).currentUrl_.getServerName());
            }
        }
        buffer.append(" (");
        buffer.append(object.hashCode());
        buffer.append(") ");
        return buffer.toString();
    }

    static void setTraceOn(boolean traceOn) {
        Trace.setTraceJDBCOn(traceOn);
        if (traceOn) {
            Trace.setTraceOn(traceOn);
        }
    }
}

