/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MaterializedViewName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_MATERIALIZED_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/materializedViews/{materialized_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String materializedView;

    @Deprecated
    protected MaterializedViewName() {
        this.project = null;
        this.instance = null;
        this.materializedView = null;
    }

    private MaterializedViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.materializedView = (String)Preconditions.checkNotNull((Object)builder.getMaterializedView());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getMaterializedView() {
        return this.materializedView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MaterializedViewName of(String project, String instance, String materializedView) {
        return MaterializedViewName.newBuilder().setProject(project).setInstance(instance).setMaterializedView(materializedView).build();
    }

    public static String format(String project, String instance, String materializedView) {
        return MaterializedViewName.newBuilder().setProject(project).setInstance(instance).setMaterializedView(materializedView).build().toString();
    }

    public static MaterializedViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_MATERIALIZED_VIEW.validatedMatch(formattedString, "MaterializedViewName.parse: formattedString not in valid format");
        return MaterializedViewName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("materialized_view"));
    }

    public static List<MaterializedViewName> parseList(List<String> formattedStrings) {
        ArrayList<MaterializedViewName> list = new ArrayList<MaterializedViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MaterializedViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MaterializedViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MaterializedViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_MATERIALIZED_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MaterializedViewName materializedViewName = this;
            synchronized (materializedViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.materializedView != null) {
                        fieldMapBuilder.put((Object)"materialized_view", (Object)this.materializedView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_MATERIALIZED_VIEW.instantiate(new String[]{"project", this.project, "instance", this.instance, "materialized_view", this.materializedView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MaterializedViewName that = (MaterializedViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.materializedView, that.materializedView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.materializedView);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String materializedView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getMaterializedView() {
            return this.materializedView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setMaterializedView(String materializedView) {
            this.materializedView = materializedView;
            return this;
        }

        private Builder(MaterializedViewName materializedViewName) {
            this.project = materializedViewName.project;
            this.instance = materializedViewName.instance;
            this.materializedView = materializedViewName.materializedView;
        }

        public MaterializedViewName build() {
            return new MaterializedViewName(this);
        }
    }
}

