/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.optimizeTable;

import java.text.MessageFormat;
import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.databricks.change.optimizeTable.OptimizeTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="optimizeTable", description="Optimize and ZOrder Table", priority=5)
public class OptimizeTableChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String zorderColumns;

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully optimized.", this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    protected Change[] createInverses() {
        return new Change[0];
    }

    public SqlStatement[] generateStatements(Database database) {
        OptimizeTableStatement statement = new OptimizeTableStatement();
        statement.setCatalogName(this.getCatalogName());
        statement.setSchemaName(this.getSchemaName());
        statement.setTableName(this.getTableName());
        if (this.getZorderColumns() == null) {
            ArrayList<String> noZorderCol = new ArrayList<String>();
            statement.setZorderColumns(noZorderCol);
        } else {
            statement.setZorderColumns(this.getZorderColumns());
        }
        return new SqlStatement[]{statement};
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setZorderColumns(String zorderColumns) {
        this.zorderColumns = zorderColumns;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getZorderColumns() {
        return this.zorderColumns;
    }
}

