/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.addLookupTable;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddLookupTableChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.core.Column;

@DatabaseChange(name="addLookupTable", priority=5, appliesTo={"column"}, description="Creates a lookup table containing values stored in a column and creates a foreign key to the new table.")
public class AddLookupTableChangeDatabricks
extends AddLookupTableChange {
    public String getFinalConstraintName() {
        if (this.getConstraintName() == null) {
            return ("fk_" + this.getExistingTableName() + "_" + this.getNewTableName()).toLowerCase();
        }
        return this.getConstraintName();
    }

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    public SqlStatement[] generateStatements(Database database) {
        String newTableCatalogName = this.getNewTableCatalogName();
        String newTableSchemaName = this.getNewTableSchemaName();
        String existingTableCatalogName = this.getExistingTableCatalogName();
        String existingTableSchemaName = this.getExistingTableSchemaName();
        SqlStatement[] createTablesSQL = new SqlStatement[]{new RawParameterizedSqlStatement("CREATE TABLE " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " USING delta TBLPROPERTIES('delta.feature.allowColumnDefaults' = 'supported', 'delta.columnMapping.mode' = 'name')  AS SELECT DISTINCT " + database.escapeObjectName(this.getExistingColumnName(), Column.class) + " AS " + database.escapeObjectName(this.getNewColumnName(), Column.class) + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + database.escapeObjectName(this.getExistingColumnName(), Column.class) + " IS NOT NULL")};
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>(Arrays.asList(createTablesSQL));
        AddNotNullConstraintChange addNotNullChange = new AddNotNullConstraintChange();
        addNotNullChange.setSchemaName(newTableSchemaName);
        addNotNullChange.setTableName(this.getNewTableName());
        addNotNullChange.setColumnName(this.getNewColumnName());
        addNotNullChange.setColumnDataType(this.getNewColumnDataType());
        statements.addAll(Arrays.asList(addNotNullChange.generateStatements(database)));
        AddPrimaryKeyChange addPKChange = new AddPrimaryKeyChange();
        addPKChange.setSchemaName(newTableSchemaName);
        addPKChange.setTableName(this.getNewTableName());
        addPKChange.setColumnNames(this.getNewColumnName());
        statements.addAll(Arrays.asList(addPKChange.generateStatements(database)));
        AddForeignKeyConstraintChange addFKChange = new AddForeignKeyConstraintChange();
        addFKChange.setBaseTableSchemaName(existingTableSchemaName);
        addFKChange.setBaseTableName(this.getExistingTableName());
        addFKChange.setBaseColumnNames(this.getExistingColumnName());
        addFKChange.setReferencedTableSchemaName(newTableSchemaName);
        addFKChange.setReferencedTableName(this.getNewTableName());
        addFKChange.setReferencedColumnNames(this.getNewColumnName());
        addFKChange.setConstraintName(this.getFinalConstraintName());
        statements.addAll(Arrays.asList(addFKChange.generateStatements(database)));
        return statements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }
}

