/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netezza.Driver;
import org.netezza.datasource.NzDatasource;
import org.netezza.logging.LogLevel;
import org.netezza.logging.LoggerType;
import org.netezza.ui.UIConstants;
import org.netezza.ui.gui.Dialogs;
import org.netezza.util.NzSecurityLevel;

public class DsnDialog
extends JDialog
implements UIConstants,
ActionListener,
FocusListener {
    private boolean isNew = false;
    private NzDatasource datasource;
    private static NzDatasource defaultDatasource = new NzDatasource();
    private JTabbedPane mainPage;
    private JPanel connectionOptionsPanel;
    private JPanel advancedOptionsPanel;
    private JPanel securityPanel;
    private JPanel clientInfoPanel;
    private JPanel buttonPanel;
    private static final int WIDTH = 85;
    private static final int HEIGHT = 20;
    private static final int VERTICAL_GAP = 10;
    private static final int HORIZENTAL_GAP = 21;
    private JLabel dsnName;
    private JTextField dsnNameValue;
    private JLabel description;
    private JTextField descriptionValue;
    private JLabel host;
    private JTextField hostValue;
    private JLabel port;
    private JTextField portValue;
    private JLabel database;
    private JTextField databaseValue;
    private JLabel user;
    private JTextField userValue;
    private JLabel password;
    private JPasswordField passwordValue;
    private JLabel schema;
    private JTextField schemaValue;
    private JButton testConnection;
    private JLabel batchSize;
    private JTextField batchSizeValue;
    private JLabel loginModule;
    private JTextField loginModuleValue;
    private JLabel loginTimeout;
    private JTextField loginTimeoutValue;
    private JLabel applicationName;
    private JTextField applicationNameValue;
    private JLabel clientUser;
    private JTextField clientUserValue;
    private JLabel clientHostName;
    private JTextField clientHostNameValue;
    private JCheckBox readOnly;
    private JCheckBox autoCommit;
    private JCheckBox krbSSODelegation;
    private JLabel logLevel;
    private JComboBox logLevelValues;
    private JLabel loggerType;
    private JComboBox loggerTypeValues;
    private JLabel logPath;
    private JTextField logPathValue;
    private JCheckBox dbMetadata;
    private JCheckBox ignoreUpdtCount;
    private JButton defaults;
    private JLabel securityLevel;
    private JRadioButton preferredUnsecured;
    private JRadioButton onlyUnsecured;
    private JRadioButton preferredSecured;
    private JRadioButton onlySecured;
    private ButtonGroup group;
    private JLabel caCertFile;
    private JTextField caCertFileValue;
    private JButton browse;
    private JFileChooser chooser;
    private JButton ok;
    private JButton cancel;
    private JButton help;

    public DsnDialog() {
        this.setBounds(0, 0, 466, 280);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setResizable(false);
        this.createConnectionOptionsPanel();
        this.createAdvancedOptionsPanel();
        this.createSecurityPanel();
        this.createClientInfoPanel();
        this.createButtonPanel();
        this.getContentPane().setLayout(null);
        this.mainPage = new JTabbedPane();
        this.mainPage.addTab(this.connectionOptionsPanel.getName(), this.connectionOptionsPanel);
        this.mainPage.addTab(this.advancedOptionsPanel.getName(), this.advancedOptionsPanel);
        this.mainPage.addTab(this.securityPanel.getName(), this.securityPanel);
        this.mainPage.addTab(this.clientInfoPanel.getName(), this.clientInfoPanel);
        int x = 21;
        int y = 0;
        int width = 445;
        block4: for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    this.mainPage.setBounds(5, 0, width, 190);
                    y = y + this.mainPage.getHeight() + 10;
                    continue block4;
                }
                case 1: {
                    this.buttonPanel.setBounds(x, y, width, 30);
                }
            }
        }
        this.getContentPane().add(this.mainPage);
        this.getContentPane().add(this.buttonPanel);
        this.addListeners();
    }

    @Override
    public Component add(Component comp) {
        return this.getContentPane().add(comp);
    }

    private void addListeners() {
        this.mainPage.addFocusListener(this);
        this.connectionOptionsPanel.addFocusListener(this);
        this.advancedOptionsPanel.addFocusListener(this);
        this.securityPanel.addFocusListener(this);
        this.clientInfoPanel.addFocusListener(this);
        this.buttonPanel.addFocusListener(this);
        this.dsnNameValue.addFocusListener(this);
        this.descriptionValue.addFocusListener(this);
        this.hostValue.addFocusListener(this);
        this.portValue.addFocusListener(this);
        this.databaseValue.addFocusListener(this);
        this.userValue.addFocusListener(this);
        this.passwordValue.addFocusListener(this);
        this.schemaValue.addFocusListener(this);
        this.batchSizeValue.addFocusListener(this);
        this.loginTimeoutValue.addFocusListener(this);
        this.logPathValue.addFocusListener(this);
        this.caCertFileValue.addFocusListener(this);
        this.dbMetadata.addFocusListener(this);
        this.ignoreUpdtCount.addFocusListener(this);
        this.loginModuleValue.addFocusListener(this);
        this.applicationNameValue.addFocusListener(this);
        this.clientHostNameValue.addFocusListener(this);
        this.clientUserValue.addFocusListener(this);
        this.testConnection.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.help.addActionListener(this);
        this.logLevelValues.addActionListener(this);
        this.defaults.addActionListener(this);
        this.browse.addActionListener(this);
        this.dbMetadata.addActionListener(this);
        this.ignoreUpdtCount.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Dialogs.showConfirmDialog("Are you sure you want to close ?", DsnDialog.this)) {
                    DsnDialog.this.datasource = null;
                    DsnDialog.this.setDefaultCloseOperation(1);
                } else {
                    DsnDialog.this.setDefaultCloseOperation(0);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.setVisible(null, aFlag);
    }

    public void setVisible(NzDatasource datasource, boolean flag) {
        if (flag) {
            this.mainPage.setSelectedComponent(this.connectionOptionsPanel);
            this.mainPage.grabFocus();
            this.isNew = datasource == null;
            this.datasource = this.isNew ? new NzDatasource() : datasource;
            this.updateComponents();
        }
        super.setVisible(flag);
    }

    private void updateComponents() {
        this.dsnNameValue.setText(this.datasource.getName());
        this.descriptionValue.setText(this.datasource.getDescription());
        this.hostValue.setText(this.datasource.getHost());
        this.portValue.setText("" + this.datasource.getPort());
        this.databaseValue.setText(this.datasource.getDatabase());
        this.userValue.setText(this.datasource.getUser());
        this.passwordValue.setText(this.datasource.getPassword());
        this.schemaValue.setText(this.datasource.getCurrentSchema());
        this.batchSizeValue.setText("" + this.datasource.getBatchSize());
        this.loginTimeoutValue.setText("" + this.datasource.getLoginTimeout());
        this.readOnly.setSelected(this.datasource.isReadOnly());
        this.autoCommit.setSelected(this.datasource.isAutoCommit());
        this.logLevelValues.setSelectedItem((Object)LogLevel.valueOf(this.datasource.getLogLevel()));
        this.loggerTypeValues.setSelectedItem((Object)LoggerType.getLoggerType(this.datasource.getLoggerType()));
        this.logPathValue.setText(this.datasource.getLogDirPath());
        this.dbMetadata.setSelected(this.datasource.getSpecCompliantDBMeta());
        this.ignoreUpdtCount.setSelected(this.datasource.getIgnoreUpdtCount());
        NzSecurityLevel level = NzSecurityLevel.getSecurityLevel(this.datasource.getSecurityLevel());
        if (level == NzSecurityLevel.preferredUnsecured) {
            this.preferredUnsecured.setSelected(true);
        } else if (level == NzSecurityLevel.onlyUnsecured) {
            this.onlyUnsecured.setSelected(true);
        } else if (level == NzSecurityLevel.preferredSecured) {
            this.preferredSecured.setSelected(true);
        } else if (level == NzSecurityLevel.onlySecured) {
            this.onlySecured.setSelected(true);
        }
        this.caCertFileValue.setText(this.datasource.getCaCertificate());
        this.loginModuleValue.setText(this.datasource.getKrbLoginModuleName());
        this.krbSSODelegation.setSelected(this.datasource.isClientKrbSSODelegated());
        this.applicationNameValue.setText(this.datasource.getClientApplicationName());
        this.clientUserValue.setText(this.datasource.getClientUser());
        this.clientHostNameValue.setText(this.datasource.getClientHostName());
    }

    private boolean updateDatasource() {
        String _name = null;
        String _description = null;
        String _logDirPath = null;
        String _schema = null;
        String _user = null;
        String _password = null;
        String _database = null;
        String _host = null;
        String level = null;
        LoggerType type = null;
        NzSecurityLevel securityLevel = null;
        int _batchSize = 256;
        int _loginTimeout = 0;
        int _port = 5480;
        boolean _readOnly = false;
        boolean _autoCommit = false;
        boolean _dbMetadata = false;
        boolean _ignoreUpdtCount = false;
        boolean _krbSSODelegation = false;
        String _loginModule = null;
        String _applicationName = null;
        String _clientUser = null;
        String _clientHostName = null;
        ArrayList<String> errors = new ArrayList<String>();
        _name = this.dsnNameValue.getText().trim();
        if (_name.length() == 0) {
            errors.add("Invalid Datasource name");
        }
        if (!_name.equalsIgnoreCase(this.datasource.getName()) && Driver.isPresent(_name)) {
            errors.add("Datasource already exists");
        }
        _description = this.descriptionValue.getText().trim();
        try {
            if (this.batchSizeValue.getText().trim().length() > 0 && (_batchSize = Integer.parseInt(this.batchSizeValue.getText())) < 0) {
                errors.add("Invalid value for Batch Size.");
            }
        }
        catch (NumberFormatException e) {
            errors.add("Invalid value for Batch Size.");
        }
        try {
            if (this.loginTimeoutValue.getText().trim().length() > 0 && (_loginTimeout = Integer.parseInt(this.loginTimeoutValue.getText())) < 0) {
                errors.add("Invalid value for Login Timeout.");
            }
        }
        catch (NumberFormatException e) {
            errors.add("Invalid value for Login Timeout.");
        }
        level = ((LogLevel)((Object)this.logLevelValues.getSelectedItem())).toString();
        _logDirPath = this.logPathValue.getText().trim();
        type = (LoggerType)((Object)this.loggerTypeValues.getSelectedItem());
        _user = this.userValue.getText();
        _password = new String(this.passwordValue.getPassword());
        _database = this.databaseValue.getText().trim();
        if (_database.length() == 0) {
            errors.add("Database name not specified.");
        }
        if ((_host = this.hostValue.getText().trim()).length() == 0) {
            errors.add("Host name not specified");
        }
        _schema = this.schemaValue.getText().trim();
        try {
            if (this.portValue.getText().trim().length() > 0) {
                _port = Integer.parseInt(this.portValue.getText());
                if (_port < 0) {
                    errors.add("Invalid value for Port.");
                }
            } else {
                errors.add("Invalid value for Port.");
            }
        }
        catch (NumberFormatException ex) {
            errors.add("Invalid value for Port.");
        }
        _readOnly = this.readOnly.isSelected();
        _autoCommit = this.autoCommit.isSelected();
        _krbSSODelegation = this.krbSSODelegation.isSelected();
        _dbMetadata = this.dbMetadata.isSelected();
        _ignoreUpdtCount = this.ignoreUpdtCount.isSelected();
        String action = this.group.getSelection().getActionCommand();
        securityLevel = NzSecurityLevel.valueOf(action);
        String caCertFile = this.caCertFileValue.getText();
        _loginModule = this.loginModuleValue.getText().trim();
        _applicationName = this.applicationNameValue.getText().trim();
        _clientUser = this.clientUserValue.getText().trim();
        _clientHostName = this.clientHostNameValue.getText().trim();
        if (errors != null && !errors.isEmpty()) {
            StringBuffer message = new StringBuffer("Errors : \n");
            int size = errors.size();
            for (int i = 0; i < size; ++i) {
                String error = (String)errors.get(i) + "\n";
                message.append(error);
            }
            Dialogs.showErrorDialog(message.toString(), this);
            errors.clear();
            return false;
        }
        this.datasource.setName(_name);
        this.datasource.setAutoCommit(_autoCommit);
        this.datasource.setBatchSize(_batchSize);
        this.datasource.setDatabase(_database);
        this.datasource.setDescription(_description);
        this.datasource.setHost(_host);
        this.datasource.setLogDirPath(_logDirPath);
        this.datasource.setLoggerType(type.toString());
        this.datasource.setLoginTimeout(_loginTimeout);
        this.datasource.setLogLevel(level);
        this.datasource.setPassword(_password);
        this.datasource.setPort(_port);
        this.datasource.setCurrentSchema(_schema);
        this.datasource.setReadOnly(_readOnly);
        this.datasource.setUser(_user);
        this.datasource.setSecurityLevel(securityLevel.toString());
        this.datasource.setCaCertificate(caCertFile);
        this.datasource.setSpecCompliantDBMeta(_dbMetadata);
        this.datasource.setIgnoreUpdtCount(_ignoreUpdtCount);
        this.datasource.setKrbLoginModuleName(_loginModule);
        this.datasource.setClientKrbSSODelegation(_krbSSODelegation);
        this.datasource.setClientApplicationName(_applicationName);
        this.datasource.setClientUser(_clientUser);
        this.datasource.setClientHostName(_clientHostName);
        return true;
    }

    private boolean save() {
        if (this.isNew && !this.addDatasource(this.datasource)) {
            return false;
        }
        try {
            Driver.save();
            this.isNew = false;
            return true;
        }
        catch (SQLException e) {
            Dialogs.showErrorDialog(e.getMessage(), this);
            return false;
        }
    }

    private boolean addDatasource(NzDatasource dsn) {
        try {
            Driver.addDatasource(dsn);
            return true;
        }
        catch (SQLException e) {
            Dialogs.showErrorDialog(e.getMessage(), this);
            return false;
        }
    }

    private void createConnectionOptionsPanel() {
        this.connectionOptionsPanel = new JPanel(null);
        this.connectionOptionsPanel.setName("Connection Options");
        this.connectionOptionsPanel.setFocusCycleRoot(true);
        this.connectionOptionsPanel.setFocusTraversalPolicy(new ConnectionOptionsFocusTraversalPolicy());
        this.dsnName = this.createLabel("Data Source", "Name of the data source (Mandatory).", 4);
        this.dsnNameValue = this.createTextField();
        this.description = this.createLabel("Description", "Description for the data source.", 4);
        this.descriptionValue = this.createTextField();
        this.host = this.createLabel("Host", "Name of the host to connect to (Mandatory).", 4);
        this.hostValue = this.createTextField();
        this.port = this.createLabel("Port", "Port number (Mandatory).", 4);
        this.portValue = this.createTextField();
        this.database = this.createLabel("Database", "Database (Catalog) name (Mandatory).", 4);
        this.databaseValue = this.createTextField();
        this.schema = this.createLabel("Schema", "Schema that user wants to connect to.", 4);
        this.schemaValue = this.createTextField();
        this.user = this.createLabel("User", "Username to connect to the database.", 4);
        this.userValue = this.createTextField();
        this.password = this.createLabel("Password", "Password for authentication.", 4);
        this.passwordValue = new JPasswordField();
        this.passwordValue.setMargin(new Insets(0, 3, 0, 3));
        this.testConnection = this.createButton("Test Connection", 84, "Tests the connection with the given parameters.");
        int x = 21;
        int y = 10;
        boolean nextColumn = false;
        for (int i = 0; i < 19; ++i) {
            Component component = null;
            switch (i) {
                case 0: {
                    this.dsnName.setBounds(x, y, 75, 20);
                    component = this.dsnName;
                    nextColumn = true;
                    break;
                }
                case 1: {
                    this.dsnNameValue.setBounds(x, y, 100, 20);
                    component = this.dsnNameValue;
                    nextColumn = true;
                    break;
                }
                case 2: {
                    this.description.setBounds(x, y, 75, 20);
                    component = this.description;
                    nextColumn = true;
                    break;
                }
                case 3: {
                    this.descriptionValue.setBounds(x, y, 100, 20);
                    component = this.descriptionValue;
                    nextColumn = false;
                    break;
                }
                case 4: {
                    this.host.setBounds(x, y, 75, 20);
                    component = this.host;
                    nextColumn = true;
                    break;
                }
                case 5: {
                    this.hostValue.setBounds(x, y, 100, 20);
                    component = this.hostValue;
                    nextColumn = true;
                    break;
                }
                case 6: {
                    this.user.setBounds(x, y, 75, 20);
                    component = this.user;
                    nextColumn = true;
                    break;
                }
                case 7: {
                    this.userValue.setBounds(x, y, 100, 20);
                    component = this.userValue;
                    nextColumn = false;
                    break;
                }
                case 8: {
                    this.port.setBounds(x, y, 75, 20);
                    component = this.port;
                    nextColumn = true;
                    break;
                }
                case 9: {
                    this.portValue.setBounds(x, y, 100, 20);
                    component = this.portValue;
                    nextColumn = true;
                    break;
                }
                case 10: {
                    this.password.setBounds(x, y, 75, 20);
                    component = this.password;
                    nextColumn = true;
                    break;
                }
                case 11: {
                    this.passwordValue.setBounds(x, y, 100, 20);
                    component = this.passwordValue;
                    nextColumn = false;
                    break;
                }
                case 12: {
                    this.database.setBounds(x, y, 75, 20);
                    component = this.database;
                    nextColumn = true;
                    break;
                }
                case 13: {
                    this.databaseValue.setBounds(x, y, 100, 20);
                    component = this.databaseValue;
                    nextColumn = true;
                    break;
                }
                case 14: {
                    this.schema.setBounds(x, y, 75, 20);
                    component = this.schema;
                    nextColumn = true;
                    break;
                }
                case 15: {
                    this.schemaValue.setBounds(x, y, 100, 20);
                    component = this.schemaValue;
                    nextColumn = false;
                    break;
                }
                case 16: {
                    nextColumn = true;
                    break;
                }
                case 17: {
                    x = x + 85 + 63;
                    this.testConnection.setBounds(x, y, 148, 20);
                    component = this.testConnection;
                    nextColumn = false;
                }
            }
            if (nextColumn) {
                int width = component == null ? 85 : component.getWidth();
                x = x + width + 10;
                continue;
            }
            x = 21;
            y = y + 20 + 10;
        }
        this.connectionOptionsPanel.add(this.dsnName);
        this.connectionOptionsPanel.add(this.dsnNameValue);
        this.connectionOptionsPanel.add(this.description);
        this.connectionOptionsPanel.add(this.descriptionValue);
        this.connectionOptionsPanel.add(this.host);
        this.connectionOptionsPanel.add(this.hostValue);
        this.connectionOptionsPanel.add(this.port);
        this.connectionOptionsPanel.add(this.portValue);
        this.connectionOptionsPanel.add(this.database);
        this.connectionOptionsPanel.add(this.databaseValue);
        this.connectionOptionsPanel.add(this.user);
        this.connectionOptionsPanel.add(this.userValue);
        this.connectionOptionsPanel.add(this.password);
        this.connectionOptionsPanel.add(this.passwordValue);
        this.connectionOptionsPanel.add(this.schema);
        this.connectionOptionsPanel.add(this.schemaValue);
        this.connectionOptionsPanel.add(this.testConnection);
        this.connectionOptionsPanel.setFocusCycleRoot(true);
    }

    private void createAdvancedOptionsPanel() {
        this.advancedOptionsPanel = new JPanel(null);
        this.advancedOptionsPanel.setName("Advanced Options");
        this.advancedOptionsPanel.setFocusCycleRoot(true);
        this.advancedOptionsPanel.setFocusTraversalPolicy(new AdvancedOptionsFocusTraversalPolicy());
        this.batchSize = this.createLabel("Batch size", "Batch size for the connection. (Number of rows to be fetched in a cycle) Default - 256.", 4);
        this.batchSizeValue = this.createTextField();
        this.loginTimeout = this.createLabel("Login timeout", "Maximum wait time to make a connection. Default - infinite.", 4);
        this.loginTimeoutValue = this.createTextField();
        this.readOnly = this.createCheckBox("Read only", "Read Only property for the connection. Default - false.");
        this.autoCommit = this.createCheckBox("Autocommit", "Auto Commit property for the connection. Default - true.");
        this.logLevel = this.createLabel("Log level", "Log Level for the connection. Default - OFF", 4);
        this.logLevelValues = new JComboBox<LogLevel>(LogLevel.values());
        this.loggerType = this.createLabel("Logger type", "Logger Type used for logging. Default - TEXT", 4);
        this.loggerTypeValues = new JComboBox<LoggerType>(LoggerType.values());
        this.logPath = this.createLabel("Logger directory", "Log directory where the log files will be dumped.", 4);
        this.logPathValue = this.createTextField();
        this.defaults = this.createButton("Defaults", 68, "Reset the advanced options to default values.");
        this.dbMetadata = this.createCheckBox("Database metadata", "Database metadata.");
        this.ignoreUpdtCount = this.createCheckBox("Ignore update count", "If set to true, ignore update count instead of throwing an exception if it overflows the max range of integer type.");
        int x = 21;
        int y = 10;
        boolean nextColumn = false;
        for (int i = 0; i < 25; ++i) {
            Component component = null;
            switch (i) {
                case 0: {
                    this.batchSize.setBounds(x, y, 85, 20);
                    component = this.batchSize;
                    nextColumn = true;
                    break;
                }
                case 1: {
                    this.batchSizeValue.setBounds(x, y, 85, 20);
                    component = this.batchSizeValue;
                    nextColumn = true;
                    break;
                }
                case 2: {
                    this.logLevel.setBounds(x += 21, y, 85, 20);
                    component = this.logLevel;
                    nextColumn = true;
                    break;
                }
                case 3: {
                    this.logLevelValues.setBounds(x, y, 85, 20);
                    component = this.logLevelValues;
                    nextColumn = false;
                    break;
                }
                case 4: {
                    this.loginTimeout.setBounds(x, y, 85, 20);
                    component = this.loginTimeout;
                    nextColumn = true;
                    break;
                }
                case 5: {
                    this.loginTimeoutValue.setBounds(x, y, 85, 20);
                    component = this.loginTimeoutValue;
                    nextColumn = true;
                    break;
                }
                case 6: {
                    this.loggerType.setBounds(x += 21, y, 85, 20);
                    component = this.loggerType;
                    nextColumn = true;
                    break;
                }
                case 7: {
                    this.loggerTypeValues.setBounds(x, y, 85, 20);
                    component = this.loggerTypeValues;
                    nextColumn = false;
                    break;
                }
                case 8: {
                    nextColumn = true;
                    break;
                }
                case 9: {
                    this.readOnly.setBounds(x -= 20, y, 105, 20);
                    component = this.readOnly;
                    nextColumn = true;
                    break;
                }
                case 10: {
                    this.logPath.setBounds(x += 21, y, 85, 20);
                    component = this.logPath;
                    nextColumn = true;
                    break;
                }
                case 11: {
                    this.logPathValue.setBounds(x, y, 85, 20);
                    component = this.logPathValue;
                    nextColumn = false;
                    break;
                }
                case 12: {
                    nextColumn = true;
                    break;
                }
                case 13: {
                    this.autoCommit.setBounds(x -= 20, y, 105, 20);
                    component = this.autoCommit;
                    nextColumn = true;
                    break;
                }
                case 14: {
                    this.dbMetadata.setBounds(x += 70, y, 135, 20);
                    component = this.dbMetadata;
                    nextColumn = false;
                    break;
                }
                case 15: {
                    nextColumn = true;
                    break;
                }
                case 16: {
                    this.ignoreUpdtCount.setBounds(x -= 50, y, 135, 20);
                    component = this.ignoreUpdtCount;
                    nextColumn = true;
                    break;
                }
                case 17: {
                    nextColumn = true;
                    break;
                }
                case 18: {
                    this.defaults.setBounds(x, y, 85, 20);
                    component = this.defaults;
                    nextColumn = false;
                    break;
                }
            }
            if (nextColumn) {
                int width = component == null ? 85 : component.getWidth();
                x = x + width + 10;
                continue;
            }
            x = 21;
            y = y + 20 + 10;
        }
        this.advancedOptionsPanel.add(this.batchSize);
        this.advancedOptionsPanel.add(this.batchSizeValue);
        this.advancedOptionsPanel.add(this.loginTimeout);
        this.advancedOptionsPanel.add(this.loginTimeoutValue);
        this.advancedOptionsPanel.add(this.logLevel);
        this.advancedOptionsPanel.add(this.logLevelValues);
        this.advancedOptionsPanel.add(this.loggerType);
        this.advancedOptionsPanel.add(this.loggerTypeValues);
        this.advancedOptionsPanel.add(this.logPath);
        this.advancedOptionsPanel.add(this.logPathValue);
        this.advancedOptionsPanel.add(this.readOnly);
        this.advancedOptionsPanel.add(this.autoCommit);
        this.advancedOptionsPanel.add(this.defaults);
        this.advancedOptionsPanel.add(this.dbMetadata);
        this.advancedOptionsPanel.add(this.ignoreUpdtCount);
    }

    private void createSecurityPanel() {
        this.securityPanel = new JPanel(null);
        this.securityPanel.setName("SSL Options");
        this.securityPanel.setFocusCycleRoot(true);
        this.securityPanel.setFocusTraversalPolicy(new SecurityOptionsFocusTraversalPolicy());
        this.preferredUnsecured = new JRadioButton("Preferred Unsecured");
        this.preferredUnsecured.setActionCommand(NzSecurityLevel.preferredUnsecured.toString());
        this.onlyUnsecured = new JRadioButton("Only Unsecured");
        this.onlyUnsecured.setActionCommand(NzSecurityLevel.onlyUnsecured.toString());
        this.preferredSecured = new JRadioButton("Preferred Secured");
        this.preferredSecured.setActionCommand(NzSecurityLevel.preferredSecured.toString());
        this.onlySecured = new JRadioButton("Only Secured");
        this.onlySecured.setActionCommand(NzSecurityLevel.onlySecured.toString());
        this.group = new ButtonGroup();
        this.securityLevel = this.createLabel("Security Level", "Security level while establishing secured connection. Default - PREFERRED UNSECURED", 4);
        this.browse = this.createButton("Browse", 66, "Browse to get Path to CA certificate file.");
        this.chooser = new JFileChooser();
        this.caCertFileValue = new JTextField();
        this.caCertFile = this.createLabel("Certificate file", "CA certificate to validate server certificate.", 4);
        this.loginModule = this.createLabel("Login module", "Kerberos authentication login module name. Must be provided if kerberos authentication is enabled. Ignore otherwise.", 4);
        this.loginModuleValue = this.createTextField();
        this.krbSSODelegation = this.createCheckBox("Kerberos SSO delegation", "Make it true if the application is a kerberos delegation which has been configured in SSO mode and NPS is also configured in Kerberos authentication mode. Ignore for the rest of the cases.");
        this.group.add(this.preferredUnsecured);
        this.group.add(this.onlyUnsecured);
        this.group.add(this.preferredSecured);
        this.group.add(this.onlySecured);
        int x = 21;
        int y = 10;
        boolean nextColumn = false;
        for (int i = 0; i < 25; ++i) {
            Component component = null;
            switch (i) {
                case 0: {
                    this.securityLevel.setBounds(x, y, 75, 20);
                    nextColumn = true;
                    break;
                }
                case 1: {
                    this.preferredUnsecured.setBounds(x, y, 135, 20);
                    component = this.preferredUnsecured;
                    nextColumn = true;
                    break;
                }
                case 2: {
                    this.loginModule.setBounds(x, y, 65, 20);
                    component = this.loginModule;
                    nextColumn = true;
                    break;
                }
                case 3: {
                    this.loginModuleValue.setBounds(x, y, 100, 20);
                    component = this.loginModuleValue;
                    nextColumn = false;
                    break;
                }
                case 4: {
                    nextColumn = true;
                    break;
                }
                case 5: {
                    nextColumn = true;
                    this.onlyUnsecured.setBounds(x, y, 135, 20);
                    component = this.onlySecured;
                    break;
                }
                case 6: {
                    nextColumn = true;
                    break;
                }
                case 7: {
                    this.krbSSODelegation.setBounds(x, y, 185, 20);
                    component = this.krbSSODelegation;
                    nextColumn = false;
                    break;
                }
                case 8: {
                    nextColumn = true;
                    break;
                }
                case 9: {
                    this.preferredSecured.setBounds(x, y, 170, 20);
                    component = this.preferredSecured;
                    nextColumn = false;
                    break;
                }
                case 10: {
                    nextColumn = true;
                    break;
                }
                case 11: {
                    this.onlySecured.setBounds(x, y, 170, 20);
                    component = this.onlySecured;
                    nextColumn = false;
                    break;
                }
                case 12: {
                    this.caCertFile.setBounds(x, y, 85, 20);
                    nextColumn = true;
                    break;
                }
                case 13: {
                    this.caCertFileValue.setBounds(x, y, 170, 20);
                    component = this.caCertFileValue;
                    nextColumn = true;
                    break;
                }
                case 14: {
                    this.browse.setBounds(x, y, 85, 20);
                    component = this.browse;
                    nextColumn = false;
                }
            }
            if (nextColumn) {
                int width = component == null ? 85 : component.getWidth();
                x = x + width + 10;
                continue;
            }
            x = 21;
            y = y + 20 + 10;
        }
        this.securityPanel.add(this.securityLevel);
        this.securityPanel.add(this.preferredUnsecured);
        this.securityPanel.add(this.loginModule);
        this.securityPanel.add(this.loginModuleValue);
        this.securityPanel.add(this.krbSSODelegation);
        this.securityPanel.add(this.onlyUnsecured);
        this.securityPanel.add(this.preferredSecured);
        this.securityPanel.add(this.onlySecured);
        this.securityPanel.add(this.caCertFile);
        this.securityPanel.add(this.caCertFileValue);
        this.securityPanel.add(this.browse);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setFocusCycleRoot(true);
        this.buttonPanel.setFocusTraversalPolicy(new ButtonPanelFocusTraversalPolicy());
        this.ok = this.createButton("OK", 79, "Validates and saves the datasource.");
        this.cancel = this.createButton("Cancel", 67, "Closes the dialog without saving the data source.");
        this.help = this.createButton("Help", 72, "Displays Help dialog.");
        int width = 90;
        int x = 63;
        int y = 10;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    this.ok.setBounds(x, y, width, 20);
                    break;
                }
                case 1: {
                    this.cancel.setBounds(x, y, width, 20);
                    break;
                }
                case 2: {
                    this.help.setBounds(x, y, width, 20);
                }
            }
            x = x + width + 21;
        }
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.help);
    }

    private void createClientInfoPanel() {
        this.clientInfoPanel = new JPanel(null);
        this.clientInfoPanel.setName("Client Information Options");
        this.securityPanel.setFocusCycleRoot(true);
        this.securityPanel.setFocusTraversalPolicy(new SecurityOptionsFocusTraversalPolicy());
        this.applicationName = this.createLabel("Application name", "Clients application name", 4);
        this.applicationNameValue = this.createTextField();
        this.clientHostName = this.createLabel("Client host name", "Clients host name", 4);
        this.clientHostNameValue = this.createTextField();
        this.clientUser = this.createLabel("Client user", "Client side user name", 4);
        this.clientUserValue = this.createTextField();
        int x = 21;
        int y = 10;
        boolean nextColumn = false;
        for (int i = 0; i < 19; ++i) {
            Component component = null;
            switch (i) {
                case 0: {
                    this.applicationName.setBounds(x, y, 85, 20);
                    component = this.applicationName;
                    nextColumn = true;
                    break;
                }
                case 1: {
                    this.applicationNameValue.setBounds(x, y, 100, 20);
                    component = this.applicationNameValue;
                    nextColumn = true;
                    break;
                }
                case 2: {
                    this.clientUser.setBounds(x, y, 75, 20);
                    component = this.clientUser;
                    nextColumn = true;
                    break;
                }
                case 3: {
                    this.clientUserValue.setBounds(x, y, 100, 20);
                    component = this.clientUserValue;
                    nextColumn = false;
                    break;
                }
                case 4: {
                    this.clientHostName.setBounds(x, y, 85, 20);
                    component = this.clientHostName;
                    nextColumn = true;
                    break;
                }
                case 5: {
                    this.clientHostNameValue.setBounds(x, y, 100, 20);
                    component = this.clientHostNameValue;
                    nextColumn = true;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    break;
                }
            }
            if (nextColumn) {
                int width = component == null ? 85 : component.getWidth();
                x = x + width + 10;
                continue;
            }
            x = 21;
            y = y + 20 + 10;
        }
        this.clientInfoPanel.add(this.applicationName);
        this.clientInfoPanel.add(this.applicationNameValue);
        this.clientInfoPanel.add(this.clientHostName);
        this.clientInfoPanel.add(this.clientHostNameValue);
        this.clientInfoPanel.add(this.clientUser);
        this.clientInfoPanel.add(this.clientUserValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        String action = e.getActionCommand();
        if (action.equals(this.cancel.getActionCommand())) {
            if (Dialogs.showConfirmDialog("Are you sure you want to close ?", this)) {
                this.datasource = null;
                this.setVisible(false);
            }
        } else if (action.equals(this.testConnection.getActionCommand())) {
            this.testConnection();
        } else if (action.equals(this.help.getActionCommand())) {
            if (this.mainPage.getSelectedComponent() == this.connectionOptionsPanel) {
                Dialogs.showHelpDialog("Connection Options \n\nData Source:\nName of the data source (Mandatory).\n\nDescription:\nDescription for the data source.\n\nHost:\nName of the host to connect to (Mandatory).\n\nPort:\nPort number (Mandatory).\n\nDatabase:\nDatabase (Catalog) name (Mandatory).\n\nUser:\nUsername to connect to the database.\n\nPassword:\nPassword for authentication.\n\nSchema:\nSchema that user wants to connect to.\n\nTest Connection:\nTests the connection with the given parameters.", this);
            } else if (this.mainPage.getSelectedComponent() == this.advancedOptionsPanel) {
                Dialogs.showHelpDialog("Advanced Options \n\nBatch size:\nBatch size for the connection. (Number of rows to be fetched in a cycle) Default - 256.\n\nLogin timeout:\nMaximum wait time to make a connection. Default - infinite.\n\nRead only:\nRead Only property for the connection. Default - false.\n\nAutocommit:\nAuto Commit property for the connection. Default - true.\n\nLog level:\nLog Level for the connection. Default - OFF\n\nLogger type:\nLogger Type used for logging. Default - TEXT\n\nLogger directory:\nLog directory where the log files will be dumped.\n\nDatabase metadata:\nDatabase metadata.\n\nIgnore update count:\nIf set to true, ignore update count instead of throwing an exception if it overflows the max range of integer type.\n\n", this);
            } else if (this.mainPage.getSelectedComponent() == this.securityPanel) {
                Dialogs.showHelpDialog("Security Options \n\nSecurity Level:\nSecurity level while establishing secured connection. Default - PREFERRED UNSECURED\n\nCertificate file:\nCA certificate to validate server certificate.\n\nLogin module:\nKerberos authentication login module name. Must be provided if kerberos authentication is enabled. Ignore otherwise.\n\nKerberos SSO delegation:\nMake it true if the application is a kerberos delegation which has been configured in SSO mode and NPS is also configured in Kerberos authentication mode. Ignore for the rest of the cases.", this);
            } else if (this.mainPage.getSelectedComponent() == this.clientInfoPanel) {
                Dialogs.showHelpDialog("Client Info Options \n\nApplication name:\nClients application name\n\nClient user:\nClient side user name\n\nClient host name:\nClients host name", this);
            }
        } else if (action.equals(this.ok.getActionCommand())) {
            if (this.updateDatasource() && this.save()) {
                this.setVisible(false);
            }
        } else if (action.equals(this.logLevelValues.getActionCommand())) {
            LogLevel level = (LogLevel)((Object)this.logLevelValues.getSelectedItem());
            this.loggerTypeValues.setEnabled(!level.equals((Object)LogLevel.OFF));
            this.logPathValue.setEnabled(!level.equals((Object)LogLevel.OFF));
        } else if (action.equals(this.defaults.getActionCommand())) {
            this.batchSizeValue.setText("" + defaultDatasource.getBatchSize());
            this.loginTimeoutValue.setText("" + defaultDatasource.getLoginTimeout());
            this.readOnly.setSelected(defaultDatasource.isReadOnly());
            this.autoCommit.setSelected(defaultDatasource.isAutoCommit());
            this.loggerTypeValues.setSelectedItem(defaultDatasource.getLoggerType());
            this.logPathValue.setText(defaultDatasource.getLogDirPath());
            this.logLevelValues.setSelectedItem((Object)LogLevel.valueOf(defaultDatasource.getLogLevel()));
            this.dbMetadata.setSelected(defaultDatasource.getSpecCompliantDBMeta());
            this.ignoreUpdtCount.setSelected(defaultDatasource.getIgnoreUpdtCount());
        } else if (action.equals(this.browse.getActionCommand()) && (result = this.chooser.showOpenDialog(this)) == 0) {
            this.caCertFileValue.setText(this.chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void testConnection() {
        try {
            Class.forName("org.netezza.Driver");
        }
        catch (ClassNotFoundException e) {
            Dialogs.showErrorDialog(e.getMessage(), this);
        }
        String host = this.hostValue.getText() == null || this.hostValue.getText().trim().length() == 0 ? "" : this.hostValue.getText();
        String port = this.portValue.getText() == null || this.portValue.getText().trim().length() == 0 ? "" : this.portValue.getText();
        String database = this.databaseValue.getText() == null || this.databaseValue.getText().trim().length() == 0 ? "" : this.databaseValue.getText();
        String currSchema = this.schemaValue.getText() == null || this.schemaValue.getText().trim().length() == 0 ? "" : "schema=" + this.schemaValue.getText();
        LogLevel level = (LogLevel)((Object)this.logLevelValues.getSelectedItem());
        String loglevel = level == null ? "" : "loglevel=" + level.toString();
        NzSecurityLevel securityLevel = NzSecurityLevel.valueOf(this.group.getSelection().getActionCommand());
        LoggerType type = (LoggerType)((Object)this.loggerTypeValues.getSelectedItem());
        String loggertype = type == null ? "" : "loggertype=" + type.toString();
        String secLevel = securityLevel == null ? "" : "securityLevel=" + securityLevel.toString();
        String caCert = this.caCertFileValue.getText();
        String cert = caCert == null || caCert.trim().length() == 0 ? "" : "cacertFile=" + caCert;
        boolean db_metadata = this.dbMetadata.isSelected();
        boolean ignore_updtCount = this.ignoreUpdtCount.isSelected();
        boolean krb_sso_delegation = this.krbSSODelegation.isSelected();
        String databaseMetadata = db_metadata ? "DatabaseMetadata=" + db_metadata : "";
        String ignoreUpdtCount = ignore_updtCount ? "ignoreUpdateCount=" + ignore_updtCount : "";
        String krbSSODelegation = krb_sso_delegation ? "krbSSODelegation=" + krb_sso_delegation : "";
        String loginMod = this.loginModuleValue.getText();
        loginMod = loginMod == null || loginMod.trim().length() == 0 ? "" : "krbLoginModule=" + loginMod;
        String strLogDir = this.logPathValue.getText();
        String logDir = strLogDir == "" ? "" : "logDirPath=" + strLogDir;
        String strAppName = this.applicationNameValue.getText();
        String appName = strAppName == "" ? "" : "applicationName=" + strAppName;
        String strCliUser = this.clientUserValue.getText();
        String cliUser = strCliUser == "" ? "" : "clientUser=" + strCliUser;
        String strCliHostName = this.clientHostNameValue.getText();
        String cliHostName = strCliHostName == "" ? "" : "clientHostName=" + strCliHostName;
        String remote = host + (port.equals("") ? "" : ":" + port);
        String url = "jdbc:netezza://" + remote + "/" + database + ";" + currSchema + ";" + loglevel + ";" + loggertype + ";" + logDir + ";" + secLevel + ";" + cert + ";" + databaseMetadata + ";" + ignoreUpdtCount + ";" + loginMod + ";" + krbSSODelegation + ";" + appName + ";" + cliUser + ";" + cliHostName;
        String user = this.userValue.getText() == null ? "" : this.userValue.getText();
        char[] passwordArr = this.passwordValue.getPassword();
        String password = passwordArr.length == 0 ? "" : new String(this.passwordValue.getPassword());
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, user, password);
        }
        catch (Exception ex) {
            Dialogs.showConnectionFailureDialog(ex, "Netezza JDBC Driver Version  : " + Driver.getVersion(), this);
        }
        if (connection == null) {
            return;
        }
        try {
            StringBuffer message = new StringBuffer();
            message.append("NPS Product Version: " + connection.getMetaData().getDatabaseProductVersion() + "\n");
            message.append("Netezza JDBC Driver Version: " + Driver.getVersion() + "\n");
            connection.close();
            Dialogs.showConnectionSuccessDialog(message.toString(), this);
        }
        catch (SQLException ex) {
            Dialogs.showErrorDialog(ex.getMessage(), this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        JComponent component = (JComponent)e.getSource();
        if (component == this.mainPage) {
            JComponent selectedComponent = (JComponent)this.mainPage.getSelectedComponent();
            if (selectedComponent != null) {
                selectedComponent.grabFocus();
            }
        } else if (component == this.connectionOptionsPanel) {
            this.dsnNameValue.grabFocus();
        } else if (component == this.advancedOptionsPanel) {
            this.batchSizeValue.grabFocus();
        } else if (component == this.securityPanel) {
            this.preferredUnsecured.grabFocus();
        } else if (component == this.clientInfoPanel) {
            this.applicationNameValue.grabFocus();
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public JTextField createTextField() {
        JTextField field = new JTextField();
        field.setMargin(new Insets(0, 3, 0, 3));
        return field;
    }

    private JButton createButton(String name, int mnemonic, String tooltip) {
        JButton button = new JButton(name);
        button.setToolTipText(name);
        button.setMnemonic(mnemonic);
        button.setToolTipText(tooltip);
        return button;
    }

    private JCheckBox createCheckBox(String name, String tooltip) {
        JCheckBox box = new JCheckBox(name);
        box.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        box.setToolTipText(tooltip);
        return box;
    }

    private JLabel createLabel(String name, String tooltip, int horzAlignment) {
        JLabel label = new JLabel(name);
        label.setToolTipText(tooltip);
        label.setHorizontalAlignment(horzAlignment);
        return label;
    }

    public NzDatasource getDatasource() {
        return this.datasource;
    }

    private class ButtonPanelFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ButtonPanelFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.ok) {
                return DsnDialog.this.cancel;
            }
            if (aComponent == DsnDialog.this.cancel) {
                return DsnDialog.this.help;
            }
            if (aComponent == DsnDialog.this.help) {
                return DsnDialog.this.mainPage;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.help) {
                return DsnDialog.this.cancel;
            }
            if (aComponent == DsnDialog.this.cancel) {
                return DsnDialog.this.ok;
            }
            if (aComponent == DsnDialog.this.ok) {
                if (DsnDialog.this.mainPage.getSelectedComponent() == DsnDialog.this.connectionOptionsPanel) {
                    return DsnDialog.this.testConnection;
                }
                if (DsnDialog.this.mainPage.getSelectedComponent() == DsnDialog.this.advancedOptionsPanel) {
                    return DsnDialog.this.defaults;
                }
                if (DsnDialog.this.mainPage.getSelectedComponent() == DsnDialog.this.securityPanel) {
                    return DsnDialog.this.loginModuleValue;
                }
                return this.getDefaultComponent(focusCycleRoot);
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return DsnDialog.this.ok;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return DsnDialog.this.ok;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return DsnDialog.this.help;
        }
    }

    private class ClientInfoFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ClientInfoFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.applicationNameValue) {
                return DsnDialog.this.clientUserValue;
            }
            if (aComponent == DsnDialog.this.clientUserValue) {
                return DsnDialog.this.clientHostNameValue;
            }
            if (aComponent == DsnDialog.this.clientHostNameValue) {
                return DsnDialog.this.ok;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.clientHostNameValue) {
                return DsnDialog.this.clientUserValue;
            }
            if (aComponent == DsnDialog.this.clientUserValue) {
                return DsnDialog.this.applicationNameValue;
            }
            if (aComponent == DsnDialog.this.applicationNameValue) {
                return DsnDialog.this.help;
            }
            return null;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return DsnDialog.this.applicationNameValue;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return DsnDialog.this.applicationNameValue;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return DsnDialog.this.clientHostNameValue;
        }
    }

    private class SecurityOptionsFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private SecurityOptionsFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.preferredUnsecured) {
                return DsnDialog.this.onlyUnsecured;
            }
            if (aComponent == DsnDialog.this.onlyUnsecured) {
                return DsnDialog.this.preferredSecured;
            }
            if (aComponent == DsnDialog.this.preferredSecured) {
                return DsnDialog.this.onlySecured;
            }
            if (aComponent == DsnDialog.this.onlySecured) {
                return DsnDialog.this.caCertFileValue;
            }
            if (aComponent == DsnDialog.this.caCertFileValue) {
                return DsnDialog.this.browse;
            }
            if (aComponent == DsnDialog.this.browse) {
                return DsnDialog.this.loginModuleValue;
            }
            if (aComponent == DsnDialog.this.loginModuleValue) {
                return DsnDialog.this.krbSSODelegation;
            }
            if (aComponent == DsnDialog.this.krbSSODelegation) {
                return DsnDialog.this.ok;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.krbSSODelegation) {
                return DsnDialog.this.loginModuleValue;
            }
            if (aComponent == DsnDialog.this.loginModuleValue) {
                return DsnDialog.this.browse;
            }
            if (aComponent == DsnDialog.this.browse) {
                return DsnDialog.this.caCertFileValue;
            }
            if (aComponent == DsnDialog.this.caCertFileValue) {
                return DsnDialog.this.onlySecured;
            }
            if (aComponent == DsnDialog.this.onlySecured) {
                return DsnDialog.this.preferredSecured;
            }
            if (aComponent == DsnDialog.this.preferredSecured) {
                return DsnDialog.this.onlyUnsecured;
            }
            if (aComponent == DsnDialog.this.onlyUnsecured) {
                return DsnDialog.this.preferredUnsecured;
            }
            if (aComponent == DsnDialog.this.preferredUnsecured) {
                return DsnDialog.this.help;
            }
            return null;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return DsnDialog.this.preferredUnsecured;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return DsnDialog.this.preferredUnsecured;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return DsnDialog.this.browse;
        }
    }

    private class AdvancedOptionsFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private AdvancedOptionsFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            Component component = aComponent == DsnDialog.this.batchSizeValue ? DsnDialog.this.loginTimeoutValue : (aComponent == DsnDialog.this.loginTimeoutValue ? DsnDialog.this.readOnly : (aComponent == DsnDialog.this.readOnly ? DsnDialog.this.autoCommit : (aComponent == DsnDialog.this.autoCommit ? DsnDialog.this.ignoreUpdtCount : (aComponent == DsnDialog.this.ignoreUpdtCount ? DsnDialog.this.logLevelValues : (aComponent == DsnDialog.this.logLevelValues ? DsnDialog.this.loggerTypeValues : (aComponent == DsnDialog.this.loggerTypeValues ? DsnDialog.this.logPathValue : (aComponent == DsnDialog.this.logPathValue ? DsnDialog.this.dbMetadata : (aComponent == DsnDialog.this.dbMetadata ? DsnDialog.this.defaults : (aComponent == DsnDialog.this.defaults ? DsnDialog.this.ok : this.getDefaultComponent(focusCycleRoot))))))))));
            if (component.isEnabled()) {
                return component;
            }
            return this.getComponentAfter(focusCycleRoot, component);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            Component component = aComponent == DsnDialog.this.batchSizeValue ? DsnDialog.this.help : (aComponent == DsnDialog.this.loginTimeoutValue ? DsnDialog.this.batchSizeValue : (aComponent == DsnDialog.this.readOnly ? DsnDialog.this.loginTimeoutValue : (aComponent == DsnDialog.this.autoCommit ? DsnDialog.this.readOnly : (aComponent == DsnDialog.this.ignoreUpdtCount ? DsnDialog.this.autoCommit : (aComponent == DsnDialog.this.logLevelValues ? DsnDialog.this.ignoreUpdtCount : (aComponent == DsnDialog.this.loggerTypeValues ? DsnDialog.this.logLevelValues : (aComponent == DsnDialog.this.logPathValue ? DsnDialog.this.loggerTypeValues : (aComponent == DsnDialog.this.dbMetadata ? DsnDialog.this.logPathValue : (aComponent == DsnDialog.this.defaults ? DsnDialog.this.dbMetadata : this.getDefaultComponent(focusCycleRoot))))))))));
            if (component.isEnabled()) {
                return component;
            }
            return this.getComponentBefore(focusCycleRoot, component);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return DsnDialog.this.batchSizeValue;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return DsnDialog.this.batchSizeValue;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return DsnDialog.this.defaults;
        }
    }

    private class ConnectionOptionsFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ConnectionOptionsFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.dsnNameValue) {
                return DsnDialog.this.descriptionValue;
            }
            if (aComponent == DsnDialog.this.descriptionValue) {
                return DsnDialog.this.hostValue;
            }
            if (aComponent == DsnDialog.this.hostValue) {
                return DsnDialog.this.portValue;
            }
            if (aComponent == DsnDialog.this.portValue) {
                return DsnDialog.this.databaseValue;
            }
            if (aComponent == DsnDialog.this.databaseValue) {
                return DsnDialog.this.userValue;
            }
            if (aComponent == DsnDialog.this.userValue) {
                return DsnDialog.this.passwordValue;
            }
            if (aComponent == DsnDialog.this.passwordValue) {
                return DsnDialog.this.schemaValue;
            }
            if (aComponent == DsnDialog.this.schemaValue) {
                return DsnDialog.this.testConnection;
            }
            if (aComponent == DsnDialog.this.testConnection) {
                return DsnDialog.this.ok;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == DsnDialog.this.dsnNameValue) {
                return DsnDialog.this.help;
            }
            if (aComponent == DsnDialog.this.descriptionValue) {
                return DsnDialog.this.dsnNameValue;
            }
            if (aComponent == DsnDialog.this.hostValue) {
                return DsnDialog.this.descriptionValue;
            }
            if (aComponent == DsnDialog.this.portValue) {
                return DsnDialog.this.hostValue;
            }
            if (aComponent == DsnDialog.this.databaseValue) {
                return DsnDialog.this.portValue;
            }
            if (aComponent == DsnDialog.this.userValue) {
                return DsnDialog.this.databaseValue;
            }
            if (aComponent == DsnDialog.this.passwordValue) {
                return DsnDialog.this.userValue;
            }
            if (aComponent == DsnDialog.this.schemaValue) {
                return DsnDialog.this.passwordValue;
            }
            if (aComponent == DsnDialog.this.testConnection) {
                return DsnDialog.this.schemaValue;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return DsnDialog.this.dsnNameValue;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return DsnDialog.this.testConnection;
        }
    }
}

