/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;

public enum PgProtocol {
    PROTOCOL_3_4(3, 4, null),
    PROTOCOL_3_5(3, 5, PROTOCOL_3_4);

    private final int majorProtocol;
    private final int minorProtocol;
    private final PgProtocol previous;

    private PgProtocol(int majorProtocol, int minorProtocol, PgProtocol previous) {
        this.majorProtocol = majorProtocol;
        this.minorProtocol = minorProtocol;
        this.previous = previous;
    }

    public int getMajorVersion() {
        return this.majorProtocol;
    }

    public int getMinorVersion() {
        return this.minorProtocol;
    }

    public PgProtocol getPrevious() {
        return this.previous;
    }

    public boolean greaterThan(PgProtocol protocol) throws SQLException {
        if (protocol == null) {
            throw new SQLException("Protocol can not be 'NULL'", "HY000");
        }
        if (this.majorProtocol > protocol.majorProtocol) {
            return true;
        }
        return this.majorProtocol == protocol.majorProtocol && this.minorProtocol > protocol.minorProtocol;
    }

    public boolean equalTo(Object obj) {
        if (!(obj instanceof PgProtocol)) {
            return false;
        }
        PgProtocol protocol = (PgProtocol)((Object)obj);
        return protocol.getMajorVersion() == this.getMajorVersion() && protocol.getMinorVersion() == this.getMinorVersion();
    }

    public boolean lessThan(PgProtocol protocol) throws SQLException {
        if (protocol == null) {
            throw new SQLException("Protocol can not be 'NULL'", "HY000");
        }
        if (this.majorProtocol < protocol.majorProtocol) {
            return true;
        }
        return this.majorProtocol == protocol.majorProtocol && this.minorProtocol < protocol.minorProtocol;
    }

    public boolean greaterThanEqualTo(PgProtocol protocol) throws SQLException {
        return this.greaterThan(protocol) || this.equals((Object)protocol);
    }

    public boolean lessThanEqualTo(PgProtocol protocol) throws SQLException {
        return this.lessThan(protocol) || this.equals((Object)protocol);
    }

    public static PgProtocol getLatest() {
        return PROTOCOL_3_5;
    }

    public String toString() {
        return this.majorProtocol + "." + this.minorProtocol;
    }
}

