/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.multi;

import com.dbeaver.jdbc.files.FFFileScanner;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class MultiSourceFileScanner
implements FFFileScanner<Object, FFTableProperties> {
    private final FFDataSource<FFProperties> adaptedDatasource;
    private final FFFileScannerFactory<Object, FFTableProperties, FFProperties> delegateFactory;
    private final CompletableFuture<Void> connectionClosedFuture;

    public MultiSourceFileScanner(FFDataSource<FFProperties> adaptedDatasource, FFFileScannerFactory<Object, FFTableProperties, FFProperties> scannerFactory, CompletableFuture<Void> connectionClosedFuture) {
        this.adaptedDatasource = adaptedDatasource;
        this.delegateFactory = scannerFactory;
        this.connectionClosedFuture = connectionClosedFuture;
    }

    @NotNull
    public List<FFTable<Object, FFTableProperties>> scan(@NotNull FFDataSource<?> dataSource, @NotNull Path dataFile) throws IOException {
        FFFileScanner delegate = this.delegateFactory.createScanner(this.adaptedDatasource, this.connectionClosedFuture);
        List scan = delegate.scan(this.adaptedDatasource, dataFile);
        return scan;
    }
}

