/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.alloydb.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.alloydb.v1.CloudAlloyDBAdminRequest;
import com.google.api.services.alloydb.v1.CloudAlloyDBAdminRequestInitializer;
import com.google.api.services.alloydb.v1.model.Backup;
import com.google.api.services.alloydb.v1.model.CancelOperationRequest;
import com.google.api.services.alloydb.v1.model.Cluster;
import com.google.api.services.alloydb.v1.model.ConnectionInfo;
import com.google.api.services.alloydb.v1.model.Empty;
import com.google.api.services.alloydb.v1.model.FailoverInstanceRequest;
import com.google.api.services.alloydb.v1.model.GenerateClientCertificateRequest;
import com.google.api.services.alloydb.v1.model.GenerateClientCertificateResponse;
import com.google.api.services.alloydb.v1.model.GoogleCloudLocationListLocationsResponse;
import com.google.api.services.alloydb.v1.model.GoogleCloudLocationLocation;
import com.google.api.services.alloydb.v1.model.InjectFaultRequest;
import com.google.api.services.alloydb.v1.model.Instance;
import com.google.api.services.alloydb.v1.model.ListBackupsResponse;
import com.google.api.services.alloydb.v1.model.ListClustersResponse;
import com.google.api.services.alloydb.v1.model.ListInstancesResponse;
import com.google.api.services.alloydb.v1.model.ListOperationsResponse;
import com.google.api.services.alloydb.v1.model.ListSupportedDatabaseFlagsResponse;
import com.google.api.services.alloydb.v1.model.ListUsersResponse;
import com.google.api.services.alloydb.v1.model.Operation;
import com.google.api.services.alloydb.v1.model.PromoteClusterRequest;
import com.google.api.services.alloydb.v1.model.RestartInstanceRequest;
import com.google.api.services.alloydb.v1.model.RestoreClusterRequest;
import com.google.api.services.alloydb.v1.model.User;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudAlloyDBAdmin
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://alloydb.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://alloydb.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://alloydb.googleapis.com/";

    public CloudAlloyDBAdmin(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudAlloyDBAdmin(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the AlloyDB API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudAlloyDBAdmin.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://alloydb.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudAlloyDBAdmin.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudAlloyDBAdmin.DEFAULT_BATCH_PATH);
        }

        public CloudAlloyDBAdmin build() {
            return new CloudAlloyDBAdmin(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudAlloyDBAdminRequestInitializer(CloudAlloyDBAdminRequestInitializer cloudalloydbadminRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudalloydbadminRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Backups backups() {
                return new Backups();
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Operations operations() {
                return new Operations();
            }

            public SupportedDatabaseFlags supportedDatabaseFlags() {
                return new SupportedDatabaseFlags();
            }

            public class SupportedDatabaseFlags {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudAlloyDBAdminRequest<ListSupportedDatabaseFlagsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/supportedDatabaseFlags";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListSupportedDatabaseFlagsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudAlloyDBAdminRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudAlloyDBAdminRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(CloudAlloyDBAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends CloudAlloyDBAdminRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Clusters {
                public Create create(String parent, Cluster content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Createsecondary createsecondary(String parent, Cluster content) throws IOException {
                    Createsecondary result = new Createsecondary(parent, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GenerateClientCertificate generateClientCertificate(String parent, GenerateClientCertificateRequest content) throws IOException {
                    GenerateClientCertificate result = new GenerateClientCertificate(parent, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Cluster content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Promote promote(String name, PromoteClusterRequest content) throws IOException {
                    Promote result = new Promote(name, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Restore restore(String parent, RestoreClusterRequest content) throws IOException {
                    Restore result = new Restore(parent, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Instances instances() {
                    return new Instances();
                }

                public Users users() {
                    return new Users();
                }

                public class Users {
                    public Create create(String parent, User content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, User content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Patch
                    extends CloudAlloyDBAdminRequest<User> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean allowMissing;
                        @Key
                        private String requestId;
                        @Key
                        private String updateMask;
                        @Key
                        private Boolean validateOnly;

                        protected Patch(String name, User content) {
                            super(CloudAlloyDBAdmin.this, "PATCH", REST_PATH, (Object)content, User.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getAllowMissing() {
                            return this.allowMissing;
                        }

                        public Patch setAllowMissing(Boolean allowMissing) {
                            this.allowMissing = allowMissing;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Patch setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Patch setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudAlloyDBAdminRequest<ListUsersResponse> {
                        private static final String REST_PATH = "v1/{+parent}/users";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListUsersResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudAlloyDBAdminRequest<User> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, User.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudAlloyDBAdminRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String requestId;
                        @Key
                        private Boolean validateOnly;

                        protected Delete(String name) {
                            super(CloudAlloyDBAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/users/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Delete setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Delete setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudAlloyDBAdminRequest<User> {
                        private static final String REST_PATH = "v1/{+parent}/users";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String requestId;
                        @Key
                        private String userId;
                        @Key
                        private Boolean validateOnly;

                        protected Create(String parent, User content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, User.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Create setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public Create setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Create setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Instances {
                    public Create create(String parent, Instance content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Createsecondary createsecondary(String parent, Instance content) throws IOException {
                        Createsecondary result = new Createsecondary(parent, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Failover failover(String name, FailoverInstanceRequest content) throws IOException {
                        Failover result = new Failover(name, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetConnectionInfo getConnectionInfo(String parent) throws IOException {
                        GetConnectionInfo result = new GetConnectionInfo(parent);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public InjectFault injectFault(String name, InjectFaultRequest content) throws IOException {
                        InjectFault result = new InjectFault(name, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, Instance content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Restart restart(String name, RestartInstanceRequest content) throws IOException {
                        Restart result = new Restart(name, content);
                        CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Restart
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:restart";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Restart(String name, RestartInstanceRequest content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public Restart set$Xgafv(String $Xgafv) {
                            return (Restart)super.set$Xgafv($Xgafv);
                        }

                        public Restart setAccessToken(String accessToken) {
                            return (Restart)super.setAccessToken(accessToken);
                        }

                        public Restart setAlt(String alt) {
                            return (Restart)super.setAlt(alt);
                        }

                        public Restart setCallback(String callback) {
                            return (Restart)super.setCallback(callback);
                        }

                        public Restart setFields(String fields) {
                            return (Restart)super.setFields(fields);
                        }

                        public Restart setKey(String key) {
                            return (Restart)super.setKey(key);
                        }

                        public Restart setOauthToken(String oauthToken) {
                            return (Restart)super.setOauthToken(oauthToken);
                        }

                        public Restart setPrettyPrint(Boolean prettyPrint) {
                            return (Restart)super.setPrettyPrint(prettyPrint);
                        }

                        public Restart setQuotaUser(String quotaUser) {
                            return (Restart)super.setQuotaUser(quotaUser);
                        }

                        public Restart setUploadType(String uploadType) {
                            return (Restart)super.setUploadType(uploadType);
                        }

                        public Restart setUploadProtocol(String uploadProtocol) {
                            return (Restart)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Restart setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Restart set(String parameterName, Object value) {
                            return (Restart)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean allowMissing;
                        @Key
                        private String requestId;
                        @Key
                        private String updateMask;
                        @Key
                        private Boolean validateOnly;

                        protected Patch(String name, Instance content) {
                            super(CloudAlloyDBAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getAllowMissing() {
                            return this.allowMissing;
                        }

                        public Patch setAllowMissing(Boolean allowMissing) {
                            this.allowMissing = allowMissing;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Patch setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Patch setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudAlloyDBAdminRequest<ListInstancesResponse> {
                        private static final String REST_PATH = "v1/{+parent}/instances";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListInstancesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class InjectFault
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:injectFault";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected InjectFault(String name, InjectFaultRequest content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public InjectFault set$Xgafv(String $Xgafv) {
                            return (InjectFault)super.set$Xgafv($Xgafv);
                        }

                        public InjectFault setAccessToken(String accessToken) {
                            return (InjectFault)super.setAccessToken(accessToken);
                        }

                        public InjectFault setAlt(String alt) {
                            return (InjectFault)super.setAlt(alt);
                        }

                        public InjectFault setCallback(String callback) {
                            return (InjectFault)super.setCallback(callback);
                        }

                        public InjectFault setFields(String fields) {
                            return (InjectFault)super.setFields(fields);
                        }

                        public InjectFault setKey(String key) {
                            return (InjectFault)super.setKey(key);
                        }

                        public InjectFault setOauthToken(String oauthToken) {
                            return (InjectFault)super.setOauthToken(oauthToken);
                        }

                        public InjectFault setPrettyPrint(Boolean prettyPrint) {
                            return (InjectFault)super.setPrettyPrint(prettyPrint);
                        }

                        public InjectFault setQuotaUser(String quotaUser) {
                            return (InjectFault)super.setQuotaUser(quotaUser);
                        }

                        public InjectFault setUploadType(String uploadType) {
                            return (InjectFault)super.setUploadType(uploadType);
                        }

                        public InjectFault setUploadProtocol(String uploadProtocol) {
                            return (InjectFault)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public InjectFault setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public InjectFault set(String parameterName, Object value) {
                            return (InjectFault)super.set(parameterName, value);
                        }
                    }

                    public class GetConnectionInfo
                    extends CloudAlloyDBAdminRequest<ConnectionInfo> {
                        private static final String REST_PATH = "v1/{+parent}/connectionInfo";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String requestId;

                        protected GetConnectionInfo(String parent) {
                            super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ConnectionInfo.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetConnectionInfo set$Xgafv(String $Xgafv) {
                            return (GetConnectionInfo)super.set$Xgafv($Xgafv);
                        }

                        public GetConnectionInfo setAccessToken(String accessToken) {
                            return (GetConnectionInfo)super.setAccessToken(accessToken);
                        }

                        public GetConnectionInfo setAlt(String alt) {
                            return (GetConnectionInfo)super.setAlt(alt);
                        }

                        public GetConnectionInfo setCallback(String callback) {
                            return (GetConnectionInfo)super.setCallback(callback);
                        }

                        public GetConnectionInfo setFields(String fields) {
                            return (GetConnectionInfo)super.setFields(fields);
                        }

                        public GetConnectionInfo setKey(String key) {
                            return (GetConnectionInfo)super.setKey(key);
                        }

                        public GetConnectionInfo setOauthToken(String oauthToken) {
                            return (GetConnectionInfo)super.setOauthToken(oauthToken);
                        }

                        public GetConnectionInfo setPrettyPrint(Boolean prettyPrint) {
                            return (GetConnectionInfo)super.setPrettyPrint(prettyPrint);
                        }

                        public GetConnectionInfo setQuotaUser(String quotaUser) {
                            return (GetConnectionInfo)super.setQuotaUser(quotaUser);
                        }

                        public GetConnectionInfo setUploadType(String uploadType) {
                            return (GetConnectionInfo)super.setUploadType(uploadType);
                        }

                        public GetConnectionInfo setUploadProtocol(String uploadProtocol) {
                            return (GetConnectionInfo)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public GetConnectionInfo setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public GetConnectionInfo setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        @Override
                        public GetConnectionInfo set(String parameterName, Object value) {
                            return (GetConnectionInfo)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudAlloyDBAdminRequest<Instance> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String view;

                        protected Get(String name) {
                            super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, Instance.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getView() {
                            return this.view;
                        }

                        public Get setView(String view) {
                            this.view = view;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Failover
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:failover";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Failover(String name, FailoverInstanceRequest content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public Failover set$Xgafv(String $Xgafv) {
                            return (Failover)super.set$Xgafv($Xgafv);
                        }

                        public Failover setAccessToken(String accessToken) {
                            return (Failover)super.setAccessToken(accessToken);
                        }

                        public Failover setAlt(String alt) {
                            return (Failover)super.setAlt(alt);
                        }

                        public Failover setCallback(String callback) {
                            return (Failover)super.setCallback(callback);
                        }

                        public Failover setFields(String fields) {
                            return (Failover)super.setFields(fields);
                        }

                        public Failover setKey(String key) {
                            return (Failover)super.setKey(key);
                        }

                        public Failover setOauthToken(String oauthToken) {
                            return (Failover)super.setOauthToken(oauthToken);
                        }

                        public Failover setPrettyPrint(Boolean prettyPrint) {
                            return (Failover)super.setPrettyPrint(prettyPrint);
                        }

                        public Failover setQuotaUser(String quotaUser) {
                            return (Failover)super.setQuotaUser(quotaUser);
                        }

                        public Failover setUploadType(String uploadType) {
                            return (Failover)super.setUploadType(uploadType);
                        }

                        public Failover setUploadProtocol(String uploadProtocol) {
                            return (Failover)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Failover setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Failover set(String parameterName, Object value) {
                            return (Failover)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String etag;
                        @Key
                        private String requestId;
                        @Key
                        private Boolean validateOnly;

                        protected Delete(String name) {
                            super(CloudAlloyDBAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/instances/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getEtag() {
                            return this.etag;
                        }

                        public Delete setEtag(String etag) {
                            this.etag = etag;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Delete setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Delete setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Createsecondary
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/instances:createsecondary";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String instanceId;
                        @Key
                        private String requestId;
                        @Key
                        private Boolean validateOnly;

                        protected Createsecondary(String parent, Instance content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Createsecondary set$Xgafv(String $Xgafv) {
                            return (Createsecondary)super.set$Xgafv($Xgafv);
                        }

                        public Createsecondary setAccessToken(String accessToken) {
                            return (Createsecondary)super.setAccessToken(accessToken);
                        }

                        public Createsecondary setAlt(String alt) {
                            return (Createsecondary)super.setAlt(alt);
                        }

                        public Createsecondary setCallback(String callback) {
                            return (Createsecondary)super.setCallback(callback);
                        }

                        public Createsecondary setFields(String fields) {
                            return (Createsecondary)super.setFields(fields);
                        }

                        public Createsecondary setKey(String key) {
                            return (Createsecondary)super.setKey(key);
                        }

                        public Createsecondary setOauthToken(String oauthToken) {
                            return (Createsecondary)super.setOauthToken(oauthToken);
                        }

                        public Createsecondary setPrettyPrint(Boolean prettyPrint) {
                            return (Createsecondary)super.setPrettyPrint(prettyPrint);
                        }

                        public Createsecondary setQuotaUser(String quotaUser) {
                            return (Createsecondary)super.setQuotaUser(quotaUser);
                        }

                        public Createsecondary setUploadType(String uploadType) {
                            return (Createsecondary)super.setUploadType(uploadType);
                        }

                        public Createsecondary setUploadProtocol(String uploadProtocol) {
                            return (Createsecondary)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Createsecondary setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getInstanceId() {
                            return this.instanceId;
                        }

                        public Createsecondary setInstanceId(String instanceId) {
                            this.instanceId = instanceId;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Createsecondary setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Createsecondary setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Createsecondary set(String parameterName, Object value) {
                            return (Createsecondary)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudAlloyDBAdminRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/instances";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String instanceId;
                        @Key
                        private String requestId;
                        @Key
                        private Boolean validateOnly;

                        protected Create(String parent, Instance content) {
                            super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getInstanceId() {
                            return this.instanceId;
                        }

                        public Create setInstanceId(String instanceId) {
                            this.instanceId = instanceId;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Create setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        public Boolean getValidateOnly() {
                            return this.validateOnly;
                        }

                        public Create setValidateOnly(Boolean validateOnly) {
                            this.validateOnly = validateOnly;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Restore
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/clusters:restore";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Restore(String parent, RestoreClusterRequest content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Restore set$Xgafv(String $Xgafv) {
                        return (Restore)super.set$Xgafv($Xgafv);
                    }

                    public Restore setAccessToken(String accessToken) {
                        return (Restore)super.setAccessToken(accessToken);
                    }

                    public Restore setAlt(String alt) {
                        return (Restore)super.setAlt(alt);
                    }

                    public Restore setCallback(String callback) {
                        return (Restore)super.setCallback(callback);
                    }

                    public Restore setFields(String fields) {
                        return (Restore)super.setFields(fields);
                    }

                    public Restore setKey(String key) {
                        return (Restore)super.setKey(key);
                    }

                    public Restore setOauthToken(String oauthToken) {
                        return (Restore)super.setOauthToken(oauthToken);
                    }

                    public Restore setPrettyPrint(Boolean prettyPrint) {
                        return (Restore)super.setPrettyPrint(prettyPrint);
                    }

                    public Restore setQuotaUser(String quotaUser) {
                        return (Restore)super.setQuotaUser(quotaUser);
                    }

                    public Restore setUploadType(String uploadType) {
                        return (Restore)super.setUploadType(uploadType);
                    }

                    public Restore setUploadProtocol(String uploadProtocol) {
                        return (Restore)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Restore setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Restore set(String parameterName, Object value) {
                        return (Restore)super.set(parameterName, value);
                    }
                }

                public class Promote
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:promote";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Promote(String name, PromoteClusterRequest content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Promote set$Xgafv(String $Xgafv) {
                        return (Promote)super.set$Xgafv($Xgafv);
                    }

                    public Promote setAccessToken(String accessToken) {
                        return (Promote)super.setAccessToken(accessToken);
                    }

                    public Promote setAlt(String alt) {
                        return (Promote)super.setAlt(alt);
                    }

                    public Promote setCallback(String callback) {
                        return (Promote)super.setCallback(callback);
                    }

                    public Promote setFields(String fields) {
                        return (Promote)super.setFields(fields);
                    }

                    public Promote setKey(String key) {
                        return (Promote)super.setKey(key);
                    }

                    public Promote setOauthToken(String oauthToken) {
                        return (Promote)super.setOauthToken(oauthToken);
                    }

                    public Promote setPrettyPrint(Boolean prettyPrint) {
                        return (Promote)super.setPrettyPrint(prettyPrint);
                    }

                    public Promote setQuotaUser(String quotaUser) {
                        return (Promote)super.setQuotaUser(quotaUser);
                    }

                    public Promote setUploadType(String uploadType) {
                        return (Promote)super.setUploadType(uploadType);
                    }

                    public Promote setUploadProtocol(String uploadProtocol) {
                        return (Promote)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Promote setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Promote set(String parameterName, Object value) {
                        return (Promote)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean allowMissing;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;
                    @Key
                    private Boolean validateOnly;

                    protected Patch(String name, Cluster content) {
                        super(CloudAlloyDBAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getAllowMissing() {
                        return this.allowMissing;
                    }

                    public Patch setAllowMissing(Boolean allowMissing) {
                        this.allowMissing = allowMissing;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Patch setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudAlloyDBAdminRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudAlloyDBAdminRequest<Cluster> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String view;

                    protected Get(String name) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, Cluster.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class GenerateClientCertificate
                extends CloudAlloyDBAdminRequest<GenerateClientCertificateResponse> {
                    private static final String REST_PATH = "v1/{+parent}:generateClientCertificate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected GenerateClientCertificate(String parent, GenerateClientCertificateRequest content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, GenerateClientCertificateResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public GenerateClientCertificate set$Xgafv(String $Xgafv) {
                        return (GenerateClientCertificate)super.set$Xgafv($Xgafv);
                    }

                    public GenerateClientCertificate setAccessToken(String accessToken) {
                        return (GenerateClientCertificate)super.setAccessToken(accessToken);
                    }

                    public GenerateClientCertificate setAlt(String alt) {
                        return (GenerateClientCertificate)super.setAlt(alt);
                    }

                    public GenerateClientCertificate setCallback(String callback) {
                        return (GenerateClientCertificate)super.setCallback(callback);
                    }

                    public GenerateClientCertificate setFields(String fields) {
                        return (GenerateClientCertificate)super.setFields(fields);
                    }

                    public GenerateClientCertificate setKey(String key) {
                        return (GenerateClientCertificate)super.setKey(key);
                    }

                    public GenerateClientCertificate setOauthToken(String oauthToken) {
                        return (GenerateClientCertificate)super.setOauthToken(oauthToken);
                    }

                    public GenerateClientCertificate setPrettyPrint(Boolean prettyPrint) {
                        return (GenerateClientCertificate)super.setPrettyPrint(prettyPrint);
                    }

                    public GenerateClientCertificate setQuotaUser(String quotaUser) {
                        return (GenerateClientCertificate)super.setQuotaUser(quotaUser);
                    }

                    public GenerateClientCertificate setUploadType(String uploadType) {
                        return (GenerateClientCertificate)super.setUploadType(uploadType);
                    }

                    public GenerateClientCertificate setUploadProtocol(String uploadProtocol) {
                        return (GenerateClientCertificate)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public GenerateClientCertificate setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public GenerateClientCertificate set(String parameterName, Object value) {
                        return (GenerateClientCertificate)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String etag;
                    @Key
                    private Boolean force;
                    @Key
                    private String requestId;
                    @Key
                    private Boolean validateOnly;

                    protected Delete(String name) {
                        super(CloudAlloyDBAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getEtag() {
                        return this.etag;
                    }

                    public Delete setEtag(String etag) {
                        this.etag = etag;
                        return this;
                    }

                    public Boolean getForce() {
                        return this.force;
                    }

                    public Delete setForce(Boolean force) {
                        this.force = force;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Delete setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Createsecondary
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/clusters:createsecondary";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String clusterId;
                    @Key
                    private String requestId;
                    @Key
                    private Boolean validateOnly;

                    protected Createsecondary(String parent, Cluster content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Createsecondary set$Xgafv(String $Xgafv) {
                        return (Createsecondary)super.set$Xgafv($Xgafv);
                    }

                    public Createsecondary setAccessToken(String accessToken) {
                        return (Createsecondary)super.setAccessToken(accessToken);
                    }

                    public Createsecondary setAlt(String alt) {
                        return (Createsecondary)super.setAlt(alt);
                    }

                    public Createsecondary setCallback(String callback) {
                        return (Createsecondary)super.setCallback(callback);
                    }

                    public Createsecondary setFields(String fields) {
                        return (Createsecondary)super.setFields(fields);
                    }

                    public Createsecondary setKey(String key) {
                        return (Createsecondary)super.setKey(key);
                    }

                    public Createsecondary setOauthToken(String oauthToken) {
                        return (Createsecondary)super.setOauthToken(oauthToken);
                    }

                    public Createsecondary setPrettyPrint(Boolean prettyPrint) {
                        return (Createsecondary)super.setPrettyPrint(prettyPrint);
                    }

                    public Createsecondary setQuotaUser(String quotaUser) {
                        return (Createsecondary)super.setQuotaUser(quotaUser);
                    }

                    public Createsecondary setUploadType(String uploadType) {
                        return (Createsecondary)super.setUploadType(uploadType);
                    }

                    public Createsecondary setUploadProtocol(String uploadProtocol) {
                        return (Createsecondary)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Createsecondary setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Createsecondary setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Createsecondary setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Createsecondary setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Createsecondary set(String parameterName, Object value) {
                        return (Createsecondary)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String clusterId;
                    @Key
                    private String requestId;
                    @Key
                    private Boolean validateOnly;

                    protected Create(String parent, Cluster content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Create setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Create setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Backups {
                public Create create(String parent, Backup content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Backup content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudAlloyDBAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean allowMissing;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;
                    @Key
                    private Boolean validateOnly;

                    protected Patch(String name, Backup content) {
                        super(CloudAlloyDBAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getAllowMissing() {
                        return this.allowMissing;
                    }

                    public Patch setAllowMissing(Boolean allowMissing) {
                        this.allowMissing = allowMissing;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Patch setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudAlloyDBAdminRequest<ListBackupsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/backups";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, ListBackupsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudAlloyDBAdminRequest<Backup> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, Backup.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String etag;
                    @Key
                    private String requestId;
                    @Key
                    private Boolean validateOnly;

                    protected Delete(String name) {
                        super(CloudAlloyDBAdmin.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/backups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getEtag() {
                        return this.etag;
                    }

                    public Delete setEtag(String etag) {
                        this.etag = etag;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Delete setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudAlloyDBAdminRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/backups";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String backupId;
                    @Key
                    private String requestId;
                    @Key
                    private Boolean validateOnly;

                    protected Create(String parent, Backup content) {
                        super(CloudAlloyDBAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getBackupId() {
                        return this.backupId;
                    }

                    public Create setBackupId(String backupId) {
                        this.backupId = backupId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Boolean getValidateOnly() {
                        return this.validateOnly;
                    }

                    public Create setValidateOnly(Boolean validateOnly) {
                        this.validateOnly = validateOnly;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends CloudAlloyDBAdminRequest<GoogleCloudLocationListLocationsResponse> {
                private static final String REST_PATH = "v1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, GoogleCloudLocationListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudAlloyDBAdminRequest<GoogleCloudLocationLocation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudAlloyDBAdmin.this, "GET", REST_PATH, null, GoogleCloudLocationLocation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudAlloyDBAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

