/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;

public class CloudConfigurationEditDialog
extends BaseDialog {
    private final CloudConfigurationDescriptor currentCloudConfig;
    private CloudConfigurationEditPage editPage;

    public CloudConfigurationEditDialog(Shell parentShell, CloudConfigurationDescriptor cloudConfiguration) {
        super(parentShell, cloudConfiguration == null ? CloudUIMessages.cloud_configuration_edit_dialog_title_create : CloudUIMessages.cloud_configuration_edit_dialog_title_edit, null);
        this.currentCloudConfig = cloudConfiguration;
    }

    public CloudConfigurationDescriptor getCurrentCloudConfig() {
        return this.editPage.getCurrentCloudConfig();
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        this.editPage = new CloudConfigurationEditPage();
        this.editPage.setConfiguration(this.currentCloudConfig);
        this.editPage.setPropChangeListener(this::updateButtons);
        this.editPage.createControl(dialogArea);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 16, CloudUIMessages.cloud_configuration_edit_dialog_button_apply, false);
        this.createButton(parent, 12, DialogUtils.APPLY_AND_CLOSE_BUTTON_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    private void updateButtons() {
        UIUtils.asyncExec(() -> {
            boolean isComplete = this.editPage.isComplete();
            this.enableButton(16, isComplete);
            this.enableButton(12, isComplete);
        });
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 16: {
                this.editPage.saveConfigurations();
                break;
            }
            case 12: {
                if (!this.editPage.saveConfigurations()) break;
                this.close();
                break;
            }
            case 1: {
                super.buttonPressed(1);
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void okPressed() {
        this.editPage.saveConfigurations();
        super.okPressed();
    }
}

