/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.security;

import com.dbeaver.application.DBeaverApplicationAdvanced;
import com.dbeaver.model.security.DBPasswordValidator;
import com.dbeaver.ui.security.EnterPasswordDialog;
import com.dbeaver.ui.security.MainWindowProvider;
import com.dbeaver.ui.security.NewPasswordDialog;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.storage.provider.IValidatingPasswordProvider;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBeaverPasswordProvider
extends PasswordProvider
implements IValidatingPasswordProvider {
    private static final Log log = Log.getLog(DBeaverPasswordProvider.class);
    public static final String ID = "DBeaverPasswordProvider";
    public static final String MODULE_ID = "com.dbeaver.app.advanced.dbeaverpasswordprovider";

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
            log.error((Object)"WARNING: Master password requested in headless mode. As a workaround, use integrated password provider instead.");
            return null;
        }
        if (DBWorkbench.getPlatform().getApplication().isDistributed()) {
            return null;
        }
        String[] password = new String[1];
        boolean[] tryAgain = new boolean[1];
        UIUtils.syncExec(() -> {
            try {
                stringArray[0] = this.getPasswordFromUI(passwordType);
            }
            catch (SecurityMethodWasChangedException securityMethodWasChangedException) {
                blArray[0] = true;
            }
        });
        if (tryAgain[0]) {
            boolean addedNoPrompt;
            SecurePreferencesContainer c = (SecurePreferencesContainer)container;
            boolean bl = addedNoPrompt = !c.hasOption((Object)"org.eclipse.equinox.security.storage.promptUser");
            if (addedNoPrompt) {
                c.setOption((Object)"org.eclipse.equinox.security.storage.promptUser", (Object)Boolean.FALSE);
            }
            try {
                PBEKeySpec pBEKeySpec = c.getRootData().getPassword(null, (IPreferencesContainer)c, true).getPassword();
                return pBEKeySpec;
            }
            catch (StorageException e) {
                log.error((Object)"Error requesting password from the integrated password provider", (Throwable)e);
            }
            finally {
                if (addedNoPrompt) {
                    c.removeOption((Object)"org.eclipse.equinox.security.storage.promptUser");
                }
            }
        }
        if (password[0] == null) {
            return null;
        }
        return new PBEKeySpec(password[0].toCharArray());
    }

    public boolean isValid() {
        return !DBWorkbench.getPlatform().getApplication().isDistributed() && !ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.master.password.disable");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getPasswordFromUI(int passwordType) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MainWindowProvider mainWindowProvider = new MainWindowProvider();){
            boolean newPassword = (passwordType & 1) != 0;
            boolean passwordChange = (passwordType & 2) != 0;
            DBeaverApplicationAdvanced application = (DBeaverApplicationAdvanced)DBWorkbench.getPlatform().getApplication();
            String password = newPassword ? NewPasswordDialog.getNewPassword((Shell)mainWindowProvider.getActiveShell(), (String)("Set " + GeneralUtils.getProductName() + " master password"), (String)"Set master password to save secure information", null, (DBPasswordValidator)application.getPasswordValidator()) : (passwordChange ? NewPasswordDialog.getNewPassword((Shell)mainWindowProvider.getActiveShell(), (String)"Change master password", null, null, (DBPasswordValidator)application.getPasswordValidator()) : EnterPasswordDialog.askPassword((Shell)mainWindowProvider.getActiveShell(), (String)"Master password", (String)(GeneralUtils.getProductName() + " master password"), null, (boolean)false));
            if (!CommonUtils.isEmpty((String)password)) return password;
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public boolean retryOnError(Exception e, IPreferencesContainer container) {
        if (e instanceof SecurityMethodWasChangedException) {
            return true;
        }
        boolean[] result = new boolean[1];
        UIUtils.syncExec(() -> {
            boolean reply;
            blArray[0] = reply = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Workspace master password", (String)"Incorrect password or data is corrupted. Would you like to re-log?");
        });
        return result[0];
    }

    private static class SecurityMethodWasChangedException
    extends RuntimeException {
        private SecurityMethodWasChangedException() {
        }
    }
}

