/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddForeignKeyConstraintGenerator;
import liquibase.statement.core.AddForeignKeyConstraintStatement;
import liquibase.structure.DatabaseObject;

public class BigQueryAddForeignKeyConstraintGenerator
extends AddForeignKeyConstraintGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddForeignKeyConstraintStatement statement, Database database) {
        return database instanceof BigQueryDatabase;
    }

    public Sql[] generateSql(AddForeignKeyConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(database.escapeTableName(statement.getBaseTableCatalogName(), statement.getBaseTableSchemaName(), statement.getBaseTableName())).append(" ADD CONSTRAINT ").append(database.escapeConstraintName(statement.getConstraintName())).append(" FOREIGN KEY (").append(database.escapeColumnNameList(statement.getBaseColumnNames())).append(") REFERENCES ").append(database.escapeTableName(statement.getReferencedTableCatalogName(), statement.getReferencedTableSchemaName(), statement.getReferencedTableName())).append(" (").append(database.escapeColumnNameList(statement.getReferencedColumnNames())).append(") NOT ENFORCED");
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[]{this.getAffectedForeignKey(statement)})};
    }
}

