/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.change;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.AddColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.database.Database;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.core.Column;

@DatabaseChange(name="mergeColumns", description="Concatenates the values in two columns, joins them by with string, and stores the resulting value in a new column.", priority=5)
public class BigQueryMergeColumnChange
extends MergeColumnChange {
    public boolean supports(Database database) {
        return database instanceof BigQueryDatabase;
    }

    public SqlStatement[] generateStatements(Database database) {
        AddColumnChange addNewColumnChange = new AddColumnChange();
        addNewColumnChange.setSchemaName(this.getSchemaName());
        addNewColumnChange.setTableName(this.getTableName());
        AddColumnConfig columnConfig = new AddColumnConfig();
        columnConfig.setName(this.getFinalColumnName());
        columnConfig.setType(this.getFinalColumnType());
        addNewColumnChange.addColumn(columnConfig);
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>(Arrays.asList(addNewColumnChange.generateStatements(database)));
        String updateStatement = "UPDATE " + database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName()) + " SET " + database.escapeObjectName(this.getFinalColumnName(), Column.class) + " = " + database.getConcatSql(new String[]{database.escapeObjectName(this.getColumn1Name(), Column.class), "'" + this.getJoinString() + "'", database.escapeObjectName(this.getColumn2Name(), Column.class)}) + " WHERE 1 = 1 ";
        statements.add((SqlStatement)new RawParameterizedSqlStatement(updateStatement));
        DropColumnChange dropColumn1Change = new DropColumnChange();
        dropColumn1Change.setSchemaName(this.getSchemaName());
        dropColumn1Change.setTableName(this.getTableName());
        dropColumn1Change.setColumnName(this.getColumn1Name());
        statements.addAll(Arrays.asList(dropColumn1Change.generateStatements(database)));
        DropColumnChange dropColumn2Change = new DropColumnChange();
        dropColumn2Change.setSchemaName(this.getSchemaName());
        dropColumn2Change.setTableName(this.getTableName());
        dropColumn2Change.setColumnName(this.getColumn2Name());
        statements.addAll(Arrays.asList(dropColumn2Change.generateStatements(database)));
        return statements.toArray(new SqlStatement[0]);
    }
}

