/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCChangeList;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCCompareEngine;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCChangeListH2;
import com.dbeaver.data.compare.model.impl.DCChangeListMemory;
import com.dbeaver.data.compare.model.impl.DCDataReceiver;
import com.dbeaver.data.compare.model.impl.DCSummaryImpl;
import java.text.MessageFormat;
import java.util.Map;
import java.util.OptionalLong;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DCCompareEngineImpl
implements DCCompareEngine {
    private static final Log log = Log.getLog(DCCompareEngineImpl.class);
    private DCChangeList changeList;

    @Override
    @NotNull
    public DCSummary compare(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) throws DBException {
        Statistics statistics;
        this.changeList = settings.isStoreResultsInMemory() ? new DCChangeListMemory() : new DCChangeListH2(monitor, settings);
        DCDataReceiver leftReceiver = new DCDataReceiver(settings, settings.getLeftInput());
        DCDataReceiver rightReceiver = new DCDataReceiver(settings, settings.getRightInput());
        long compareTimeStart = System.currentTimeMillis();
        leftReceiver.schedule();
        rightReceiver.schedule();
        try {
            try {
                statistics = this.process(monitor, leftReceiver, rightReceiver, settings, this.createProgressReporter(monitor, settings));
            }
            catch (InterruptedException e) {
                throw new DBException("Interrupted", (Throwable)e);
            }
        }
        finally {
            leftReceiver.cancel();
            rightReceiver.cancel();
        }
        DBCStatistics totalStatistics = new DBCStatistics();
        totalStatistics.accumulate(leftReceiver.getStatistics());
        totalStatistics.accumulate(rightReceiver.getStatistics());
        DCSummaryImpl summary = new DCSummaryImpl(settings, this.changeList, totalStatistics);
        summary.setCompareTime(System.currentTimeMillis() - compareTimeStart);
        summary.setTotalComparedRowsCount(statistics.comparedRowsCount);
        summary.setInsertedRowsCount(statistics.insertedRowsCount);
        summary.setDeletedRowsCount(statistics.deletedRowsCount);
        summary.setModifiedRowsCount(statistics.modifiedRowsCount);
        return summary;
    }

    @NotNull
    private Statistics process(@NotNull DBRProgressMonitor monitor, @NotNull DCDataReceiver leftReceiver, @NotNull DCDataReceiver rightReceiver, @NotNull DCSettings settings, @NotNull Consumer<Statistics> progress) throws InterruptedException {
        DCDataReceiver.Row lastLeftRow = null;
        DCDataReceiver.Row lastRightRow = null;
        boolean leftBehind = false;
        boolean rightBehind = false;
        boolean leftDuplicated = false;
        boolean rightDuplicated = false;
        long comparedRowsCount = 0L;
        long insertedRowsCount = 0L;
        long deletedRowsCount = 0L;
        long modifiedRowsCount = 0L;
        while (this.hasRemaining(monitor, settings, comparedRowsCount)) {
            DCDataReceiver.Row rightRow;
            DCDataReceiver.Row leftRow = leftBehind ? lastLeftRow : leftReceiver.take();
            DCDataReceiver.Row row = rightRow = rightBehind ? lastRightRow : rightReceiver.take();
            if (!leftBehind && lastLeftRow != null && leftRow != null && lastLeftRow.compareKeys(leftRow) == 0) {
                if (!leftDuplicated) {
                    log.warn((Object)(leftReceiver.getInput().getName() + ": Duplicate row (" + String.valueOf(leftRow) + "), skipping"));
                }
                rightBehind = false;
                leftDuplicated = true;
                continue;
            }
            if (!rightBehind && lastRightRow != null && rightRow != null && lastRightRow.compareKeys(rightRow) == 0) {
                if (!rightDuplicated) {
                    log.warn((Object)(rightReceiver.getInput().getName() + ": Duplicate row (" + String.valueOf(rightRow) + "), skipping"));
                }
                leftBehind = false;
                rightDuplicated = true;
                continue;
            }
            leftBehind = false;
            rightBehind = false;
            leftDuplicated = false;
            rightDuplicated = false;
            lastLeftRow = leftRow;
            lastRightRow = rightRow;
            if (leftRow == null && rightRow == null) break;
            ++comparedRowsCount;
            if (leftRow != null && rightRow != null) {
                Map<DBDAttributeValue, DBDAttributeValue> differences;
                int keys = leftRow.compareKeys(rightRow);
                if (keys < 0) {
                    if (settings.isIncludeDeletedRows()) {
                        ++deletedRowsCount;
                        this.changeList.addDelete(leftRow.getKeyValues(), leftRow.getAllValues(settings.getMappings(DCChangeRelation.SOURCE)));
                    }
                    rightBehind = true;
                    continue;
                }
                if (keys > 0) {
                    if (settings.isIncludeInsertedRows()) {
                        ++insertedRowsCount;
                        this.changeList.addInsert(rightRow.getKeyValues(), rightRow.getAllValues(settings.getMappings(DCChangeRelation.TARGET)));
                    }
                    leftBehind = true;
                    continue;
                }
                if (settings.isIncludeModifiedRows() && !(differences = leftRow.compareValues(rightRow)).isEmpty()) {
                    DBDAttributeValue[] sourceValues = differences.keySet().toArray(new DBDAttributeValue[0]);
                    DBDAttributeValue[] targetValues = differences.values().toArray(new DBDAttributeValue[0]);
                    this.changeList.addUpdate(leftRow.getKeyValues(), sourceValues, targetValues);
                    ++modifiedRowsCount;
                }
            } else if (leftRow != null) {
                ++comparedRowsCount;
                if (settings.isIncludeDeletedRows()) {
                    ++deletedRowsCount;
                    this.changeList.addDelete(leftRow.getKeyValues(), leftRow.getAllValues(settings.getMappings(DCChangeRelation.SOURCE)));
                }
            } else {
                ++comparedRowsCount;
                if (settings.isIncludeInsertedRows()) {
                    ++insertedRowsCount;
                    this.changeList.addInsert(rightRow.getKeyValues(), rightRow.getAllValues(settings.getMappings(DCChangeRelation.TARGET)));
                }
            }
            if (comparedRowsCount % (long)(settings.getFetchSize() > 0 ? settings.getFetchSize() : 1000) != 0L) continue;
            progress.accept(new Statistics(comparedRowsCount, insertedRowsCount, deletedRowsCount, modifiedRowsCount));
        }
        Statistics statistics = new Statistics(comparedRowsCount, insertedRowsCount, deletedRowsCount, modifiedRowsCount);
        progress.accept(statistics);
        return statistics;
    }

    private boolean hasRemaining(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings, long comparedRowsCount) {
        long comparedRowsLimit = settings.getComparedRowsLimit();
        long differentRowsLimit = settings.getDifferentRowsLimit();
        return !(comparedRowsLimit != 0L && comparedRowsLimit <= comparedRowsCount || differentRowsLimit != 0L && differentRowsLimit <= (long)this.changeList.size() || monitor.isCanceled());
    }

    @NotNull
    private Consumer<Statistics> createProgressReporter(final @NotNull DBRProgressMonitor monitor, final @NotNull DCSettings settings) {
        final OptionalLong totalRowsCount = this.computeTotalRowsCount(monitor, settings);
        monitor.beginTask(MessageFormat.format("Compare ''{0}'' and ''{1}''", settings.getLeftInput().getName(), settings.getRightInput().getName()), totalRowsCount.isPresent() ? (int)totalRowsCount.getAsLong() : -1);
        return new Consumer<Statistics>(){
            private Statistics previous;

            @Override
            public void accept(Statistics statistics) {
                Statistics delta = this.previous != null ? statistics.delta(this.previous) : statistics;
                this.previous = statistics;
                if (delta.comparedRowsCount == 0L) {
                    return;
                }
                StringJoiner message = new StringJoiner(", ");
                if (settings.isIncludeInsertedRows()) {
                    message.add(MessageFormat.format("{0,number} inserted", delta.insertedRowsCount));
                }
                if (settings.isIncludeDeletedRows()) {
                    message.add(MessageFormat.format("{0,number} deleted", delta.deletedRowsCount));
                }
                if (settings.isIncludeModifiedRows()) {
                    message.add(MessageFormat.format("{0,number} modified", delta.modifiedRowsCount));
                }
                log.info((Object)MessageFormat.format("Compared {0,number} {0,choice,1#row|1<rows}: {1}", delta.comparedRowsCount, message));
                if (totalRowsCount.isPresent()) {
                    monitor.worked((int)delta.comparedRowsCount);
                    monitor.subTask(MessageFormat.format("Processed {0,number}/{1,number} rows ({2}%)", (int)statistics.comparedRowsCount, totalRowsCount.getAsLong(), (int)(statistics.comparedRowsCount * 100L / totalRowsCount.getAsLong())));
                }
            }
        };
    }

    @NotNull
    private OptionalLong computeTotalRowsCount(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) {
        if (settings.isQueryRowsCount()) {
            try {
                monitor.beginTask("Compute rows count", -1);
                OptionalLong optionalLong = this.computeMinimumRowsCount(settings, monitor);
                return optionalLong;
            }
            catch (DBException e) {
                log.warn((Object)"Error counting rows", (Throwable)e);
            }
            finally {
                monitor.done();
            }
        }
        return OptionalLong.empty();
    }

    @NotNull
    private OptionalLong computeMinimumRowsCount(@NotNull DCSettings settings, @NotNull DBRProgressMonitor monitor) throws DBException {
        long leftContainerRowsCount = this.computeRowsCount(settings.getLeftInput().getContainer(), monitor);
        long rightContainerRowsCount = this.computeRowsCount(settings.getRightInput().getContainer(), monitor);
        long totalRowsCount = Math.min(leftContainerRowsCount, rightContainerRowsCount);
        if (settings.getComparedRowsLimit() > 0L) {
            totalRowsCount = Math.min(totalRowsCount, settings.getComparedRowsLimit());
        }
        if (settings.getDifferentRowsLimit() > 0L) {
            totalRowsCount = Math.min(totalRowsCount, settings.getDifferentRowsLimit());
        }
        if (totalRowsCount > 0L) {
            return OptionalLong.of(totalRowsCount);
        }
        return OptionalLong.empty();
    }

    private long computeRowsCount(@NotNull DBSDataContainer container, @NotNull DBRProgressMonitor monitor) throws DBException {
        DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
        AbstractExecutionSource source = new AbstractExecutionSource(container, context, (Object)this);
        Throwable throwable = null;
        Object var6_7 = null;
        try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Count rows for data compare");){
            return container.countData((DBCExecutionSource)source, session, null, 0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private record Statistics(long comparedRowsCount, long insertedRowsCount, long deletedRowsCount, long modifiedRowsCount) {
        @NotNull
        public Statistics delta(@NotNull Statistics previous) {
            return new Statistics(this.comparedRowsCount - previous.comparedRowsCount, this.insertedRowsCount - previous.insertedRowsCount, this.deletedRowsCount - previous.deletedRowsCount, this.modifiedRowsCount - previous.modifiedRowsCount);
        }
    }
}

