/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.ui;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.gcp.GCPCloudProvider;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.ui.provider.BaseCloudConfigurationEditor;
import com.dbeaver.net.auth.gcp.AuthModelGCPAbstract;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.ui.auth.gcp.AuthModelGCPConfigurator;
import java.util.LinkedHashMap;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public class GcpCloudConfigurationEditor
extends BaseCloudConfigurationEditor<GCPCloud, GCPCloudConfiguration, AuthModelGCPConfigurator> {
    private static final Log log = Log.getLog(GcpCloudConfigurationEditor.class);

    protected AuthModelGCPConfigurator createAuthConfigurator(Composite parent, Runnable propertyChangeListener) {
        AuthModelGCPConfigurator iamConfigurator = new AuthModelGCPConfigurator();
        iamConfigurator.setCloudProvided(false);
        iamConfigurator.createIAMAuthControls(this.mainGroup, () -> {
            this.updateSessionActions();
            propertyChangeListener.run();
        }, false);
        iamConfigurator.initAuthTypes();
        return iamConfigurator;
    }

    protected GCPCloud createCloudFromConfiguration(GCPCloudConfiguration configuration) {
        return GCPCloudProvider.getInstance().createCloudFromConfiguration((CPCloudConfiguration)configuration);
    }

    protected boolean isSessionOpen(AuthModelGCPConfigurator configurator, GCPCloudConfiguration curConfiguration) {
        if (curConfiguration != null && configurator != null && configurator.isSSOEnabled()) {
            return GCPCloudProvider.getInstance().createCloudInstance(curConfiguration).getActiveSession() != null;
        }
        return false;
    }

    public void loadSettings(@NotNull GCPCloudConfiguration configuration) {
        super.loadSettings((CPCloudConfiguration)configuration);
        this.mainGroup.setRedraw(false);
        try {
            LinkedHashMap authProperties = new LinkedHashMap();
            AuthModelGCPAbstract.saveCredentialsToMap((AuthModelGCPCredentials)configuration.getDefaultCredentials(), authProperties);
            ((AuthModelGCPConfigurator)this.getDataSourceConfigurator()).loadIAMAuthSettings(authProperties);
            ((AuthModelGCPConfigurator)this.getDataSourceConfigurator()).updateControls();
        }
        finally {
            this.mainGroup.setRedraw(true);
        }
        this.updateSessionActions();
    }

    public void saveSettings(@NotNull GCPCloudConfiguration configuration) {
        super.saveSettings((CPCloudConfiguration)configuration);
        LinkedHashMap authProperties = new LinkedHashMap();
        ((AuthModelGCPConfigurator)this.getDataSourceConfigurator()).saveIAMAuthSettings(authProperties);
        AuthModelGCPAbstract.loadCredentialsFromMap((AuthModelGCPCredentials)configuration.getDefaultCredentials(), authProperties);
    }

    public void resetSettings(@NotNull GCPCloudConfiguration configuration) {
    }
}

