/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.sqf;

import com.intersys.jdbc.CacheDriver;
import com.intersys.sqf.Address;
import com.intersys.sqf.Pipe;
import com.intersys.sqf.Record;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class PipeJDBC
implements Pipe {
    final Address m_shard;
    final Connection m_cconn;
    final PreparedStatement m_preps;
    final List<Integer> m_index = new ArrayList<Integer>(1024);

    public PipeJDBC(Address shard, String query, Properties props) throws SQLException {
        this.m_shard = shard;
        this.m_cconn = new CacheDriver().connect(shard.getJDBCString(), props);
        this.m_preps = this.m_cconn.prepareStatement(query);
    }

    @Override
    public int insert(Record record) throws SQLException {
        assert (!this.m_preps.isClosed());
        int ordinal = 1;
        for (Object f : record.fields) {
            this.m_preps.setObject(ordinal++, f);
        }
        return this.m_preps.executeUpdate();
    }

    @Override
    public void sink(Record record) throws SQLException {
        assert (!this.m_preps.isClosed());
        assert (record.offset >= 0);
        this.m_index.add(record.offset);
        int ordinal = 1;
        for (Object f : record.fields) {
            this.m_preps.setObject(ordinal++, f);
        }
        this.m_preps.addBatch();
    }

    @Override
    public void flush(int[] results) throws SQLException {
        assert (results.length >= this.m_index.size());
        assert (!this.m_preps.isClosed());
        try {
            this.merge(results, this.m_preps.executeBatch());
        }
        catch (BatchUpdateException e) {
            this.merge(results, e.getUpdateCounts());
            throw e;
        }
        finally {
            this.m_index.clear();
        }
    }

    private void merge(int[] global, int[] local) {
        assert (local.length == this.m_index.size());
        int j = 0;
        for (int i : this.m_index) {
            global[i] = local[j++];
        }
    }

    @Override
    public void close() throws SQLException {
        this.m_preps.close();
        this.m_cconn.close();
    }

    public String toString() {
        return this.m_shard.toString();
    }
}

