/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser;

import com.intersys.jdbc.preparser.ITokenEnumerator;
import com.intersys.jdbc.preparser.LinkedListEnumerator;
import com.intersys.jdbc.preparser.Token;
import com.intersys.jdbc.preparser.TokenListNode;

class TokenList {
    int m_Count = 0;
    TokenListNode m_Head = null;
    TokenListNode m_Tail = null;

    TokenList() {
    }

    int Count() {
        return this.m_Count;
    }

    Token GetToken(int index) {
        if (index > this.Count() - 1) {
            try {
                throw new Exception("index " + index + " ArgumentOutOfRange_Index");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TokenListNode node = this.First();
        for (int i = 0; i <= index; ++i) {
            node = node.Next();
        }
        return node.GetValue();
    }

    void SetToken(int index, Token value) {
        if (index > this.Count() - 1) {
            try {
                throw new Exception("index " + index + " ArgumentOutOfRange_Index");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TokenListNode node = this.First();
        for (int i = 0; i < index; ++i) {
            node = node.Next();
        }
        node.SetValue(value);
    }

    public ITokenEnumerator GetEnumerator() {
        return new LinkedListEnumerator(this);
    }

    TokenListNode Append(Token Value) {
        TokenListNode node = new TokenListNode(Value, this);
        if (this.m_Head == null) {
            this.m_Head = node;
        } else {
            this.m_Tail.SetNext(node);
            node.SetPrevious(this.m_Tail);
        }
        this.m_Tail = node;
        ++this.m_Count;
        return node;
    }

    TokenListNode Prepend(Token Value) {
        TokenListNode node = new TokenListNode(Value, this);
        if (this.m_Tail == null) {
            this.m_Tail = node;
        } else {
            this.m_Head.SetPrevious(node);
            node.SetNext(this.m_Head);
        }
        this.m_Head = node;
        ++this.m_Count;
        return node;
    }

    TokenListNode InsertBefore(TokenListNode Before, Token Value) {
        TokenListNode node = new TokenListNode(Value, this);
        TokenListNode prev = Before.Previous();
        node.SetNext(Before);
        node.SetPrevious(prev);
        Before.SetPrevious(node);
        if (prev != null) {
            prev.SetNext(node);
        } else {
            this.m_Head = node;
        }
        ++this.m_Count;
        return node;
    }

    TokenListNode InsertAfter(TokenListNode After, Token Value) {
        TokenListNode node = new TokenListNode(Value, this);
        TokenListNode next = After.Next();
        node.SetNext(next);
        node.SetPrevious(After);
        After.SetNext(node);
        if (next != null) {
            next.SetPrevious(node);
        } else {
            this.m_Tail = node;
        }
        ++this.m_Count;
        return node;
    }

    void Remove(TokenListNode Node2) {
        if (Node2 == null) {
            try {
                throw new Exception("Attempt to remove null node, TokenListNode");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_Head == null) {
            try {
                throw new Exception("Attempt to remove node from empty list, TokenListNode");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TokenListNode prev = Node2.Previous();
        TokenListNode next = Node2.Next();
        if (Node2 == this.m_Head && Node2 == this.m_Tail) {
            this.m_Tail = null;
            this.m_Head = null;
        } else if (Node2 == this.m_Head) {
            this.m_Head = next;
            this.m_Head.SetPrevious(null);
        } else if (Node2 == this.m_Tail) {
            this.m_Tail = prev;
            this.m_Tail.SetNext(null);
        } else {
            next.SetPrevious(prev);
            prev.SetNext(next);
        }
        --this.m_Count;
    }

    TokenListNode First() {
        return this.m_Head;
    }

    TokenListNode Last() {
        return this.m_Tail;
    }
}

