/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftSharedSchema;
import com.dbeaver.db.redshift.model.RedshiftSharedTableColumn;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class RedshiftSharedTable
extends JDBCTable<RedshiftDataSource, RedshiftSharedSchema>
implements DBPImageProvider,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftSharedTable.class);
    private final boolean isView;
    private final ColumnCache columnCache = new ColumnCache();
    private final String acl;
    private final String description;

    public RedshiftSharedTable(RedshiftSharedSchema schema, JDBCResultSet resultSet) {
        super((DBSObject)schema, true);
        this.setName(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"table_name"));
        this.acl = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"table_acl");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"remarks");
        this.isView = !CommonUtils.toString((Object)JDBCUtils.safeGetString((ResultSet)resultSet, (String)"table_type")).toUpperCase().contains("TABLE");
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=20)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=10)
    public String getAcl() {
        return this.acl;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public JDBCStructCache<RedshiftSharedSchema, ? extends DBSEntity, ? extends DBSEntityAttribute> getCache() {
        return null;
    }

    public boolean isView() {
        return this.isView;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public List<RedshiftSharedTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.columnCache.getAllObjects(monitor, this);
    }

    @Nullable
    public RedshiftSharedTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.columnCache.getObject(monitor, this, attributeName);
    }

    @Nullable
    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((RedshiftSharedSchema)this.getContainer()).getDatabase(), this.getContainer(), this});
    }

    @Nullable
    public DBPImage getObjectImage() {
        return this.isView ? DBIcon.TREE_VIEW_SHARED : DBIcon.TREE_TABLE_SHARED;
    }

    private static class ColumnCache
    extends AbstractObjectCache<RedshiftSharedTable, RedshiftSharedTableColumn> {
        private ColumnCache() {
        }

        @NotNull
        public List<RedshiftSharedTableColumn> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable RedshiftSharedTable table) throws DBException {
            if (!monitor.isForceCacheUsage() && !this.isFullyCached()) {
                this.readAttributes(monitor, table);
            }
            return this.getCachedObjects();
        }

        private void readAttributes(DBRProgressMonitor monitor, RedshiftSharedTable table) throws DBCException {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)table, (String)"Read external table columns");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT * FROM " + table.getFullyQualifiedName(DBPEvaluationContext.DML) + " WHERE 1<>1 LIMIT 0");){
                            ResultSetMetaData metaData = dbResult.getMetaData();
                            ArrayList<RedshiftSharedTableColumn> columns = new ArrayList<RedshiftSharedTableColumn>();
                            int i = 0;
                            while (i < metaData.getColumnCount()) {
                                int idx = i + 1;
                                columns.add(new RedshiftSharedTableColumn(table, true, metaData.getColumnName(idx), metaData.getColumnTypeName(idx), metaData.getColumnType(idx), idx, metaData.getColumnDisplaySize(idx), metaData.getScale(idx), metaData.getPrecision(idx), metaData.isNullable(idx) == 0, metaData.isAutoIncrement(idx), null));
                                ++i;
                            }
                            this.setCache(columns);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new DBCException("Error reading fro mexternal table", (Throwable)e);
            }
        }

        @Nullable
        public RedshiftSharedTableColumn getObject(@NotNull DBRProgressMonitor monitor, @NotNull RedshiftSharedTable table, @NotNull String name) throws DBException {
            return (RedshiftSharedTableColumn)DBUtils.findObject(this.getAllObjects(monitor, table), (String)name, (boolean)false);
        }
    }
}

