/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftSharedDatabase;
import com.dbeaver.db.redshift.model.RedshiftSharedTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.ListCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class RedshiftSharedSchema
implements DBSSchema,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftSharedSchema.class);
    private final RedshiftSharedDatabase database;
    private final String name;
    private final String acl;
    private final String options;
    private ListCache<RedshiftSharedSchema, RedshiftSharedTable> tableCache = null;

    public RedshiftSharedSchema(RedshiftSharedDatabase database, ResultSet resultSet) {
        this.database = database;
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"schema_name");
        this.acl = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"schema_acl");
        this.options = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"schema_option");
    }

    @Nullable
    public RedshiftSharedDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public RedshiftSharedDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=5)
    public String getOptions() {
        return this.options;
    }

    @Property(viewable=true, order=10)
    public String getAcl() {
        return this.acl;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache = null;
        return this;
    }

    public ListCache<RedshiftSharedSchema, RedshiftSharedTable> getTableCache() {
        return this.tableCache;
    }

    public List<RedshiftSharedTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!monitor.isForceCacheUsage()) {
            this.readTables(monitor);
        }
        return this.tableCache == null ? null : this.tableCache.getCachedObjects();
    }

    public void readTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.tableCache == null) {
            ArrayList<RedshiftSharedTable> tables = new ArrayList<RedshiftSharedTable>();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read shared tables");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.svv_redshift_tables\nWHERE database_name=? AND schema_name=?\nORDER BY table_name");){
                        dbStat.setString(1, this.getDatabase().getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet resultSet = dbStat.executeQuery();){
                            while (resultSet.next()) {
                                tables.add(new RedshiftSharedTable(this, resultSet));
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
            this.tableCache = new ListCache(tables);
        }
    }

    public List<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getTables(monitor);
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (!monitor.isForceCacheUsage()) {
            this.readTables(monitor);
        }
        return this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return RedshiftSharedTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.readTables(monitor);
    }
}

