/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.subscription.models.PutAliasRequestProperties;
import java.io.IOException;

public final class PutAliasRequest
implements JsonSerializable<PutAliasRequest> {
    private PutAliasRequestProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(PutAliasRequest.class);

    public PutAliasRequestProperties properties() {
        return this.properties;
    }

    public PutAliasRequest withProperties(PutAliasRequestProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model PutAliasRequest"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static PutAliasRequest fromJson(JsonReader jsonReader) throws IOException {
        return (PutAliasRequest)jsonReader.readObject(reader -> {
            PutAliasRequest deserializedPutAliasRequest = new PutAliasRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedPutAliasRequest.properties = PutAliasRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPutAliasRequest;
        });
    }
}

