/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.SerializableComment;
import com.microsoft.schemas.vml.CTShape;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

public class DelegatingXSSFComment
extends XSSFComment {
    private final SerializableComment delegate;
    private final Comments comments;
    private final CTShape ctShape;

    DelegatingXSSFComment(Comments comments, SerializableComment delegate, CTShape ctShape) {
        super(comments, null, ctShape);
        this.comments = comments;
        this.delegate = delegate;
        this.ctShape = ctShape;
    }

    public String getAuthor() {
        return this.delegate.getAuthor();
    }

    public int getColumn() {
        return this.delegate.getColumn();
    }

    public int getRow() {
        return this.delegate.getRow();
    }

    public boolean isVisible() {
        return this.delegate.isVisible();
    }

    public CellAddress getAddress() {
        return this.delegate.getAddress();
    }

    public XSSFRichTextString getString() {
        return this.delegate.getString();
    }

    public String getCommentText() {
        return this.delegate.getCommentText();
    }

    public CTComment getCTComment() {
        CTRst rst = this.delegate.getString().getCTRst();
        CTComment ctComment = (CTComment)CTComment.Factory.newInstance();
        ctComment.setText(rst);
        return ctComment;
    }

    public void setAddress(int row, int col) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setAddress(row, col);
        this.comments.referenceUpdated(oldAddress, (XSSFComment)this);
    }

    public void setAddress(CellAddress address) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setAddress(address);
        this.comments.referenceUpdated(oldAddress, (XSSFComment)this);
    }

    public void setRow(int row) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setRow(row);
        this.comments.referenceUpdated(oldAddress, (XSSFComment)this);
    }

    public void setColumn(int col) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setColumn(col);
        this.comments.referenceUpdated(oldAddress, (XSSFComment)this);
    }

    public void setString(RichTextString string) {
        this.delegate.setString(string);
        this.comments.commentUpdated((XSSFComment)this);
    }

    public void setString(String string) {
        this.delegate.setString(string);
        this.comments.commentUpdated((XSSFComment)this);
    }

    public void setAuthor(String author) {
        this.delegate.setAuthor(author);
        this.comments.commentUpdated((XSSFComment)this);
    }

    public void setVisible(boolean visible) {
        this.delegate.setVisible(visible);
        this.comments.commentUpdated((XSSFComment)this);
    }

    protected CTShape getCTShape() {
        return this.ctShape;
    }
}

